/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.adaptor.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import org.eclipse.osgi.framework.adaptor.core.BundleFile;
import org.eclipse.osgi.framework.util.SecureAction;

public abstract class BundleEntry {
    public abstract InputStream getInputStream() throws IOException;

    public abstract long getSize();

    public abstract String getName();

    public abstract long getTime();

    public abstract URL getLocalURL();

    public abstract URL getFileURL();

    public String toString() {
        return this.getName();
    }

    public static class ZipBundleEntry
    extends BundleEntry {
        protected ZipEntry zipEntry;
        protected BundleFile bundleFile;

        protected ZipBundleEntry(ZipEntry entry, BundleFile bundleFile) {
            this.zipEntry = entry;
            this.bundleFile = bundleFile;
        }

        public InputStream getInputStream() throws IOException {
            return ((BundleFile.ZipBundleFile)this.bundleFile).getZipFile().getInputStream(this.zipEntry);
        }

        public long getSize() {
            return this.zipEntry.getSize();
        }

        public String getName() {
            return this.zipEntry.getName();
        }

        public long getTime() {
            return this.zipEntry.getTime();
        }

        public URL getLocalURL() {
            try {
                return new URL("jar:file:" + this.bundleFile.basefile.getAbsolutePath() + "!/" + this.zipEntry.getName());
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }

        public URL getFileURL() {
            try {
                File file = this.bundleFile.getFile(this.zipEntry.getName());
                return file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
    }

    public static class FileBundleEntry
    extends BundleEntry {
        private File file;
        private String name;

        FileBundleEntry(File file, String name) {
            this.file = file;
            this.name = name;
        }

        public InputStream getInputStream() throws IOException {
            return SecureAction.getFileInputStream(this.file);
        }

        public long getSize() {
            return this.file.length();
        }

        public String getName() {
            return this.name;
        }

        public long getTime() {
            return this.file.lastModified();
        }

        public URL getLocalURL() {
            return this.getFileURL();
        }

        public URL getFileURL() {
            try {
                return this.file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
    }

    public static class DirZipBundleEntry
    extends BundleEntry {
        private BundleFile.ZipBundleFile bundleFile;
        private String name;

        public DirZipBundleEntry(BundleFile.ZipBundleFile bundleFile, String name) {
            this.name = name.length() > 0 && name.charAt(0) == '/' ? name.substring(1) : name;
            this.bundleFile = bundleFile;
        }

        public InputStream getInputStream() throws IOException {
            return null;
        }

        public long getSize() {
            return 0L;
        }

        public String getName() {
            return this.name;
        }

        public long getTime() {
            return 0L;
        }

        public URL getLocalURL() {
            try {
                return new URL("jar:file:" + this.bundleFile.basefile.getAbsolutePath() + "!/" + this.name);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }

        public URL getFileURL() {
            try {
                return this.bundleFile.extractDirectory(this.name).toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
    }
}

