/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.defaultadaptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.adaptor.core.AbstractBundleData;
import org.eclipse.osgi.framework.adaptor.core.AbstractClassLoader;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.adaptor.core.BundleEntry;
import org.eclipse.osgi.framework.adaptor.core.BundleFile;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.defaultadaptor.DevClassPathHelper;
import org.osgi.framework.BundleException;

public class DefaultClassLoader
extends AbstractClassLoader {
    protected AbstractBundleData hostdata;
    protected ClasspathEntry[] classpathEntries;
    protected Vector fragClasspaths;
    protected int buffersize = 8192;

    public DefaultClassLoader(ClassLoaderDelegate delegate, ProtectionDomain domain, String[] classpath, ClassLoader parent, AbstractBundleData bundledata) {
        super(delegate, domain, classpath, parent);
        this.hostdata = bundledata;
        try {
            this.hostdata.open();
        }
        catch (IOException e) {
            this.hostdata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, this.hostdata.getBundle(), e);
        }
    }

    public void initialize() {
        this.classpathEntries = this.buildClasspath(this.hostclasspath, this.hostdata, this.hostdomain);
    }

    public void attachFragment(BundleData bundledata, ProtectionDomain domain, String[] classpath) {
        AbstractBundleData abstractbundledata = (AbstractBundleData)bundledata;
        try {
            bundledata.open();
        }
        catch (IOException e) {
            abstractbundledata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, abstractbundledata.getBundle(), e);
        }
        ClasspathEntry[] fragEntries = this.buildClasspath(classpath, abstractbundledata, domain);
        FragmentClasspath fragClasspath = new FragmentClasspath(fragEntries, abstractbundledata, domain);
        this.insertFragment(fragClasspath);
    }

    protected synchronized void insertFragment(FragmentClasspath fragClasspath) {
        if (this.fragClasspaths == null) {
            this.fragClasspaths = new Vector(10);
            this.fragClasspaths.addElement(fragClasspath);
            return;
        }
        int size = this.fragClasspaths.size();
        long fragID = fragClasspath.bundledata.getBundleID();
        int i = 0;
        while (i < size) {
            long otherID = ((FragmentClasspath)this.fragClasspaths.elementAt((int)i)).bundledata.getBundleID();
            if (fragID < otherID) {
                this.fragClasspaths.insertElementAt(fragClasspath, i);
                return;
            }
            ++i;
        }
        this.fragClasspaths.addElement(fragClasspath);
    }

    protected String getBundleSymbolicName() {
        return String.valueOf(this.hostdata.getSymbolicName()) + "_" + this.hostdata.getVersion();
    }

    protected ClasspathEntry getClasspath(String cp, AbstractBundleData bundledata, ProtectionDomain domain) {
        BundleFile bundlefile = null;
        File file = bundledata.getBaseBundleFile().getFile(cp);
        if (file != null && file.exists()) {
            try {
                bundlefile = this.hostdata.getAdaptor().createBundleFile(file, bundledata);
            }
            catch (IOException e) {
                bundledata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, bundledata.getBundle(), e);
            }
        } else if (bundledata.getBaseBundleFile().containsDir(cp)) {
            bundlefile = new BundleFile.NestedDirBundleFile(bundledata.getBaseBundleFile(), cp);
        }
        if (bundlefile == null && DevClassPathHelper.inDevelopmentMode() && (file = new File(cp)).exists() && file.isAbsolute()) {
            try {
                bundlefile = this.hostdata.getAdaptor().createBundleFile(file, bundledata);
            }
            catch (IOException e) {
                bundledata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, bundledata.getBundle(), e);
            }
        }
        if (bundlefile != null) {
            return this.createClassPathEntry(bundlefile, domain);
        }
        return null;
    }

    protected synchronized Class findClass(String name) throws ClassNotFoundException {
        ClassLoader parent;
        Class result = this.findLoadedClass(name);
        if (result != null) {
            return result;
        }
        int i = 0;
        while (i < this.classpathEntries.length) {
            if (this.classpathEntries[i] != null && (result = this.findClassImpl(name, this.classpathEntries[i])) != null) {
                return result;
            }
            ++i;
        }
        if (this.fragClasspaths != null) {
            int size = this.fragClasspaths.size();
            int i2 = 0;
            while (i2 < size) {
                FragmentClasspath fragCP = (FragmentClasspath)this.fragClasspaths.elementAt(i2);
                int j = 0;
                while (j < fragCP.classpathEntries.length) {
                    result = this.findClassImpl(name, fragCP.classpathEntries[j]);
                    if (result != null) {
                        return result;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        if (!name.startsWith("java.") && (parent = this.getParentPrivileged()) != null) {
            try {
                return parent.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Class findClassImpl(String name, ClasspathEntry classpathEntry) {
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleClassLoader[" + this.hostdata + "].findClass(" + name + ")");
        }
        filename = name.replace('.', '/').concat(".class");
        entry = classpathEntry.getBundleFile().getEntry(filename);
        if (entry == null) {
            return null;
        }
        try {
            in = entry.getInputStream();
        }
        catch (IOException v0) {
            return null;
        }
        length = (int)entry.getSize();
        bytesread = 0;
        if (Debug.DEBUG_LOADER) {
            Debug.println("  about to read " + length + " bytes from " + filename);
        }
        try {
            try {
                block22: {
                    if (length <= 0) break block22;
                    classbytes = new byte[length];
                    while (bytesread < length && (readcount = in.read(classbytes, bytesread, length - bytesread)) > 0) {
                        bytesread += readcount;
                    }
                    ** GOTO lbl-1000
                }
                length = this.buffersize;
                classbytes = new byte[length];
                while (true) {
                    if (bytesread >= length) {
                        oldbytes = classbytes;
                        classbytes = new byte[length += this.buffersize];
                        System.arraycopy(oldbytes, 0, classbytes, 0, bytesread);
                        continue;
                    }
                    readcount = in.read(classbytes, bytesread, length - bytesread);
                    if (readcount > 0) {
                        bytesread += readcount;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException v1) {
                if (Debug.DEBUG_LOADER) {
                    Debug.println("  IOException reading " + filename + " from " + this.hostdata);
                }
                var13_13 = null;
                var11_14 = null;
                try {
                    in.close();
                    return var13_13;
                }
                catch (IOException v2) {}
                return var13_13;
            }
        }
        catch (Throwable var12_17) {
            var11_15 = null;
            try {}
            catch (IOException v3) {}
            in.close();
            throw var12_17;
            throw var12_17;
        }
lbl-1000:
        // 2 sources

        {
            var11_16 = null;
        }
        try {}
        catch (IOException v4) {}
        in.close();
        if (Debug.DEBUG_LOADER) {
            Debug.println("  read " + bytesread + " bytes from " + filename);
            Debug.println("  defining class " + name);
        }
        try {
            return this.defineClass(name, classbytes, 0, bytesread, classpathEntry);
        }
        catch (Error e) {
            if (Debug.DEBUG_LOADER == false) throw e;
            Debug.println("  error defining class " + name);
            throw e;
        }
    }

    protected Class defineClass(String name, byte[] classbytes, int off, int len, ClasspathEntry classpathEntry) throws ClassFormatError {
        if (name != null && name.startsWith("java.")) {
            name = null;
        }
        return this.defineClass(name, classbytes, off, len, classpathEntry.getProtectionDomain());
    }

    protected URL findResource(String name) {
        URL result = null;
        int i = 0;
        while (i < this.classpathEntries.length) {
            if (this.classpathEntries[i] != null && (result = this.findResourceImpl(name, this.classpathEntries[i].getBundleFile())) != null) {
                return result;
            }
            ++i;
        }
        if (this.fragClasspaths != null) {
            int size = this.fragClasspaths.size();
            int i2 = 0;
            while (i2 < size) {
                FragmentClasspath fragCP = (FragmentClasspath)this.fragClasspaths.elementAt(i2);
                int j = 0;
                while (j < fragCP.classpathEntries.length) {
                    result = this.findResourceImpl(name, fragCP.classpathEntries[j].getBundleFile());
                    if (result != null) {
                        return result;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        return null;
    }

    protected URL findResourceImpl(String name, BundleFile bundlefile) {
        return this.findResourceImpl(name, bundlefile, 0);
    }

    protected URL findResourceImpl(String name, BundleFile bundlefile, int index) {
        return bundlefile.getResourceURL(name, this.hostdata.getBundleID(), index);
    }

    public Enumeration findLocalResources(String resource) {
        Vector<URL> resources = new Vector<URL>(6);
        int i = 0;
        while (i < this.classpathEntries.length) {
            URL url;
            if (this.classpathEntries[i] != null && (url = this.findResourceImpl(resource, this.classpathEntries[i].getBundleFile(), resources.size())) != null) {
                resources.addElement(url);
            }
            ++i;
        }
        if (this.fragClasspaths != null) {
            int size = this.fragClasspaths.size();
            int i2 = 0;
            while (i2 < size) {
                FragmentClasspath fragCP = (FragmentClasspath)this.fragClasspaths.elementAt(i2);
                int j = 0;
                while (j < fragCP.classpathEntries.length) {
                    URL url = this.findResourceImpl(resource, fragCP.classpathEntries[j].getBundleFile(), resources.size());
                    if (url != null) {
                        resources.addElement(url);
                    }
                    ++j;
                }
                ++i2;
            }
        }
        if (resources.size() > 0) {
            return resources.elements();
        }
        return null;
    }

    public Object findLocalObject(String object) {
        BundleEntry result = null;
        int i = 0;
        while (i < this.classpathEntries.length) {
            if (this.classpathEntries[i] != null && (result = this.findObjectImpl(object, this.classpathEntries[i].getBundleFile())) != null) {
                return result;
            }
            ++i;
        }
        if (this.fragClasspaths != null) {
            int size = this.fragClasspaths.size();
            int i2 = 0;
            while (i2 < size) {
                FragmentClasspath fragCP = (FragmentClasspath)this.fragClasspaths.elementAt(i2);
                int j = 0;
                while (j < fragCP.classpathEntries.length) {
                    result = this.findObjectImpl(object, fragCP.classpathEntries[j].getBundleFile());
                    if (result != null) {
                        return result;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        return null;
    }

    public Enumeration findLocalObjects(String object) {
        Vector<BundleEntry> objects = new Vector<BundleEntry>(6);
        int i = 0;
        while (i < this.classpathEntries.length) {
            BundleEntry result;
            if (this.classpathEntries[i] != null && (result = this.findObjectImpl(object, this.classpathEntries[i].getBundleFile())) != null) {
                objects.addElement(result);
            }
            ++i;
        }
        if (this.fragClasspaths != null) {
            int size = this.fragClasspaths.size();
            int i2 = 0;
            while (i2 < size) {
                FragmentClasspath fragCP = (FragmentClasspath)this.fragClasspaths.elementAt(i2);
                int j = 0;
                while (j < fragCP.classpathEntries.length) {
                    BundleEntry result = this.findObjectImpl(object, fragCP.classpathEntries[j].getBundleFile());
                    if (result != null) {
                        objects.addElement(result);
                    }
                    ++j;
                }
                ++i2;
            }
        }
        if (objects.size() > 0) {
            return objects.elements();
        }
        return null;
    }

    protected BundleEntry findObjectImpl(String object, BundleFile bundleFile) {
        return bundleFile.getEntry(object);
    }

    public void close() {
        if (this.closed || this.hostdata.getAdaptor().isStopping()) {
            return;
        }
        super.close();
        if (this.classpathEntries != null) {
            int i = 0;
            while (i < this.classpathEntries.length) {
                if (this.classpathEntries[i] != null) {
                    try {
                        if (this.classpathEntries[i].getBundleFile() != this.hostdata.getBaseBundleFile()) {
                            this.classpathEntries[i].getBundleFile().close();
                        }
                    }
                    catch (IOException e) {
                        this.hostdata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, this.hostdata.getBundle(), e);
                    }
                }
                ++i;
            }
        }
        if (this.fragClasspaths != null) {
            int size = this.fragClasspaths.size();
            int i = 0;
            while (i < size) {
                FragmentClasspath fragCP = (FragmentClasspath)this.fragClasspaths.elementAt(i);
                fragCP.close();
                ++i;
            }
        }
    }

    protected ClasspathEntry[] buildClasspath(String[] classpath, AbstractBundleData bundledata, ProtectionDomain domain) {
        ArrayList result = new ArrayList(classpath.length);
        if (!DevClassPathHelper.inDevelopmentMode()) {
            int i = 0;
            while (i < classpath.length) {
                this.findClassPathEntry(result, classpath[i], bundledata, domain);
                ++i;
            }
            return result.toArray(new ClasspathEntry[result.size()]);
        }
        this.addDefaultDevEntries(result, bundledata, domain);
        int i = 0;
        while (i < classpath.length) {
            String[] devEntries = this.getDevEntries(classpath[i], bundledata);
            if (devEntries != null && devEntries.length > 0) {
                int j = 0;
                while (j < devEntries.length) {
                    this.findClassPathEntry(result, devEntries[j], bundledata, domain);
                    ++j;
                }
            } else {
                this.findClassPathEntry(result, classpath[i], bundledata, domain);
            }
            ++i;
        }
        return result.toArray(new ClasspathEntry[result.size()]);
    }

    protected void addDefaultDevEntries(ArrayList result, AbstractBundleData bundledata, ProtectionDomain domain) {
        String[] devClassPath = DevClassPathHelper.getDevClassPath(bundledata.getSymbolicName());
        if (devClassPath == null) {
            return;
        }
        int i = 0;
        while (i < devClassPath.length) {
            this.findClassPathEntry(result, devClassPath[i], bundledata, domain);
            ++i;
        }
    }

    protected void findClassPathEntry(ArrayList result, String entry, AbstractBundleData bundledata, ProtectionDomain domain) {
        this.addClassPathEntry(result, entry, bundledata, domain);
    }

    protected boolean addClassPathEntry(ArrayList result, String entry, AbstractBundleData bundledata, ProtectionDomain domain) {
        if (entry.equals(".")) {
            result.add(this.createClassPathEntry(bundledata.getBaseBundleFile(), domain));
            return true;
        }
        ClasspathEntry element = this.getClasspath(entry, bundledata, domain);
        if (element != null) {
            result.add(element);
            return true;
        }
        if (this.fragClasspaths != null && this.hostdata == bundledata) {
            int size = this.fragClasspaths.size();
            int i = 0;
            while (i < size) {
                FragmentClasspath fragCP = (FragmentClasspath)this.fragClasspaths.elementAt(i);
                element = this.getClasspath(entry, fragCP.bundledata, fragCP.domain);
                if (element != null) {
                    result.add(element);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected String[] getDevEntries(String classpathEntry, AbstractBundleData bundledata) {
        File propLocation = bundledata.getBaseBundleFile().getFile(String.valueOf(classpathEntry) + ".properties");
        if (propLocation == null) {
            return null;
        }
        try {
            String[] stringArray;
            FileInputStream in = new FileInputStream(propLocation);
            try {
                Properties devProps = new Properties();
                devProps.load(in);
                stringArray = DevClassPathHelper.getArrayFromList(devProps.getProperty("bin"));
                Object var6_9 = null;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            return stringArray;
        }
        catch (IOException e) {
            BundleException be = new BundleException(AdaptorMsg.formatter.getString("BUNDLE_CLASSPATH_PROPERTIES_ERROR", propLocation), e);
            bundledata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, bundledata.getBundle(), be);
            return null;
        }
    }

    protected ClasspathEntry createClassPathEntry(BundleFile bundlefile, ProtectionDomain domain) {
        return new ClasspathEntry(bundlefile, domain);
    }

    protected class FragmentClasspath {
        protected ClasspathEntry[] classpathEntries;
        protected AbstractBundleData bundledata;
        protected ProtectionDomain domain;

        protected FragmentClasspath(ClasspathEntry[] classpathEntries, AbstractBundleData bundledata, ProtectionDomain domain) {
            this.classpathEntries = classpathEntries;
            this.bundledata = bundledata;
            this.domain = domain;
        }

        protected void close() {
            int i = 0;
            while (i < this.classpathEntries.length) {
                try {
                    if (this.classpathEntries[i].getBundleFile() != this.bundledata.getBaseBundleFile()) {
                        this.classpathEntries[i].getBundleFile().close();
                    }
                }
                catch (IOException e) {
                    this.bundledata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, this.bundledata.getBundle(), e);
                }
                ++i;
            }
        }
    }

    protected class ClasspathEntry {
        protected BundleFile bundlefile;
        protected ProtectionDomain domain;

        protected ClasspathEntry(BundleFile bundlefile, ProtectionDomain domain) {
            this.bundlefile = bundlefile;
            this.domain = domain;
        }

        public BundleFile getBundleFile() {
            return this.bundlefile;
        }

        public ProtectionDomain getProtectionDomain() {
            return this.domain;
        }
    }
}

