/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.DebugOptions;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.CyclicDependencyHashMap;
import org.eclipse.osgi.internal.module.GroupingChecker;
import org.eclipse.osgi.internal.module.PermissionChecker;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionHashMap;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public class ResolverImpl
implements Resolver {
    private static final String RESOLVER = "org.eclipse.osgi/resolver";
    private static final String OPTION_DEBUG = "org.eclipse.osgi/resolver/debug";
    private static final String OPTION_WIRING = "org.eclipse.osgi/resolver/wiring";
    private static final String OPTION_IMPORTS = "org.eclipse.osgi/resolver/imports";
    private static final String OPTION_REQUIRES = "org.eclipse.osgi/resolver/requires";
    private static final String OPTION_GROUPING = "org.eclipse.osgi/resolver/grouping";
    private static final String OPTION_CYCLES = "org.eclipse.osgi/resolver/cycles";
    public static boolean DEBUG = false;
    public static boolean DEBUG_WIRING = false;
    public static boolean DEBUG_IMPORTS = false;
    public static boolean DEBUG_REQUIRES = false;
    public static boolean DEBUG_GROUPING = false;
    public static boolean DEBUG_CYCLES = false;
    private HashMap removalPending = new HashMap();
    private State state;
    private VersionHashMap resolverExports = null;
    private VersionHashMap resolverBundles = null;
    private ArrayList unresolvedBundles = null;
    private ArrayList resolvedBundles = null;
    private ArrayList resolvingBundles = null;
    private CyclicDependencyHashMap cyclicDependencies = null;
    private HashMap bundleMapping = null;
    private boolean initialized = false;
    private PermissionChecker permissionChecker;
    private GroupingChecker groupingChecker;
    private BundleContext context;

    public ResolverImpl(BundleContext context, boolean checkPermissions) {
        this.context = context;
        this.permissionChecker = new PermissionChecker(context, checkPermissions);
    }

    protected PermissionChecker getPermissionChecker() {
        return this.permissionChecker;
    }

    private void initialize() {
        this.resolverExports = new VersionHashMap();
        this.resolverBundles = new VersionHashMap();
        this.unresolvedBundles = new ArrayList();
        this.bundleMapping = new HashMap();
        this.cyclicDependencies = new CyclicDependencyHashMap();
        BundleDescription[] bundles = this.state.getBundles();
        this.groupingChecker = new GroupingChecker();
        ArrayList fragmentBundles = new ArrayList();
        int i = 0;
        while (i < bundles.length) {
            this.initResolverBundle(bundles[i], fragmentBundles, false);
            ++i;
        }
        BundleDescription[] removedBundles = this.getRemovalPending();
        int i2 = 0;
        while (i2 < removedBundles.length) {
            this.initResolverBundle(removedBundles[i2], fragmentBundles, true);
            ++i2;
        }
        Iterator iter = fragmentBundles.iterator();
        while (iter.hasNext()) {
            ResolverBundle fragment = (ResolverBundle)iter.next();
            BundleDescription[] hosts = ((HostSpecification)fragment.getHost().getVersionConstraint()).getHosts();
            int i3 = 0;
            while (i3 < hosts.length) {
                ResolverBundle host = (ResolverBundle)this.bundleMapping.get(hosts[i3]);
                if (host != null) {
                    host.attachFragment(fragment, false);
                }
                ++i3;
            }
        }
        this.rewireBundles();
        this.setDebugOptions();
        this.initialized = true;
    }

    private void initResolverBundle(BundleDescription bundleDesc, ArrayList fragmentBundles, boolean pending) {
        ResolverBundle bundle = new ResolverBundle(bundleDesc, this);
        this.bundleMapping.put(bundleDesc, bundle);
        if (pending) {
            return;
        }
        this.resolverBundles.put(bundle);
        if (bundleDesc.isResolved()) {
            bundle.setState(2);
            if (bundleDesc.getHost() != null) {
                fragmentBundles.add(bundle);
            }
        } else {
            this.unresolvedBundles.add(bundle);
        }
        this.resolverExports.put(bundle.getExportPackages());
    }

    private void rewireBundles() {
        Iterator iter = this.bundleMapping.values().iterator();
        while (iter.hasNext()) {
            ResolverBundle rb = (ResolverBundle)iter.next();
            if (!rb.getBundle().isResolved() || rb.isFragment()) continue;
            this.rewireBundle(rb);
        }
    }

    private void rewireBundle(ResolverBundle rb) {
        if (rb.isFullyWired()) {
            return;
        }
        BundleConstraint[] requires = rb.getRequires();
        int i = 0;
        while (i < requires.length) {
            this.rewireRequire(requires[i]);
            ++i;
        }
        ResolverImport[] imports = rb.getImportPackages();
        int i2 = 0;
        while (i2 < imports.length) {
            this.rewireImport(imports[i2]);
            ++i2;
        }
    }

    private void rewireRequire(BundleConstraint req) {
        if (req.getMatchingBundle() != null) {
            return;
        }
        ResolverBundle matchingBundle = (ResolverBundle)this.bundleMapping.get(req.getVersionConstraint().getSupplier());
        req.setMatchingBundle(matchingBundle);
        if (matchingBundle == null && !req.isOptional()) {
            System.err.println("Could not find matching bundle for " + req.getVersionConstraint());
        }
        if (matchingBundle != null) {
            this.rewireBundle(matchingBundle);
        }
    }

    private void rewireImport(ResolverImport imp) {
        if (imp.isDynamic() || imp.getMatchingExport() != null) {
            return;
        }
        ResolverExport matchingExport = null;
        ExportPackageDescription importSupplier = (ExportPackageDescription)imp.getImportPackageSpecification().getSupplier();
        ResolverBundle exporter = importSupplier == null ? null : (ResolverBundle)this.bundleMapping.get(importSupplier.getExporter());
        VersionSupplier[] matches = this.resolverExports.getArray(imp.getName());
        int j = 0;
        while (j < matches.length) {
            ResolverExport export = (ResolverExport)matches[j];
            if (export.getExporter() == exporter && imp.isSatisfiedBy(export)) {
                matchingExport = export;
                break;
            }
            ++j;
        }
        imp.setMatchingExport(matchingExport);
        if (matchingExport == null && exporter != null) {
            ResolverExport reprovidedExport = new ResolverExport(exporter, importSupplier);
            exporter.addExport(reprovidedExport);
            this.resolverExports.put(reprovidedExport);
            imp.setMatchingExport(reprovidedExport);
        }
        if (imp.getMatchingExport() == null && !imp.isOptional()) {
            System.err.println("Could not find matching export for " + imp.getImportPackageSpecification());
        }
        if (imp.getMatchingExport() != null) {
            this.rewireBundle(matchingExport.getExporter());
        }
    }

    private boolean isResolvable(BundleDescription bundle, Dictionary platformProperties) {
        ImportPackageSpecification[] imports = bundle.getImportPackages();
        int i = 0;
        while (i < imports.length) {
            if (imports[i].getResolution() != 4 && imports[i].getName().endsWith("*")) {
                return false;
            }
            int j = 0;
            while (j < i) {
                if (imports[i] != imports[j] && imports[i].getName().equals(imports[j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        String platformFilter = bundle.getPlatformFilter();
        if (platformFilter == null) {
            return true;
        }
        if (platformProperties == null) {
            return false;
        }
        try {
            Filter filter = this.context.createFilter(platformFilter);
            return filter.match(platformProperties);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
    }

    private void attachFragment(ResolverBundle bundle) {
        if (!bundle.isFragment() || !bundle.isResolvable()) {
            return;
        }
        BundleConstraint hostConstraint = bundle.getHost();
        VersionSupplier[] hosts = this.resolverBundles.getArray(hostConstraint.getVersionConstraint().getName());
        int i = 0;
        while (i < hosts.length) {
            if (((ResolverBundle)hosts[i]).isResolvable() && hostConstraint.isSatisfiedBy((ResolverBundle)hosts[i])) {
                this.resolverExports.put(((ResolverBundle)hosts[i]).attachFragment(bundle, true));
            }
            ++i;
        }
    }

    public synchronized void resolve(BundleDescription[] reRefresh, Dictionary platformProperties) {
        if (DEBUG) {
            ResolverImpl.log("*** BEGIN RESOLUTION ***");
        }
        if (this.state == null) {
            throw new IllegalStateException("RESOLVER_NO_STATE");
        }
        if (!this.initialized) {
            this.initialize();
        }
        if (reRefresh != null) {
            int i = 0;
            while (i < reRefresh.length) {
                ResolverBundle rb = (ResolverBundle)this.bundleMapping.get(reRefresh[i]);
                if (rb != null) {
                    this.unresolveBundle(rb, false);
                }
                ++i;
            }
        }
        this.resolvingBundles = new ArrayList(this.unresolvedBundles.size());
        this.resolvedBundles = new ArrayList(this.unresolvedBundles.size());
        ResolverBundle[] bundles = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
        this.groupingChecker.addInitialGroupingConstraints(bundles);
        int i = 0;
        while (i < bundles.length) {
            bundles[i].setResolvable(this.isResolvable(bundles[i].getBundle(), platformProperties));
            ++i;
        }
        i = 0;
        while (i < bundles.length) {
            this.attachFragment(bundles[i]);
            ++i;
        }
        i = 0;
        while (i < bundles.length) {
            if (DEBUG) {
                ResolverImpl.log("** RESOLVING " + bundles[i] + " **");
            }
            this.resolveBundle(bundles[i]);
            while (this.resolvingBundles.size() > 0) {
                ResolverBundle rb = (ResolverBundle)this.resolvingBundles.get(0);
                ResolverImport[] imports = rb.getImportPackages();
                boolean needRewire = false;
                int j = 0;
                while (j < imports.length) {
                    if (imports[j].getMatchingExport() != null && !this.resolverExports.contains(imports[j].getMatchingExport())) {
                        imports[j].setMatchingExport(null);
                        needRewire = true;
                    }
                    ++j;
                }
                if (needRewire) {
                    this.resolveBundle(rb);
                }
                if (!rb.isFullyWired()) continue;
                if (DEBUG || DEBUG_CYCLES) {
                    ResolverImpl.log("Pushing " + rb + " to RESOLVED");
                }
                this.setBundleResolved(rb);
            }
            ++i;
        }
        if (this.unresolvedBundles.size() > 0) {
            bundles = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
            i = 0;
            while (i < bundles.length) {
                this.resolveFragment(bundles[i]);
                ++i;
            }
        }
        if (DEBUG_WIRING) {
            this.printWirings();
        }
        this.stateResolveBundles();
        this.resolvingBundles = null;
        this.resolvedBundles = null;
        if (DEBUG) {
            ResolverImpl.log("*** END RESOLUTION ***");
        }
    }

    private void resolveFragment(ResolverBundle fragment) {
        if (!fragment.isFragment()) {
            return;
        }
        if (fragment.getHost().foundMatchingBundles()) {
            this.setBundleResolved(fragment);
        }
    }

    private boolean resolveBundle(ResolverBundle bundle) {
        ArrayList v;
        int i;
        VersionSupplier[] sameName;
        if (bundle.isFragment()) {
            return false;
        }
        if (!bundle.isResolvable()) {
            if (DEBUG) {
                ResolverImpl.log("  - " + bundle + " is unresolvable");
            }
            return false;
        }
        if (bundle.getState() == 2) {
            if (DEBUG) {
                ResolverImpl.log("  - " + bundle + " already resolved");
            }
            return true;
        }
        if (bundle.getState() == 0) {
            bundle.clearWires();
            this.setBundleResolving(bundle);
        }
        boolean failed = false;
        if (bundle.getBundle().isSingleton() && (sameName = this.resolverBundles.getArray(bundle.getName())).length > 1) {
            i = 0;
            while (i < sameName.length) {
                if (sameName[i] != bundle && sameName[i].getBundle().isSingleton()) {
                    if (((ResolverBundle)sameName[i]).isResolved()) {
                        failed = true;
                        break;
                    }
                    if (sameName[i].getVersion().compareTo(bundle.getVersion()) > 0 && this.resolveBundle((ResolverBundle)sameName[i])) {
                        failed = true;
                        break;
                    }
                }
                ++i;
            }
        }
        if (!failed) {
            BundleConstraint[] requires = bundle.getRequires();
            i = 0;
            while (i < requires.length) {
                if (!this.resolveRequire(requires[i])) {
                    if (DEBUG || DEBUG_REQUIRES) {
                        ResolverImpl.log("** REQUIRE " + requires[i].getVersionConstraint().getName() + "[" + requires[i].getActualBundle() + "] failed to resolve");
                    }
                    if (requires[i].isFromFragment()) {
                        this.resolverExports.remove(bundle.detachFragment((ResolverBundle)this.bundleMapping.get(requires[i].getVersionConstraint().getBundle())));
                    } else {
                        failed = true;
                        break;
                    }
                }
                ++i;
            }
        }
        if (!failed) {
            ResolverImport[] imports = bundle.getImportPackages();
            i = 0;
            while (i < imports.length) {
                if (!imports[i].isDynamic() && !this.resolveImport(imports[i], true)) {
                    if (DEBUG || DEBUG_IMPORTS) {
                        ResolverImpl.log("** IMPORT " + imports[i].getName() + "[" + imports[i].getActualBundle() + "] failed to resolve");
                    }
                    if (imports[i].isFromFragment()) {
                        this.resolverExports.remove(bundle.detachFragment((ResolverBundle)this.bundleMapping.get(imports[i].getImportPackageSpecification().getBundle())));
                    } else {
                        failed = true;
                        break;
                    }
                }
                ++i;
            }
        }
        boolean fullyWired = bundle.isFullyWired();
        if (!failed && fullyWired && !bundle.isDependentOnCycle()) {
            if (!this.groupingChecker.checkRequiresConstraints(bundle)) {
                this.setBundleUnresolved(bundle, false);
                if (DEBUG) {
                    ResolverImpl.log(bundle + " NOT RESOLVED due to propagation or grouping constraints");
                }
            } else {
                this.setBundleResolved(bundle);
                if (DEBUG) {
                    ResolverImpl.log(bundle + " RESOLVED");
                }
            }
        } else if (failed || !fullyWired) {
            this.setBundleUnresolved(bundle, false);
            if (DEBUG) {
                ResolverImpl.log(bundle + " NOT RESOLVED");
            }
        }
        if (!failed && fullyWired) {
            this.groupingChecker.addPropagationAndReExportConstraints(bundle);
            this.groupingChecker.addRequireConstraints(bundle.getExportPackages(), bundle);
        }
        if ((v = this.cyclicDependencies.remove(bundle)) != null) {
            int i2 = 0;
            while (i2 < v.size()) {
                ResolverBundle dependent = (ResolverBundle)v.get(i2);
                if (bundle.isDependentOnUnresolvedFragment(dependent)) {
                    dependent.cyclicDependencyFailed(bundle);
                    this.setBundleUnresolved(dependent, false);
                    if (DEBUG_CYCLES) {
                        ResolverImpl.log("Setting dependent bundle (" + dependent + ") to unresolved (due to fragment)");
                    }
                } else if (bundle.getState() == 2) {
                    if (dependent.cyclicDependencyResolved(bundle)) {
                        this.setBundleResolved(dependent);
                        if (DEBUG_CYCLES) {
                            ResolverImpl.log("Telling dependent bundle (" + dependent + ") that " + bundle + " has resolved");
                        }
                    }
                } else if (bundle.getState() == 0) {
                    dependent.cyclicDependencyFailed(bundle);
                    this.setBundleUnresolved(dependent, false);
                    if (DEBUG_CYCLES) {
                        ResolverImpl.log("Setting dependent bundle (" + dependent + ") to unresolved");
                    }
                }
                ++i2;
            }
        }
        if (bundle.getState() == 0) {
            bundle.setResolvable(false);
        }
        this.stateResolveConstraints(bundle);
        return bundle.getState() != 0;
    }

    private boolean resolveRequire(BundleConstraint req) {
        if (DEBUG_REQUIRES) {
            ResolverImpl.log("Trying to resolve: " + req.getBundle() + ", " + req.getVersionConstraint());
        }
        if (req.getMatchingBundle() != null) {
            if (req.getMatchingBundle().getState() == 1) {
                this.cyclicDependencies.put(req.getMatchingBundle(), req.getBundle());
                req.getBundle().recordCyclicDependency(req.getMatchingBundle());
            }
            if (DEBUG_REQUIRES) {
                ResolverImpl.log("  - already wired");
            }
            return true;
        }
        VersionSupplier[] bundles = this.resolverBundles.getArray(req.getVersionConstraint().getName());
        int i = 0;
        while (i < bundles.length) {
            ResolverBundle bundle = (ResolverBundle)bundles[i];
            if (DEBUG_REQUIRES) {
                ResolverImpl.log("CHECKING: " + bundle.getBundle());
            }
            if (req.isSatisfiedBy(bundle)) {
                int originalState = bundle.getState();
                req.setMatchingBundle(bundle);
                if (req.getBundle() == bundle) {
                    return true;
                }
                if (originalState == 0 && !this.resolveBundle(bundle)) {
                    req.setMatchingBundle(null);
                } else {
                    if (originalState == 1) {
                        this.cyclicDependencies.put(bundle, req.getBundle());
                        req.getBundle().recordCyclicDependency(bundle);
                    } else if (originalState == 0 && bundle.getState() == 1) {
                        ArrayList exportersCyclicDependencies = bundle.getCyclicDependencies();
                        int k = 0;
                        while (k < exportersCyclicDependencies.size()) {
                            ResolverBundle dependentOn = (ResolverBundle)exportersCyclicDependencies.get(k);
                            if (dependentOn != req.getBundle()) {
                                this.cyclicDependencies.put(dependentOn, req.getBundle());
                                req.getBundle().recordCyclicDependency(dependentOn);
                            }
                            ++k;
                        }
                    }
                    if (DEBUG_REQUIRES) {
                        ResolverImpl.log("Found match: " + bundle.getBundle() + ". Wiring");
                    }
                    return true;
                }
            }
            ++i;
        }
        return req.isOptional();
    }

    /*
     * Unable to fully structure code
     */
    private boolean resolveImport(ResolverImport imp, boolean checkReexportsFromRequires) {
        if (ResolverImpl.DEBUG_IMPORTS) {
            ResolverImpl.log("Trying to resolve: " + imp.getBundle() + ", " + imp.getName());
        }
        if (imp.getMatchingExport() != null) {
            if (imp.getMatchingExport().getExporter().getState() == 1) {
                this.cyclicDependencies.put(imp.getMatchingExport().getExporter(), imp.getBundle());
                imp.getBundle().recordCyclicDependency(imp.getMatchingExport().getExporter());
            }
            if (ResolverImpl.DEBUG_IMPORTS) {
                ResolverImpl.log("  - already wired");
            }
            return true;
        }
        exports = this.resolverExports.getArray(imp.getName());
        i = 0;
        while (i < exports.length) {
            block24: {
                block25: {
                    export = (ResolverExport)exports[i];
                    if (ResolverImpl.DEBUG_IMPORTS) {
                        ResolverImpl.log("CHECKING: " + export.getExporter().getBundle() + ", " + exports[i].getName());
                    }
                    if (!imp.isSatisfiedBy(export) || !imp.isNotAnUnresolvableWiring(export)) break block24;
                    originalState = export.getExporter().getState();
                    if (imp.isDynamic() && originalState != 2) {
                        return false;
                    }
                    if (imp.getBundle() == export.getExporter() && !export.getExportPackageDescription().isRoot()) break block24;
                    imp.setMatchingExport(export);
                    if (imp.getBundle() == export.getExporter()) ** GOTO lbl-1000
                    exp = imp.getBundle().getExport(imp);
                    if (exp == null) break block25;
                    if (exp.getExportPackageDescription().isRoot() && !export.getExportPackageDescription().isRoot()) break block24;
                    this.resolverExports.remove(exp);
                }
                ** if ((originalState != 0 && export.getExportPackageDescription().isRoot() || this.resolveBundle((ResolverBundle)export.getExporter())) && this.resolverExports.contains((VersionSupplier)export)) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    if (exp != null) {
                        this.resolverExports.put((VersionSupplier)exp);
                    } else {
                        ** GOTO lbl34
                    }
lbl34:
                    // 3 sources

                    imp.setMatchingExport(null);
                    ** GOTO lbl64
                }
lbl-1000:
                // 2 sources

                {
                    if (!imp.getBundle().isResolvable()) {
                        return false;
                    }
                    if (this.checkAndResolveDependencies(imp, imp.getMatchingExport())) {
                        if (imp.getMatchingExport() != export) {
                            return true;
                        }
                        if (imp.getBundle() != export.getExporter()) {
                            if (originalState == 1) {
                                this.cyclicDependencies.put(export.getExporter(), imp.getBundle());
                                imp.getBundle().recordCyclicDependency(export.getExporter());
                            } else if (originalState == 0 && export.getExporter().getState() == 1) {
                                exportersCyclicDependencies = export.getExporter().getCyclicDependencies();
                                k = 0;
                                while (k < exportersCyclicDependencies.size()) {
                                    dependentOn = (ResolverBundle)exportersCyclicDependencies.get(k);
                                    if (dependentOn != imp.getBundle()) {
                                        this.cyclicDependencies.put(dependentOn, imp.getBundle());
                                        imp.getBundle().recordCyclicDependency(dependentOn);
                                    }
                                    ++k;
                                }
                            }
                        }
                        if (ResolverImpl.DEBUG_IMPORTS) {
                            ResolverImpl.log("Found match: " + export.getExporter() + ". Wiring " + imp.getBundle() + ":" + imp.getName());
                        }
                        return true;
                    }
                    if (!imp.getBundle().isResolvable()) {
                        return false;
                    }
                }
            }
            ++i;
        }
        if (checkReexportsFromRequires && this.resolveImportReprovide(imp)) {
            return true;
        }
        return imp.isOptional() != false;
    }

    private boolean resolveImportReprovide(ResolverImport imp) {
        String bsn = imp.getImportPackageSpecification().getBundleSymbolicName();
        if (bsn == null) {
            return false;
        }
        if (DEBUG_IMPORTS) {
            ResolverImpl.log("Checking reprovides: " + imp.getName());
        }
        Iterator iter = this.bundleMapping.values().iterator();
        while (iter.hasNext()) {
            ResolverBundle rb = (ResolverBundle)iter.next();
            if (!bsn.equals(rb.getBundle().getSymbolicName()) || rb.isFragment() || !this.resolveBundle(rb) || !this.resolveImportReprovide0(imp, rb, rb)) continue;
            return true;
        }
        return false;
    }

    private boolean resolveImportReprovide0(ResolverImport imp, ResolverBundle reexporter, ResolverBundle rb) {
        BundleConstraint[] requires = rb.getRequires();
        int i = 0;
        while (i < requires.length) {
            if (((BundleSpecification)requires[i].getVersionConstraint()).isExported() && requires[i].getMatchingBundle() != null) {
                ResolverExport[] exports = requires[i].getMatchingBundle().getExportPackages();
                int j = 0;
                while (j < exports.length) {
                    if (imp.getName().equals(exports[j].getName())) {
                        ExportPackageDescription epd = this.state.getFactory().createExportPackageDescription(exports[j].getName(), exports[j].getVersion(), exports[j].getName(), exports[j].getExportPackageDescription().getInclude(), exports[j].getExportPackageDescription().getExclude(), exports[j].getExportPackageDescription().getAttributes(), exports[j].getExportPackageDescription().getMandatory(), false, reexporter.getBundle());
                        if (imp.getImportPackageSpecification().isSatisfiedBy(epd)) {
                            if (DEBUG_IMPORTS) {
                                ResolverImpl.log(" - Creating re-export for reprovide: " + reexporter + ":" + epd.getName());
                            }
                            ResolverExport re = new ResolverExport(reexporter, epd, true);
                            reexporter.addExport(re);
                            this.groupingChecker.addReprovideConstraints(re);
                            this.resolverExports.put(re);
                            if (this.resolveImport(imp, false)) {
                                return true;
                            }
                        }
                    }
                    ++j;
                }
                if (this.resolveImportReprovide0(imp, reexporter, requires[i].getMatchingBundle())) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean checkAndResolveDependencies(ResolverImport imp, ResolverExport exp) {
        if (DEBUG_GROUPING) {
            ResolverImpl.log("  Checking grouping for " + imp.getBundle() + ":" + imp.getName() + " -> " + exp.getExporter() + ":" + exp.getName());
        }
        ResolverBundle importer = imp.getBundle();
        ResolverExport clash = this.groupingChecker.isConsistent(imp, exp);
        if (clash == null) {
            return true;
        }
        if (DEBUG_GROUPING) {
            ResolverImpl.log("  * grouping clash with " + clash.getExporter() + ":" + clash.getName());
        }
        imp.addUnresolvableWiring(exp.getExporter());
        imp.setMatchingExport(null);
        if (this.resolveImport(imp, false)) {
            return true;
        }
        if (imp.isDynamic()) {
            return false;
        }
        imp.clearUnresolvableWirings();
        imp.setMatchingExport(exp);
        ResolverImport[] imports = importer.getImportPackages();
        int i = 0;
        while (i < imports.length) {
            if (imports[i].getMatchingExport() != null && imports[i].getMatchingExport().getName().equals(clash.getName())) {
                imports[i].addUnresolvableWiring(imports[i].getMatchingExport().getExporter());
                importer.clearWires();
                ResolverExport removed = importer.getExport(imports[i]);
                if (removed != null) {
                    this.resolverExports.put(removed);
                }
                return this.resolveBundle(importer);
            }
            ++i;
        }
        return false;
    }

    private void setBundleUnresolved(ResolverBundle bundle, boolean removed) {
        if (bundle.getState() == 0) {
            return;
        }
        if (bundle.getBundle().isResolved()) {
            this.resolverExports.remove(bundle.getExportPackages());
            bundle.initialize(false);
            if (!removed) {
                this.resolverExports.put(bundle.getExportPackages());
            }
        }
        if (this.resolvingBundles != null) {
            this.resolvingBundles.remove(bundle);
        }
        if (this.resolvedBundles != null) {
            this.resolvedBundles.remove(bundle);
        }
        if (!removed) {
            this.unresolvedBundles.add(bundle);
        }
        bundle.detachAllFragments();
        bundle.setState(0);
    }

    private void setBundleResolved(ResolverBundle bundle) {
        if (bundle.getState() == 2) {
            return;
        }
        this.resolvingBundles.remove(bundle);
        this.unresolvedBundles.remove(bundle);
        this.resolvedBundles.add(bundle);
        bundle.setState(2);
    }

    private void setBundleResolving(ResolverBundle bundle) {
        if (bundle.getState() == 1) {
            return;
        }
        this.resolvedBundles.remove(bundle);
        this.unresolvedBundles.remove(bundle);
        this.resolvingBundles.add(bundle);
        bundle.setState(1);
    }

    private void stateResolveBundles() {
        int i = 0;
        while (i < this.resolvedBundles.size()) {
            ResolverBundle rb = (ResolverBundle)this.resolvedBundles.get(i);
            if (!rb.getBundle().isResolved()) {
                this.stateResolveBundle(rb);
            }
            ++i;
        }
        this.resolverExports.reorder();
        this.resolverBundles.reorder();
    }

    private void stateResolveConstraints(ResolverBundle rb) {
        ResolverImport[] imports = rb.getImportPackages();
        int i = 0;
        while (i < imports.length) {
            ResolverExport export = imports[i].getMatchingExport();
            ExportPackageDescription supplier = export == null ? null : export.getExportPackageDescription();
            this.state.resolveConstraint(imports[i].getImportPackageSpecification(), supplier);
            ++i;
        }
        BundleConstraint[] requires = rb.getRequires();
        int i2 = 0;
        while (i2 < requires.length) {
            ResolverBundle bundle = requires[i2].getMatchingBundle();
            BundleDescription supplier = bundle == null ? null : bundle.getBundle();
            this.state.resolveConstraint(requires[i2].getVersionConstraint(), supplier);
            ++i2;
        }
    }

    private void stateResolveBundle(ResolverBundle rb) {
        ResolverBundle[] matchingBundles;
        ResolverExport[] exports = rb.getSelectedExports();
        ArrayList<ExportPackageDescription> selectedExports = new ArrayList<ExportPackageDescription>(exports.length);
        int i = 0;
        while (i < exports.length) {
            selectedExports.add(exports[i].getExportPackageDescription());
            ++i;
        }
        ExportPackageDescription[] selectedExportsArray = selectedExports.toArray(new ExportPackageDescription[selectedExports.size()]);
        ResolverImport[] imports = rb.getImportPackages();
        ArrayList<ExportPackageDescription> exportsWiredTo = new ArrayList<ExportPackageDescription>(imports.length);
        int i2 = 0;
        while (i2 < imports.length) {
            if (imports[i2].getMatchingExport() != null) {
                exportsWiredTo.add(imports[i2].getMatchingExport().getExportPackageDescription());
            }
            ++i2;
        }
        ExportPackageDescription[] exportsWiredToArray = exportsWiredTo.toArray(new ExportPackageDescription[exportsWiredTo.size()]);
        BundleConstraint[] requires = rb.getRequires();
        ArrayList<BundleDescription> bundlesWiredTo = new ArrayList<BundleDescription>(requires.length);
        int i3 = 0;
        while (i3 < requires.length) {
            if (requires[i3].getMatchingBundle() != null) {
                bundlesWiredTo.add(requires[i3].getMatchingBundle().getBundle());
            }
            ++i3;
        }
        BundleDescription[] bundlesWiredToArray = bundlesWiredTo.toArray(new BundleDescription[bundlesWiredTo.size()]);
        BundleDescription[] hostBundles = null;
        if (rb.isFragment() && (matchingBundles = rb.getHost().getMatchingBundles()) != null && matchingBundles.length > 0) {
            hostBundles = new BundleDescription[matchingBundles.length];
            int i4 = 0;
            while (i4 < matchingBundles.length) {
                hostBundles[i4] = matchingBundles[i4].getBundle();
                if (rb.isNewFragmentExports()) {
                    ResolverBundle hostRB = (ResolverBundle)this.bundleMapping.get(hostBundles[i4]);
                    ResolverExport[] hostExports = hostRB.getSelectedExports();
                    ArrayList<ExportPackageDescription> selectedHostExports = new ArrayList<ExportPackageDescription>(hostExports.length);
                    int j = 0;
                    while (j < hostExports.length) {
                        selectedHostExports.add(hostExports[j].getExportPackageDescription());
                        ++j;
                    }
                    ExportPackageDescription[] hostExportsArray = selectedHostExports.toArray(new ExportPackageDescription[selectedHostExports.size()]);
                    this.state.resolveBundle(hostBundles[i4], true, null, hostExportsArray, hostBundles[i4].getResolvedRequires(), hostBundles[i4].getResolvedImports());
                }
                ++i4;
            }
        }
        this.state.resolveBundle(rb.getBundle(), true, hostBundles, selectedExportsArray, bundlesWiredToArray, exportsWiredToArray);
    }

    public synchronized ExportPackageDescription resolveDynamicImport(BundleDescription importingBundle, String requestedPackage) {
        if (this.state == null) {
            throw new IllegalStateException("RESOLVER_NO_STATE");
        }
        if (!this.initialized) {
            this.initialize();
        }
        ResolverBundle rb = (ResolverBundle)this.bundleMapping.get(importingBundle);
        ResolverImport[] resolverImports = rb.getImportPackages();
        boolean found = false;
        int j = 0;
        while (j < resolverImports.length) {
            if ((resolverImports[j].getImportPackageSpecification().getResolution() & 4) != 0) {
                String importName = resolverImports[j].getName();
                if (importName.equals("*") || importName.endsWith(".*") && requestedPackage.startsWith(importName.substring(0, importName.length() - 2))) {
                    resolverImports[j].setName(requestedPackage);
                    found = true;
                }
                if (requestedPackage.equals(resolverImports[j].getName())) {
                    boolean resolved = this.resolveImport(resolverImports[j], true);
                    while (resolved && !this.checkDynamicGrouping(resolverImports[j])) {
                        resolved = this.resolveImport(resolverImports[j], true);
                    }
                    if (resolved) {
                        resolverImports[j].setName(null);
                        if (DEBUG_IMPORTS) {
                            ResolverImpl.log("Resolved dynamic import: " + rb + ":" + resolverImports[j].getName() + " -> " + resolverImports[j].getMatchingExport().getExporter() + ":" + requestedPackage);
                        }
                        ExportPackageDescription matchingExport = resolverImports[j].getMatchingExport().getExportPackageDescription();
                        if (importName.endsWith("*")) {
                            resolverImports[j].setMatchingExport(null);
                        }
                        return matchingExport;
                    }
                }
                resolverImports[j].setName(null);
            }
            ++j;
        }
        if (!found) {
            ResolverImport newImport = new ResolverImport(rb, this.state.getFactory().createImportPackageSpecification(requestedPackage, null, null, null, null, 4, null, importingBundle));
            boolean resolved = this.resolveImport(newImport, true);
            while (resolved && !this.checkDynamicGrouping(newImport)) {
                resolved = this.resolveImport(newImport, true);
            }
            if (resolved) {
                return newImport.getMatchingExport().getExportPackageDescription();
            }
        }
        if (DEBUG || DEBUG_IMPORTS) {
            ResolverImpl.log("Failed to resolve dynamic import: " + requestedPackage);
        }
        return null;
    }

    private boolean checkDynamicGrouping(ResolverImport imp) {
        ResolverBundle rb = imp.getBundle();
        ResolverImport[] imports = rb.getImportPackages();
        int i = 0;
        while (i < imports.length) {
            if (imports[i] != imp && imports[i].getMatchingExport() != null && imp.getMatchingExport().getExporter() != imports[i].getMatchingExport().getExporter()) {
                ResolverExport[] exports = imports[i].getMatchingExport().getExporter().getExportPackages();
                String importGrouping = imports[i].getMatchingExport().getGrouping();
                int j = 0;
                while (j < exports.length) {
                    String exportName = exports[j].getName();
                    String exportGrouping = exports[j].getGrouping();
                    if (exportName.equals(imp.getName()) && importGrouping.equals(exportGrouping)) {
                        imp.addUnresolvableWiring(imp.getMatchingExport().getExporter());
                        imp.setMatchingExport(null);
                        if (DEBUG_GROUPING) {
                            ResolverImpl.log("  Dynamic grouping failed: " + imp.getName());
                        }
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    public void bundleAdded(BundleDescription bundle) {
        if (!this.initialized) {
            return;
        }
        boolean alreadyThere = false;
        int i = 0;
        while (i < this.unresolvedBundles.size()) {
            ResolverBundle rb = (ResolverBundle)this.unresolvedBundles.get(i);
            if (rb.getBundle() == bundle) {
                alreadyThere = true;
            }
            ++i;
        }
        if (!alreadyThere) {
            ResolverBundle rb = new ResolverBundle(bundle, this);
            this.bundleMapping.put(bundle, rb);
            this.unresolvedBundles.add(rb);
            this.resolverExports.put(rb.getExportPackages());
            this.resolverBundles.put(rb);
        }
    }

    public void bundleRemoved(BundleDescription bundle, boolean pending) {
        if (pending) {
            this.addRemovalPending(bundle);
        }
        if (!this.initialized) {
            return;
        }
        ResolverBundle rb = (ResolverBundle)this.bundleMapping.get(bundle);
        if (rb == null) {
            return;
        }
        if (!pending) {
            this.bundleMapping.remove(bundle);
        }
        this.unresolvedBundles.remove(rb);
        this.resolverExports.remove(rb.getExportPackages());
        this.resolverBundles.remove(rb);
    }

    private void addRemovalPending(BundleDescription bundle) {
        Long id = new Long(bundle.getBundleId());
        ArrayList<BundleDescription> removedBundles = (ArrayList<BundleDescription>)this.removalPending.get(id);
        if (removedBundles == null) {
            removedBundles = new ArrayList<BundleDescription>(1);
            removedBundles.add(bundle);
            this.removalPending.put(id, removedBundles);
        } else {
            removedBundles.add(bundle);
        }
    }

    private BundleDescription[] getRemovalPending(BundleDescription bundle) {
        Long id = new Long(bundle.getBundleId());
        ArrayList removedBundles = (ArrayList)this.removalPending.remove(id);
        if (removedBundles == null) {
            return null;
        }
        return removedBundles.toArray(new BundleDescription[removedBundles.size()]);
    }

    private void unresolveBundle(ResolverBundle bundle, boolean removed) {
        if (bundle == null) {
            return;
        }
        new Long(bundle.getBundle().getBundleId());
        BundleDescription[] removedBundles = null;
        removedBundles = this.getRemovalPending(bundle.getBundle());
        if (removedBundles != null) {
            int i = 0;
            while (i < removedBundles.length) {
                this.unresolveBundle((ResolverBundle)this.bundleMapping.get(removedBundles[i]), true);
                this.state.removeBundleComplete(removedBundles[i]);
                this.bundleMapping.remove(removedBundles[i]);
                if (removedBundles[i] == bundle.getBundle()) {
                    removed = true;
                }
                ++i;
            }
        }
        if (!bundle.getBundle().isResolved()) {
            return;
        }
        this.setBundleUnresolved(bundle, removed);
        BundleDescription[] dependents = bundle.getBundle().getDependents();
        bundle.setState(0);
        this.state.resolveBundle(bundle.getBundle(), false, null, null, null, null);
        int i = 0;
        while (i < dependents.length) {
            this.unresolveBundle((ResolverBundle)this.bundleMapping.get(dependents[i]), false);
            ++i;
        }
    }

    public void bundleUpdated(BundleDescription newDescription, BundleDescription existingDescription, boolean pending) {
        this.bundleRemoved(existingDescription, pending);
        this.bundleAdded(newDescription);
    }

    public void flush() {
        this.resolverExports = null;
        this.resolverBundles = null;
        this.unresolvedBundles = null;
        this.bundleMapping = null;
        this.cyclicDependencies = null;
        if (this.removalPending.size() > 0) {
            BundleDescription[] pending = this.getRemovalPending();
            int i = 0;
            while (i < pending.length) {
                this.state.removeBundleComplete(pending[i]);
                ++i;
            }
        }
        this.removalPending.clear();
        this.initialized = false;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State newState) {
        this.state = newState;
        this.flush();
    }

    private BundleDescription[] getRemovalPending() {
        if (this.removalPending.size() == 0) {
            return new BundleDescription[0];
        }
        ArrayList results = new ArrayList(this.removalPending.size());
        Iterator iter = this.removalPending.values().iterator();
        while (iter.hasNext()) {
            ArrayList removedBundles = (ArrayList)iter.next();
            results.addAll(removedBundles);
        }
        return results.toArray(new BundleDescription[results.size()]);
    }

    private void setDebugOptions() {
        DebugOptions options = DebugOptions.getDefault();
        if (options == null) {
            return;
        }
        DEBUG = options.getBooleanOption(OPTION_DEBUG, false);
        DEBUG_WIRING = options.getBooleanOption(OPTION_WIRING, false);
        DEBUG_IMPORTS = options.getBooleanOption(OPTION_IMPORTS, false);
        DEBUG_REQUIRES = options.getBooleanOption(OPTION_REQUIRES, false);
        DEBUG_GROUPING = options.getBooleanOption(OPTION_GROUPING, false);
        DEBUG_CYCLES = options.getBooleanOption(OPTION_CYCLES, false);
    }

    private void printWirings() {
        int k = 0;
        while (k < this.resolvedBundles.size()) {
            ResolverBundle rb = (ResolverBundle)this.resolvedBundles.get(k);
            if (!rb.getBundle().isResolved()) {
                ResolverImport[] imports;
                int i;
                ResolverBundle[] hosts;
                ResolverImpl.log("    * WIRING for " + rb);
                BundleConstraint[] requireBundles = rb.getRequires();
                if (requireBundles.length == 0) {
                    ResolverImpl.log("        (r) no requires");
                } else {
                    int i2 = 0;
                    while (i2 < requireBundles.length) {
                        if (requireBundles[i2].getMatchingBundle() == null) {
                            ResolverImpl.log("        (r) " + rb.getBundle() + " -> NULL!!!");
                        } else {
                            ResolverImpl.log("        (r) " + rb.getBundle() + " -> " + requireBundles[i2].getMatchingBundle());
                        }
                        ++i2;
                    }
                }
                BundleConstraint hostSpec = rb.getHost();
                if (hostSpec != null && (hosts = hostSpec.getMatchingBundles()) != null) {
                    i = 0;
                    while (i < hosts.length) {
                        ResolverImpl.log("        (h) " + rb.getBundle() + " -> " + hosts[i].getBundle());
                        ++i;
                    }
                }
                if ((imports = rb.getImportPackages()).length == 0) {
                    ResolverImpl.log("        (w) no imports");
                } else {
                    i = 0;
                    while (i < imports.length) {
                        if (imports[i].isDynamic() && imports[i].getMatchingExport() == null) {
                            ResolverImpl.log("        (w) " + imports[i].getBundle() + ":" + imports[i].getName() + " -> DYNAMIC");
                        } else if (imports[i].isOptional() && imports[i].getMatchingExport() == null) {
                            ResolverImpl.log("        (w) " + imports[i].getBundle() + ":" + imports[i].getName() + " -> OPTIONAL (could not be wired)");
                        } else if (imports[i].getMatchingExport() == null) {
                            ResolverImpl.log("        (w) " + imports[i].getBundle() + ":" + imports[i].getName() + " -> NULL!!!");
                        } else {
                            ResolverImpl.log("        (w) " + imports[i].getBundle() + ":" + imports[i].getName() + " -> " + imports[i].getMatchingExport().getExporter() + ":" + imports[i].getMatchingExport().getName());
                        }
                        ++i;
                    }
                }
            }
            ++k;
        }
    }

    static void log(String message) {
        Debug.println(message);
    }
}

