/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

class StateBuilder {
    static String[] DEFINED_MATCHING_ATTRS = new String[]{"bundle-symbolic-name", "bundle-version", "specification-version", "version"};

    StateBuilder() {
    }

    static BundleDescription createBundleDescription(Dictionary manifest, String location) throws BundleException {
        String version;
        ManifestElement[] symbolicNameElements;
        String symbolicNameHeader;
        BundleDescriptionImpl result = new BundleDescriptionImpl();
        String manifestVersionHeader = (String)manifest.get("Bundle-ManifestVersion");
        int manifestVersion = 1;
        if (manifestVersionHeader != null) {
            manifestVersion = Integer.parseInt(manifestVersionHeader);
        }
        if ((symbolicNameHeader = (String)manifest.get("Bundle-SymbolicName")) != null && (symbolicNameElements = ManifestElement.parseHeader("Bundle-SymbolicName", symbolicNameHeader)).length > 0) {
            result.setSymbolicName(symbolicNameElements[0].getValue());
            result.setStateBit((byte)2, "true".equals(symbolicNameElements[0].getAttribute("singleton")));
        }
        result.setVersion((version = (String)manifest.get("Bundle-Version")) != null ? Version.parseVersion(version) : Version.emptyVersion);
        result.setLocation(location);
        result.setPlatformFilter((String)manifest.get("Eclipse-PlatformFilter"));
        ManifestElement[] host = ManifestElement.parseHeader("Fragment-Host", (String)manifest.get("Fragment-Host"));
        if (host != null) {
            result.setHost(StateBuilder.createHostSpecification(host[0]));
        }
        ManifestElement[] exports = ManifestElement.parseHeader("Export-Package", (String)manifest.get("Export-Package"));
        ManifestElement[] reexports = ManifestElement.parseHeader("Reexport-Package", (String)manifest.get("Reexport-Package"));
        ManifestElement[] provides = ManifestElement.parseHeader("Provide-Package", (String)manifest.get("Provide-Package"));
        ArrayList providedExports = new ArrayList(provides == null ? 0 : provides.length);
        result.setExportPackages(StateBuilder.createExportPackages(result, exports, reexports, provides, providedExports, manifestVersion));
        ManifestElement[] imports = ManifestElement.parseHeader("Import-Package", (String)manifest.get("Import-Package"));
        ManifestElement[] dynamicImports = ManifestElement.parseHeader("DynamicImport-Package", (String)manifest.get("DynamicImport-Package"));
        result.setImportPackages(StateBuilder.createImportPackages(result.getExportPackages(), providedExports, imports, dynamicImports, manifestVersion));
        ManifestElement[] requires = ManifestElement.parseHeader("Require-Bundle", (String)manifest.get("Require-Bundle"));
        result.setRequiredBundles(StateBuilder.createRequiredBundles(requires));
        return result;
    }

    private static BundleSpecification[] createRequiredBundles(ManifestElement[] specs) {
        if (specs == null) {
            return null;
        }
        BundleSpecification[] result = new BundleSpecification[specs.length];
        int i = 0;
        while (i < specs.length) {
            result[i] = StateBuilder.createRequiredBundle(specs[i]);
            ++i;
        }
        return result;
    }

    private static BundleSpecification createRequiredBundle(ManifestElement spec) {
        BundleSpecificationImpl result = new BundleSpecificationImpl();
        result.setName(spec.getValue());
        result.setVersionRange(StateBuilder.getVersionRange(spec.getAttribute("bundle-version")));
        result.setExported("reexport".equals(spec.getDirective("visibility")) || "true".equals(spec.getAttribute("reprovide")));
        result.setOptional("optional".equals(spec.getDirective("resolution")) || "true".equals(spec.getAttribute("optional")));
        return result;
    }

    private static String[] createProvidedPackages(ManifestElement[] specs) {
        if (specs == null || specs.length == 0) {
            return null;
        }
        String[] result = new String[specs.length];
        int i = 0;
        while (i < specs.length) {
            result[i] = specs[i].getValue();
            ++i;
        }
        return result;
    }

    private static ImportPackageSpecification[] createImportPackages(ExportPackageDescription[] exported, ArrayList providedExports, ManifestElement[] imported, ManifestElement[] dynamicImported, int manifestVersion) throws BundleException {
        int i;
        ArrayList<ImportPackageSpecificationImpl> allImports = null;
        if (manifestVersion < 2) {
            if (exported.length == 0 && imported == null && dynamicImported == null) {
                return null;
            }
            allImports = new ArrayList(exported.length + (imported == null ? 0 : imported.length));
            i = 0;
            while (i < exported.length) {
                if (!providedExports.contains(exported[i].getName())) {
                    ImportPackageSpecificationImpl result = new ImportPackageSpecificationImpl();
                    result.setName(exported[i].getName());
                    result.setVersionRange(StateBuilder.getVersionRange(exported[i].getVersion().toString()));
                    result.setResolution(1);
                    allImports.add(result);
                }
                ++i;
            }
        } else {
            allImports = new ArrayList<ImportPackageSpecificationImpl>(imported == null ? 0 : imported.length);
        }
        if (dynamicImported != null) {
            i = 0;
            while (i < dynamicImported.length) {
                StateBuilder.addImportPackages(dynamicImported[i], allImports, manifestVersion, true);
                ++i;
            }
        }
        if (imported != null) {
            i = 0;
            while (i < imported.length) {
                StateBuilder.addImportPackages(imported[i], allImports, manifestVersion, false);
                ++i;
            }
        }
        return allImports.toArray(new ImportPackageSpecification[allImports.size()]);
    }

    private static void addImportPackages(ManifestElement importPackage, ArrayList allImports, int manifestVersion, boolean dynamic) throws BundleException {
        String[] importNames = importPackage.getValueComponents();
        int i = 0;
        while (i < importNames.length) {
            if (manifestVersion < 2) {
                Iterator iter = allImports.iterator();
                while (iter.hasNext()) {
                    if (!importNames[i].equals(((ImportPackageSpecification)iter.next()).getName())) continue;
                    iter.remove();
                }
            }
            ImportPackageSpecificationImpl result = new ImportPackageSpecificationImpl();
            result.setName(importNames[i]);
            result.setVersionRange(StateBuilder.getVersionRange(manifestVersion < 2 ? importPackage.getAttribute("specification-version") : importPackage.getAttribute("version")));
            result.setBundleSymbolicName(importPackage.getAttribute("bundle-symbolic-name"));
            result.setBundleVersionRange(StateBuilder.getVersionRange(importPackage.getAttribute("bundle-version")));
            result.setAttributes(StateBuilder.getAttributes(importPackage, DEFINED_MATCHING_ATTRS));
            if (dynamic) {
                result.setResolution(4);
            } else {
                result.setPropagate(ManifestElement.getArrayFromList(importPackage.getDirective("grouping")));
                result.setResolution(StateBuilder.getResolution(importPackage.getDirective("resolution")));
            }
            allImports.add(result);
            ++i;
        }
    }

    private static int getResolution(String resolution) {
        int result = 1;
        if ("optional".equals(resolution)) {
            result = 2;
        }
        return result;
    }

    private static ExportPackageDescription[] createExportPackages(BundleDescriptionImpl bundle, ManifestElement[] exported, ManifestElement[] reexported, ManifestElement[] provides, ArrayList providedExports, int manifestVersion) throws BundleException {
        int i;
        int numExports = (exported == null ? 0 : exported.length) + (reexported == null ? 0 : reexported.length) + (provides == null ? 0 : provides.length);
        if (numExports == 0) {
            return null;
        }
        ArrayList allExports = new ArrayList(numExports);
        if (exported != null) {
            i = 0;
            while (i < exported.length) {
                StateBuilder.addExportPackages(exported[i], allExports, manifestVersion, false);
                ++i;
            }
        }
        if (reexported != null) {
            i = 0;
            while (i < reexported.length) {
                StateBuilder.addExportPackages(reexported[i], allExports, manifestVersion, true);
                ++i;
            }
        }
        if (provides != null) {
            StateBuilder.addProvidePackages(provides, allExports, providedExports);
        }
        return allExports.toArray(new ExportPackageDescription[allExports.size()]);
    }

    private static void addExportPackages(ManifestElement exportPackage, ArrayList allExports, int manifestVersion, boolean reexported) throws BundleException {
        String[] exportNames = exportPackage.getValueComponents();
        int i = 0;
        while (i < exportNames.length) {
            String versionString;
            ExportPackageDescriptionImpl result = new ExportPackageDescriptionImpl();
            result.setName(exportNames[i]);
            String string = versionString = manifestVersion < 2 ? exportPackage.getAttribute("specification-version") : exportPackage.getAttribute("version");
            if (versionString != null) {
                result.setVersion(Version.parseVersion(versionString));
            }
            result.setGrouping(exportPackage.getDirective("grouping"));
            result.setInclude(exportPackage.getDirective("include"));
            result.setExclude(exportPackage.getDirective("exclude"));
            result.setAttributes(StateBuilder.getAttributes(exportPackage, DEFINED_MATCHING_ATTRS));
            result.setMandatory(ManifestElement.getArrayFromList(exportPackage.getDirective("mandatory")));
            result.setRoot(!reexported);
            allExports.add(result);
            ++i;
        }
    }

    private static void addProvidePackages(ManifestElement[] provides, ArrayList allExports, ArrayList providedExports) throws BundleException {
        ExportPackageDescription[] currentExports = allExports.toArray(new ExportPackageDescription[allExports.size()]);
        int i = 0;
        while (i < provides.length) {
            boolean duplicate = false;
            int j = 0;
            while (j < currentExports.length) {
                if (provides[i].getValue().equals(currentExports[j].getName())) {
                    duplicate = true;
                    break;
                }
                ++j;
            }
            if (!duplicate) {
                ExportPackageDescriptionImpl result = new ExportPackageDescriptionImpl();
                result.setName(provides[i].getValue());
                result.setRoot(true);
                allExports.add(result);
            }
            providedExports.add(provides[i].getValue());
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Map getAttributes(ManifestElement exportPackage, String[] definedAttrs) {
        keys = exportPackage.getKeys();
        arbitraryAttrs = null;
        if (keys != null) ** GOTO lbl19
        return null;
lbl-1000:
        // 1 sources

        {
            definedAttr = false;
            key = (String)keys.nextElement();
            i = 0;
            while (i < definedAttrs.length) {
                if (definedAttrs[i].equals(key)) {
                    definedAttr = true;
                    break;
                }
                ++i;
            }
            if (definedAttr) continue;
            if (arbitraryAttrs == null) {
                arbitraryAttrs = new HashMap<String, String>();
            }
            arbitraryAttrs.put(key, exportPackage.getAttribute(key));
lbl19:
            // 3 sources

            ** while (keys.hasMoreElements())
        }
lbl20:
        // 1 sources

        return arbitraryAttrs;
    }

    private static HostSpecification createHostSpecification(ManifestElement spec) {
        if (spec == null) {
            return null;
        }
        HostSpecificationImpl result = new HostSpecificationImpl();
        result.setName(spec.getValue());
        result.setVersionRange(StateBuilder.getVersionRange(spec.getAttribute("bundle-version")));
        return result;
    }

    private static VersionRange getVersionRange(String versionRange) {
        if (versionRange == null) {
            return null;
        }
        return new VersionRange(versionRange);
    }
}

