/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateHelperImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

class StateWriter {
    protected Map objectTable = new HashMap();
    public static final byte NULL = 0;
    public static final byte OBJECT = 1;
    public static final byte INDEX = 2;

    StateWriter() {
    }

    private int addToObjectTable(Object object) {
        this.objectTable.put(object, new Integer(this.objectTable.size()));
        return this.objectTable.size() - 1;
    }

    private int getFromObjectTable(Object object) {
        Object objectResult;
        if (this.objectTable != null && (objectResult = this.objectTable.get(object)) != null) {
            return (Integer)objectResult;
        }
        return -1;
    }

    private boolean writePrefix(Object object, DataOutputStream out) throws IOException {
        if (this.writeIndex(object, out)) {
            return true;
        }
        int index = this.addToObjectTable(object);
        out.writeByte(1);
        out.writeInt(index);
        return false;
    }

    private void writeStateDeprecated(StateImpl state, DataOutputStream out) throws IOException {
        out.write(14);
        if (this.writePrefix(state, out)) {
            return;
        }
        out.writeLong(state.getTimeStamp());
        Dictionary props = state.getPlatformProperties();
        out.writeInt(StateImpl.PROPS.length);
        int i = 0;
        while (i < StateImpl.PROPS.length) {
            this.writePlatformProp(props.get(StateImpl.PROPS[i]), out);
            ++i;
        }
        BundleDescription[] bundles = state.getBundles();
        StateHelperImpl.getInstance().sortBundles(bundles);
        out.writeInt(bundles.length);
        if (bundles.length == 0) {
            return;
        }
        int i2 = 0;
        while (i2 < bundles.length) {
            this.writeBundleDescription(bundles[i2], out);
            ++i2;
        }
        out.writeBoolean(state.isResolved());
        out.writeInt(out.size());
        i2 = 0;
        while (i2 < bundles.length) {
            this.writeBundleDescriptionLazyData(bundles[i2], out);
            ++i2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveState(StateImpl state, File stateFile, File lazyFile) throws IOException {
        DataOutputStream out;
        block11: {
            block10: {
                block9: {
                    out = new DataOutputStream(new FileOutputStream(stateFile));
                    try {
                        BundleDescription[] bundles;
                        out.write(14);
                        if (this.writePrefix(state, out)) {
                            Object var8_5 = null;
                            break block9;
                        }
                        out.writeLong(state.getTimeStamp());
                        Dictionary props = state.getPlatformProperties();
                        out.writeInt(StateImpl.PROPS.length);
                        int i = 0;
                        while (true) {
                            if (i >= StateImpl.PROPS.length) {
                                bundles = state.getBundles();
                                StateHelperImpl.getInstance().sortBundles(bundles);
                                out.writeInt(bundles.length);
                                if (bundles.length != 0) break;
                                break block10;
                            }
                            this.writePlatformProp(props.get(StateImpl.PROPS[i]), out);
                            ++i;
                        }
                        int i2 = 0;
                        while (true) {
                            if (i2 >= bundles.length) {
                                out.writeBoolean(state.isResolved());
                                out.close();
                                out = new DataOutputStream(new FileOutputStream(lazyFile));
                                i2 = 0;
                                break;
                            }
                            this.writeBundleDescription(bundles[i2], out);
                            ++i2;
                        }
                        while (i2 < bundles.length) {
                            this.writeBundleDescriptionLazyData(bundles[i2], out);
                            ++i2;
                        }
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var8_7 = null;
                        out.close();
                        throw throwable;
                    }
                }
                out.close();
                return;
            }
            Object var8_6 = null;
            out.close();
            return;
        }
        Object var8_8 = null;
        out.close();
    }

    private void writePlatformProp(Object obj, DataOutputStream out) throws IOException {
        if (obj == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            if (obj instanceof String) {
                out.writeInt(1);
                this.writeStringOrNull((String)obj, out);
            } else {
                String[] props = (String[])obj;
                out.writeInt(props.length);
                int i = 0;
                while (i < props.length) {
                    this.writeStringOrNull(props[i], out);
                    ++i;
                }
            }
        }
    }

    private void writeBundleDescription(BundleDescription bundle, DataOutputStream out) throws IOException {
        if (this.writePrefix(bundle, out)) {
            return;
        }
        out.writeLong(bundle.getBundleId());
        this.writeBaseDescription(bundle, out);
        out.writeBoolean(bundle.isResolved());
        out.writeBoolean(bundle.isSingleton());
        out.writeBoolean(bundle.hasDynamicImports());
        this.writeHostSpec((HostSpecificationImpl)bundle.getHost(), out);
        List dependencies = ((BundleDescriptionImpl)bundle).getBundleDependencies();
        out.writeInt(dependencies.size());
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            this.writeBundleDescription((BundleDescription)iter.next(), out);
        }
    }

    private void writeBundleDescriptionLazyData(BundleDescription bundle, DataOutputStream out) throws IOException {
        int index = this.getFromObjectTable(bundle);
        out.writeInt(index);
        int dataStart = out.size();
        this.writeStringOrNull(bundle.getLocation(), out);
        this.writeStringOrNull(bundle.getPlatformFilter(), out);
        ExportPackageDescription[] exports = bundle.getExportPackages();
        out.writeInt(exports.length);
        int i = 0;
        while (i < exports.length) {
            this.writeExportPackageDesc((ExportPackageDescriptionImpl)exports[i], out);
            ++i;
        }
        ImportPackageSpecification[] imports = bundle.getImportPackages();
        out.writeInt(imports.length);
        int i2 = 0;
        while (i2 < imports.length) {
            this.writeImportPackageSpec(imports[i2], out);
            ++i2;
        }
        BundleSpecification[] requiredBundles = bundle.getRequiredBundles();
        out.writeInt(requiredBundles.length);
        int i3 = 0;
        while (i3 < requiredBundles.length) {
            this.writeBundleSpec((BundleSpecificationImpl)requiredBundles[i3], out);
            ++i3;
        }
        ExportPackageDescription[] selectedExports = bundle.getSelectedExports();
        if (selectedExports == null) {
            out.writeInt(0);
        } else {
            out.writeInt(selectedExports.length);
            int i4 = 0;
            while (i4 < selectedExports.length) {
                this.writeExportPackageDesc((ExportPackageDescriptionImpl)selectedExports[i4], out);
                ++i4;
            }
        }
        ExportPackageDescription[] resolvedImports = bundle.getResolvedImports();
        if (resolvedImports == null) {
            out.writeInt(0);
        } else {
            out.writeInt(resolvedImports.length);
            int i5 = 0;
            while (i5 < resolvedImports.length) {
                this.writeExportPackageDesc((ExportPackageDescriptionImpl)resolvedImports[i5], out);
                ++i5;
            }
        }
        BundleDescription[] resolvedRequires = bundle.getResolvedRequires();
        if (resolvedRequires == null) {
            out.writeInt(0);
        } else {
            out.writeInt(resolvedRequires.length);
            int i6 = 0;
            while (i6 < resolvedRequires.length) {
                this.writeBundleDescription(resolvedRequires[i6], out);
                ++i6;
            }
        }
        out.writeInt(out.size() - dataStart);
    }

    private void writeBundleSpec(BundleSpecificationImpl bundle, DataOutputStream out) throws IOException {
        this.writeVersionConstraint(bundle, out);
        this.writeBundleDescription((BundleDescription)bundle.getSupplier(), out);
        out.writeBoolean(bundle.isExported());
        out.writeBoolean(bundle.isOptional());
    }

    private void writeExportPackageDesc(ExportPackageDescriptionImpl exportPackageDesc, DataOutputStream out) throws IOException {
        if (this.writePrefix(exportPackageDesc, out)) {
            return;
        }
        this.writeBaseDescription(exportPackageDesc, out);
        this.writeStringOrNull(exportPackageDesc.getBasicGrouping(), out);
        this.writeStringOrNull(exportPackageDesc.getInclude(), out);
        this.writeStringOrNull(exportPackageDesc.getExclude(), out);
        out.writeBoolean(exportPackageDesc.isRoot());
        Map attributes = exportPackageDesc.getAttributes();
        if (attributes == null) {
            out.writeInt(0);
        } else {
            out.writeInt(attributes.size());
            Iterator iter = attributes.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = (String)attributes.get(key);
                this.writeStringOrNull(key, out);
                this.writeStringOrNull(value, out);
            }
        }
        String[] mandatory = exportPackageDesc.getMandatory();
        if (mandatory == null) {
            out.writeInt(0);
        } else {
            out.writeInt(mandatory.length);
            int i = 0;
            while (i < mandatory.length) {
                this.writeStringOrNull(mandatory[i], out);
                ++i;
            }
        }
    }

    private void writeBaseDescription(BaseDescription rootDesc, DataOutputStream out) throws IOException {
        this.writeStringOrNull(rootDesc.getName(), out);
        this.writeVersion(rootDesc.getVersion(), out);
    }

    private void writeImportPackageSpec(ImportPackageSpecification importPackageSpec, DataOutputStream out) throws IOException {
        this.writeVersionConstraint(importPackageSpec, out);
        if (importPackageSpec.getBundle().isResolved()) {
            this.writeExportPackageDesc((ExportPackageDescriptionImpl)importPackageSpec.getSupplier(), out);
        } else {
            out.writeByte(0);
        }
        this.writeStringOrNull(importPackageSpec.getBundleSymbolicName(), out);
        this.writeVersionRange(importPackageSpec.getBundleVersionRange(), out);
        out.writeInt(importPackageSpec.getResolution());
        String[] propagate = importPackageSpec.getPropagate();
        if (propagate == null) {
            out.writeInt(0);
        } else {
            out.writeInt(propagate.length);
            int i = 0;
            while (i < propagate.length) {
                this.writeStringOrNull(propagate[i], out);
                ++i;
            }
        }
        Map attributes = importPackageSpec.getAttributes();
        if (attributes == null) {
            out.writeInt(0);
        } else {
            out.writeInt(attributes.size());
            Iterator iter = attributes.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = (String)attributes.get(key);
                this.writeStringOrNull(key, out);
                this.writeStringOrNull(value, out);
            }
        }
    }

    private void writeHostSpec(HostSpecificationImpl host, DataOutputStream out) throws IOException {
        if (host == null) {
            out.writeByte(0);
            return;
        }
        out.writeByte(1);
        this.writeVersionConstraint(host, out);
        BundleDescription[] hosts = host.getHosts();
        if (hosts == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(hosts.length);
        int i = 0;
        while (i < hosts.length) {
            this.writeBundleDescription(hosts[i], out);
            ++i;
        }
    }

    private void writeVersionConstraint(VersionConstraint constraint, DataOutputStream out) throws IOException {
        this.writeStringOrNull(constraint.getName(), out);
        this.writeVersionRange(constraint.getVersionRange(), out);
    }

    private void writeVersion(Version version, DataOutputStream out) throws IOException {
        if (version == null || version.equals(Version.emptyVersion)) {
            out.writeByte(0);
            return;
        }
        out.writeByte(1);
        out.writeInt(version.getMajor());
        out.writeInt(version.getMinor());
        out.writeInt(version.getMicro());
        this.writeQualifier(version.getQualifier(), out);
    }

    private void writeVersionRange(VersionRange versionRange, DataOutputStream out) throws IOException {
        if (versionRange == null || versionRange.equals(VersionRange.emptyRange)) {
            out.writeByte(0);
            return;
        }
        out.writeByte(1);
        this.writeVersion(versionRange.getMinimum(), out);
        out.writeBoolean(versionRange.getIncludeMinimum());
        this.writeVersion(versionRange.getMaximum(), out);
        out.writeBoolean(versionRange.getIncludeMaximum());
    }

    private boolean writeIndex(Object object, DataOutputStream out) throws IOException {
        if (object == null) {
            out.writeByte(0);
            return true;
        }
        int index = this.getFromObjectTable(object);
        if (index == -1) {
            return false;
        }
        out.writeByte(2);
        out.writeInt(index);
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveStateDeprecated(StateImpl state, DataOutputStream output) throws IOException {
        try {
            this.writeStateDeprecated(state, output);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            output.close();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        output.close();
    }

    private void writeStringOrNull(String string, DataOutputStream out) throws IOException {
        if (string == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(string);
        }
    }

    private void writeQualifier(String string, DataOutputStream out) throws IOException {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.writeStringOrNull(string, out);
    }
}

