/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;

class SegmentsTermDocs
implements TermDocs {
    protected SegmentReader[] readers;
    protected int[] starts;
    protected Term term;
    protected int base = 0;
    protected int pointer = 0;
    private SegmentTermDocs[] segTermDocs;
    protected SegmentTermDocs current;

    SegmentsTermDocs(SegmentReader[] r, int[] s) {
        this.readers = r;
        this.starts = s;
        this.segTermDocs = new SegmentTermDocs[r.length];
    }

    public final int doc() {
        return this.base + this.current.doc;
    }

    public final int freq() {
        return this.current.freq;
    }

    public final void seek(Term term) {
        this.term = term;
        this.base = 0;
        this.pointer = 0;
        this.current = null;
    }

    public final boolean next() throws IOException {
        if (this.current != null && this.current.next()) {
            return true;
        }
        if (this.pointer < this.readers.length) {
            this.base = this.starts[this.pointer];
            this.current = this.termDocs(this.pointer++);
            return this.next();
        }
        return false;
    }

    public final int read(int[] docs, int[] freqs) throws IOException {
        int end;
        while (true) {
            if (this.current == null) {
                if (this.pointer < this.readers.length) {
                    this.base = this.starts[this.pointer];
                    this.current = this.termDocs(this.pointer++);
                    continue;
                }
                return 0;
            }
            end = this.current.read(docs, freqs);
            if (end != 0) break;
            this.current = null;
        }
        int b = this.base;
        int i = 0;
        while (i < end) {
            int n = i++;
            docs[n] = docs[n] + b;
        }
        return end;
    }

    public boolean skipTo(int target) throws IOException {
        do {
            if (this.next()) continue;
            return false;
        } while (target > this.doc());
        return true;
    }

    private SegmentTermDocs termDocs(int i) throws IOException {
        if (this.term == null) {
            return null;
        }
        SegmentTermDocs result = this.segTermDocs[i];
        if (result == null) {
            result = this.segTermDocs[i] = this.termDocs(this.readers[i]);
        }
        result.seek(this.term);
        return result;
    }

    protected SegmentTermDocs termDocs(SegmentReader reader) throws IOException {
        return (SegmentTermDocs)reader.termDocs();
    }

    public final void close() throws IOException {
        int i = 0;
        while (i < this.segTermDocs.length) {
            if (this.segTermDocs[i] != null) {
                this.segTermDocs[i].close();
            }
            ++i;
        }
    }
}

