/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;

final class TermScorer
extends Scorer {
    private Weight weight;
    private TermDocs termDocs;
    private byte[] norms;
    private float weightValue;
    private int doc;
    private final int[] docs = new int[32];
    private final int[] freqs = new int[32];
    private int pointer;
    private int pointerMax;
    private static final int SCORE_CACHE_SIZE = 32;
    private float[] scoreCache = new float[32];

    TermScorer(Weight weight, TermDocs td, Similarity similarity, byte[] norms) throws IOException {
        super(similarity);
        this.weight = weight;
        this.termDocs = td;
        this.norms = norms;
        this.weightValue = weight.getValue();
        int i = 0;
        while (i < 32) {
            this.scoreCache[i] = this.getSimilarity().tf(i) * this.weightValue;
            ++i;
        }
        this.pointerMax = this.termDocs.read(this.docs, this.freqs);
        if (this.pointerMax != 0) {
            this.doc = this.docs[0];
        } else {
            this.termDocs.close();
            this.doc = Integer.MAX_VALUE;
        }
    }

    public final void score(HitCollector c, int end) throws IOException {
        int d = this.doc;
        Similarity similarity = this.getSimilarity();
        while (d < end) {
            int f = this.freqs[this.pointer];
            float score = f < 32 ? this.scoreCache[f] : similarity.tf(f) * this.weightValue;
            c.collect(d, score *= Similarity.decodeNorm(this.norms[d]));
            if (++this.pointer == this.pointerMax) {
                this.pointerMax = this.termDocs.read(this.docs, this.freqs);
                if (this.pointerMax != 0) {
                    this.pointer = 0;
                } else {
                    this.termDocs.close();
                    this.doc = Integer.MAX_VALUE;
                    return;
                }
            }
            d = this.docs[this.pointer];
        }
        this.doc = d;
    }

    public Explanation explain(int doc) throws IOException {
        TermQuery query = (TermQuery)this.weight.getQuery();
        Explanation tfExplanation = new Explanation();
        int tf = 0;
        while (this.pointer < this.pointerMax) {
            if (this.docs[this.pointer] == doc) {
                tf = this.freqs[this.pointer];
            }
            ++this.pointer;
        }
        if (tf == 0) {
            while (this.termDocs.next()) {
                if (this.termDocs.doc() != doc) continue;
                tf = this.termDocs.freq();
            }
        }
        this.termDocs.close();
        tfExplanation.setValue(this.getSimilarity().tf(tf));
        tfExplanation.setDescription("tf(termFreq(" + query.getTerm() + ")=" + tf + ")");
        return tfExplanation;
    }
}

