/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.content.ContentType;
import org.eclipse.core.internal.content.ContentTypeCatalog;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.internal.content.Util;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.osgi.util.NLS;

public class ContentTypeBuilder {
    public static final String PT_CONTENTTYPES = "contentTypes";
    private ContentTypeCatalog catalog;

    private static String getUniqueId(String namespace, String baseTypeId) {
        if (baseTypeId == null) {
            return null;
        }
        int separatorPosition = baseTypeId.lastIndexOf(46);
        if (separatorPosition == -1) {
            baseTypeId = String.valueOf(namespace) + '.' + baseTypeId;
        }
        return baseTypeId;
    }

    private static QualifiedName parseQualifiedName(String namespace, String value) {
        if (value == null) {
            return null;
        }
        int separatorPosition = value.lastIndexOf(46);
        if (separatorPosition == -1) {
            return new QualifiedName(namespace, value);
        }
        if (separatorPosition == 0 || separatorPosition == value.length() - 1) {
            return null;
        }
        namespace = value.substring(0, separatorPosition);
        String simpleValue = value.substring(separatorPosition + 1);
        return new QualifiedName(namespace, simpleValue);
    }

    private static byte parsePriority(String priority) {
        if (priority == null) {
            return 0;
        }
        if (priority.equals("high")) {
            return 1;
        }
        if (priority.equals("low")) {
            return -1;
        }
        if (!priority.equals("normal")) {
            return 0;
        }
        return 0;
    }

    protected ContentTypeBuilder(ContentTypeCatalog catalog) {
        this.catalog = catalog;
    }

    private void addFileAssociation(IConfigurationElement fileAssociationElement, ContentType target) {
        String[] fileNames = Util.parseItems(fileAssociationElement.getAttributeAsIs("file-names"));
        int i = 0;
        while (i < fileNames.length) {
            target.internalAddFileSpec(this.catalog, fileNames[i], 5);
            ++i;
        }
        String[] fileExtensions = Util.parseItems(fileAssociationElement.getAttributeAsIs("file-extensions"));
        int i2 = 0;
        while (i2 < fileExtensions.length) {
            target.internalAddFileSpec(this.catalog, fileExtensions[i2], 9);
            ++i2;
        }
    }

    public void buildCatalog() {
        IConfigurationElement[] allContentTypeCEs = this.getConfigurationElements();
        int i = 0;
        while (i < allContentTypeCEs.length) {
            if (allContentTypeCEs[i].getName().equals("content-type")) {
                this.registerContentType(allContentTypeCEs[i]);
            }
            ++i;
        }
        i = 0;
        while (i < allContentTypeCEs.length) {
            if (allContentTypeCEs[i].getName().equals("file-association")) {
                this.registerFileAssociation(allContentTypeCEs[i]);
            }
            ++i;
        }
    }

    private ContentType createContentType(IConfigurationElement contentTypeCE) {
        String defaultCharset;
        String simpleId = contentTypeCE.getAttributeAsIs("id");
        byte priority = ContentTypeBuilder.parsePriority(contentTypeCE.getAttributeAsIs("priority"));
        String namespace = contentTypeCE.getDeclaringExtension().getNamespace();
        String name = contentTypeCE.getAttribute("name");
        String[] fileNames = Util.parseItems(contentTypeCE.getAttributeAsIs("file-names"));
        String[] fileExtensions = Util.parseItems(contentTypeCE.getAttributeAsIs("file-extensions"));
        String baseTypeId = ContentTypeBuilder.getUniqueId(namespace, contentTypeCE.getAttributeAsIs("base-type"));
        String aliasTargetTypeId = ContentTypeBuilder.getUniqueId(namespace, contentTypeCE.getAttributeAsIs("alias-for"));
        IConfigurationElement[] propertyCEs = null;
        Map<Object, Object> defaultProperties = null;
        propertyCEs = contentTypeCE.getChildren("property");
        if (propertyCEs.length > 0) {
            defaultProperties = new HashMap();
            int i = 0;
            while (i < propertyCEs.length) {
                String propertyKey;
                QualifiedName qualifiedKey;
                String defaultValue = propertyCEs[i].getAttributeAsIs("default");
                if (defaultValue == null) {
                    defaultValue = "";
                }
                if ((qualifiedKey = ContentTypeBuilder.parseQualifiedName(namespace, propertyKey = propertyCEs[i].getAttributeAsIs("name"))) == null) {
                    if (ContentTypeManager.DEBUGGING) {
                        String message = NLS.bind((String)Messages.content_invalidProperty, (Object)propertyKey, (Object)ContentTypeBuilder.getUniqueId(namespace, simpleId));
                        ContentType.log(message, null);
                    }
                } else {
                    defaultProperties.put(qualifiedKey, defaultValue);
                }
                ++i;
            }
        }
        if ((defaultCharset = contentTypeCE.getAttributeAsIs("default-charset")) != null) {
            if (defaultProperties == null) {
                defaultProperties = Collections.singletonMap(IContentDescription.CHARSET, defaultCharset);
            } else if (!defaultProperties.containsKey(IContentDescription.CHARSET)) {
                defaultProperties.put(IContentDescription.CHARSET, defaultCharset);
            }
        }
        return ContentType.createContentType(this.catalog, namespace, simpleId, name, priority, fileExtensions, fileNames, baseTypeId, aliasTargetTypeId, defaultProperties, contentTypeCE);
    }

    protected IConfigurationElement[] getConfigurationElements() {
        IExtensionRegistry registry = InternalPlatform.getDefault().getRegistry();
        IExtensionPoint contentTypesXP = registry.getExtensionPoint("org.eclipse.core.runtime", PT_CONTENTTYPES);
        IConfigurationElement[] allContentTypeCEs = contentTypesXP.getConfigurationElements();
        return allContentTypeCEs;
    }

    private boolean isComplete(ContentType contentType) {
        String message = null;
        if (contentType.getSimpleId() == null) {
            message = NLS.bind((String)Messages.content_missingIdentifier, (Object)contentType.getId());
        } else if (contentType.getName() == null) {
            message = NLS.bind((String)Messages.content_missingName, (Object)contentType.getId());
        }
        if (message == null) {
            return true;
        }
        Status status = new Status(4, "org.eclipse.core.runtime", 0, message, null);
        InternalPlatform.getDefault().log(status);
        return false;
    }

    private void registerContentType(IConfigurationElement contentTypeCE) {
        ContentType contentType = this.createContentType(contentTypeCE);
        if (!this.isComplete(contentType)) {
            return;
        }
        this.catalog.addContentType(contentType);
    }

    private void registerFileAssociation(IConfigurationElement fileAssociationElement) {
        String contentTypeId = ContentTypeBuilder.getUniqueId(fileAssociationElement.getDeclaringExtension().getNamespace(), fileAssociationElement.getAttribute("content-type"));
        ContentType target = this.catalog.internalGetContentType(contentTypeId);
        if (target == null) {
            return;
        }
        this.addFileAssociation(fileAssociationElement, target);
    }
}

