/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.Contribution;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.HashtableOfInt;
import org.eclipse.core.internal.registry.HashtableOfStringAndInt;
import org.eclipse.core.internal.registry.KeyedHashSet;
import org.eclipse.core.internal.registry.RegistryObjectManager;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class TableReader {
    static final int NULL = 0;
    static final int OBJECT = 1;
    static final int CACHE_VERSION = 1;
    static final String MAIN = ".mainData";
    static File mainDataFile;
    DataInputStream mainInput = null;
    static final String EXTRA = ".extraData";
    static File extraDataFile;
    DataInputStream extraInput = null;
    static final String TABLE = ".table";
    static File tableFile;
    static final String CONTRIBUTIONS = ".contributions";
    static File contributionsFile;
    static final String ORPHANS = ".orphans";
    static File orphansFile;
    private static final byte fileError = 0;
    private static final boolean DEBUG = false;
    private boolean holdObjects = false;

    static void setMainDataFile(File main) {
        mainDataFile = main;
    }

    static void setExtraDataFile(File extra) {
        extraDataFile = extra;
    }

    static void setTableFile(File table) {
        tableFile = table;
    }

    static void setContributionsFile(File namespace) {
        contributionsFile = namespace;
    }

    static void setOrphansFile(File orphan) {
        orphansFile = orphan;
    }

    public TableReader() {
        this.openInputFile();
        this.openExtraFile();
    }

    private void openInputFile() {
        try {
            this.mainInput = new DataInputStream(new BufferedInputStream(new FileInputStream(mainDataFile)));
        }
        catch (FileNotFoundException e) {
            InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, Messages.meta_unableToReadCache, e));
        }
    }

    private void openExtraFile() {
        try {
            this.extraInput = new DataInputStream(new BufferedInputStream(new FileInputStream(extraDataFile)));
        }
        catch (FileNotFoundException e) {
            InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, Messages.meta_unableToReadCache, e));
        }
    }

    private void closeInputFile() {
        try {
            this.mainInput.close();
        }
        catch (IOException e) {
            InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, Messages.meta_registryCacheReadProblems, e));
        }
    }

    private void closeExtraFile() {
        try {
            this.extraInput.close();
        }
        catch (IOException e) {
            InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, Messages.meta_registryCacheReadProblems, e));
        }
    }

    public Object[] loadTables(long expectedTimestamp) {
        FilterInputStream tableInput = null;
        try {
            tableInput = new DataInputStream(new BufferedInputStream(new FileInputStream(tableFile)));
            if (!this.checkCacheValidity((DataInputStream)tableInput, expectedTimestamp)) {
                return null;
            }
            Integer nextId = new Integer(((DataInputStream)tableInput).readInt());
            HashtableOfInt offsets = new HashtableOfInt();
            offsets.load((DataInputStream)tableInput);
            HashtableOfStringAndInt extensionPoints = new HashtableOfStringAndInt();
            extensionPoints.load((DataInputStream)tableInput);
            return new Object[]{offsets, extensionPoints, nextId};
        }
        catch (IOException e) {
            if (tableInput != null) {
                try {
                    tableInput.close();
                }
                catch (IOException iOException) {}
            }
            InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, Messages.meta_registryCacheReadProblems, e));
            return null;
        }
    }

    private boolean checkCacheValidity(DataInputStream in, long expectedTimestamp) {
        try {
            int version = in.readInt();
            if (version != 1) {
                return false;
            }
            long installStamp = in.readLong();
            long registryStamp = in.readLong();
            long mainDataFileSize = in.readLong();
            long extraDataFileSize = in.readLong();
            long contributionsFileSize = in.readLong();
            long orphansFileSize = in.readLong();
            String osStamp = in.readUTF();
            String windowsStamp = in.readUTF();
            String localeStamp = in.readUTF();
            InternalPlatform info = InternalPlatform.getDefault();
            return (expectedTimestamp == 0L || expectedTimestamp == registryStamp) && installStamp == info.getStateTimeStamp() && osStamp.equals(info.getOS()) && windowsStamp.equals(info.getWS()) && localeStamp.equals(info.getNL()) && mainDataFileSize == mainDataFile.length() && extraDataFileSize == extraDataFile.length() && contributionsFileSize == contributionsFile.length() && orphansFileSize == orphansFile.length();
        }
        catch (IOException e) {
            InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, Messages.meta_registryCacheInconsistent, e));
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object loadConfigurationElement(int offset) {
        try {
            try {
                this.goToInputFile(offset);
                ConfigurationElement configurationElement = this.basicLoadConfigurationElement(this.mainInput, null);
                Object var3_4 = null;
                this.closeInputFile();
                this.closeExtraFile();
                return configurationElement;
            }
            catch (IOException e) {
                InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, Messages.meta_regCacheIOExceptionReading, e));
                Object var5_3 = null;
                Object var3_5 = null;
                this.closeInputFile();
                this.closeExtraFile();
                return var5_3;
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.closeInputFile();
            this.closeExtraFile();
            throw throwable;
        }
    }

    private ConfigurationElement basicLoadConfigurationElement(DataInputStream is, Bundle actualContributingBundle) throws IOException {
        int self = is.readInt();
        long contributingBundle = is.readLong();
        String name = this.readStringOrNull(is, false);
        int parentId = is.readInt();
        byte parentType = is.readByte();
        int misc = is.readInt();
        String[] propertiesAndValue = this.readPropertiesAndValue(is);
        int[] children = this.readArray(is);
        if (actualContributingBundle == null) {
            actualContributingBundle = this.getBundle(contributingBundle);
        }
        return new ConfigurationElement(self, actualContributingBundle, name, propertiesAndValue, children, misc, parentId, parentType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object loadThirdLevelConfigurationElements(int offset, RegistryObjectManager objectManager) {
        try {
            try {
                this.goToExtraFile(offset);
                ConfigurationElement configurationElement = this.loadConfigurationElementAndChildren(null, this.extraInput, 3, Integer.MAX_VALUE, objectManager, null);
                Object var4_5 = null;
                this.closeInputFile();
                this.closeExtraFile();
                return configurationElement;
            }
            catch (IOException e) {
                InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, Messages.meta_regCacheIOExceptionReading, e));
                Object var6_4 = null;
                Object var4_6 = null;
                this.closeInputFile();
                this.closeExtraFile();
                return var6_4;
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.closeInputFile();
            this.closeExtraFile();
            throw throwable;
        }
    }

    private ConfigurationElement loadConfigurationElementAndChildren(DataInputStream is, DataInputStream extraIs, int depth, int maxDepth, RegistryObjectManager objectManager, Bundle actualContributingBundle) throws IOException {
        DataInputStream currentStream = is;
        if (depth > 2) {
            currentStream = extraIs;
        }
        ConfigurationElement ce = this.basicLoadConfigurationElement(currentStream, actualContributingBundle);
        if (actualContributingBundle == null) {
            actualContributingBundle = ce.getContributingBundle();
        }
        int[] children = ce.getRawChildren();
        if (depth + 1 > maxDepth) {
            return ce;
        }
        int i = 0;
        while (i < children.length) {
            ConfigurationElement tmp = this.loadConfigurationElementAndChildren(currentStream, extraIs, depth + 1, maxDepth, objectManager, actualContributingBundle);
            objectManager.add(tmp, this.holdObjects);
            ++i;
        }
        return ce;
    }

    private String[] readPropertiesAndValue(DataInputStream inputStream) throws IOException {
        int numberOfProperties = inputStream.readInt();
        if (numberOfProperties == 0) {
            return RegistryObjectManager.EMPTY_STRING_ARRAY;
        }
        String[] properties = new String[numberOfProperties];
        int i = 0;
        while (i < numberOfProperties) {
            properties[i] = this.readStringOrNull(inputStream, false);
            ++i;
        }
        return properties;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object loadExtension(int offset) {
        try {
            try {
                this.goToInputFile(offset);
                Extension extension = this.basicLoadExtension(this.mainInput);
                Object var3_3 = null;
                this.closeExtraFile();
                this.closeInputFile();
                return extension;
            }
            catch (IOException e) {
                InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, Messages.meta_regCacheIOExceptionReading, e));
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.closeExtraFile();
            this.closeInputFile();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.closeExtraFile();
            this.closeInputFile();
            return null;
        }
    }

    private Bundle getBundle(long id) {
        return InternalPlatform.getDefault().getBundleContext().getBundle(id);
    }

    private Extension basicLoadExtension(DataInputStream inputStream) throws IOException {
        int self = inputStream.readInt();
        String simpleId = this.readStringOrNull(this.mainInput, false);
        String namespace = this.readStringOrNull(this.mainInput, false);
        int[] children = this.readArray(this.mainInput);
        int extraData = this.mainInput.readInt();
        return new Extension(self, simpleId, namespace, children, extraData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExtensionPoint loadExtensionPointTree(int offset, RegistryObjectManager objects) {
        try {
            try {
                ExtensionPoint xpt = (ExtensionPoint)this.loadExtensionPoint(offset);
                int[] children = xpt.getRawChildren();
                int nbrOfExtension = children.length;
                int i = 0;
                while (i < nbrOfExtension) {
                    Extension loaded = this.basicLoadExtension(this.mainInput);
                    objects.add(loaded, this.holdObjects);
                    ++i;
                }
                i = 0;
                while (i < nbrOfExtension) {
                    int nbrOfCe = this.mainInput.readInt();
                    int j = 0;
                    while (j < nbrOfCe) {
                        objects.add(this.loadConfigurationElementAndChildren(this.mainInput, this.extraInput, 1, 2, objects, null), this.holdObjects);
                        ++j;
                    }
                    ++i;
                }
                ExtensionPoint extensionPoint = xpt;
                Object var9_13 = null;
                this.closeExtraFile();
                this.closeInputFile();
                return extensionPoint;
            }
            catch (IOException e) {
                InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, Messages.meta_regCacheIOExceptionReading, e));
                ExtensionPoint extensionPoint = null;
                Object var9_14 = null;
                this.closeExtraFile();
                this.closeInputFile();
                return extensionPoint;
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            this.closeExtraFile();
            this.closeInputFile();
            throw throwable;
        }
    }

    private Object loadExtensionPoint(int offset) {
        try {
            this.goToInputFile(offset);
            return this.basicLoadExtensionPoint();
        }
        catch (IOException e) {
            InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, Messages.meta_regCacheIOExceptionReading, e));
            return null;
        }
    }

    private ExtensionPoint basicLoadExtensionPoint() throws IOException {
        int self = this.mainInput.readInt();
        int[] children = this.readArray(this.mainInput);
        int extraData = this.mainInput.readInt();
        return new ExtensionPoint(self, children, extraData);
    }

    private int[] readArray(DataInputStream in) throws IOException {
        int arraySize = in.readInt();
        if (arraySize == 0) {
            return RegistryObjectManager.EMPTY_INT_ARRAY;
        }
        int[] result = new int[arraySize];
        int i = 0;
        while (i < arraySize) {
            result[i] = in.readInt();
            ++i;
        }
        return result;
    }

    private void goToInputFile(int offset) throws IOException {
        this.mainInput.skipBytes(offset);
    }

    private void goToExtraFile(int offset) throws IOException {
        this.extraInput.skipBytes(offset);
    }

    private String readStringOrNull(DataInputStream in, boolean intern) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        if (intern) {
            return in.readUTF().intern();
        }
        return in.readUTF();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] loadExtensionExtraData(int dataPosition) {
        try {
            try {
                this.goToExtraFile(dataPosition);
                String[] stringArray = this.basicLoadExtensionExtraData();
                Object var3_4 = null;
                this.closeExtraFile();
                this.closeInputFile();
                return stringArray;
            }
            catch (IOException e) {
                InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, Messages.meta_regCacheIOExceptionReading, e));
                String[] stringArray = null;
                Object var3_5 = null;
                this.closeExtraFile();
                this.closeInputFile();
                return stringArray;
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.closeExtraFile();
            this.closeInputFile();
            throw throwable;
        }
    }

    private String[] basicLoadExtensionExtraData() throws IOException {
        return new String[]{this.readStringOrNull(this.extraInput, false), this.readStringOrNull(this.extraInput, false)};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] loadExtensionPointExtraData(int offset) {
        try {
            try {
                this.goToExtraFile(offset);
                String[] stringArray = this.basicLoadExtensionPointExtraData();
                Object var3_4 = null;
                this.closeExtraFile();
                this.closeInputFile();
                return stringArray;
            }
            catch (IOException e) {
                InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, Messages.meta_regCacheIOExceptionReading, e));
                String[] stringArray = null;
                Object var3_5 = null;
                this.closeExtraFile();
                this.closeInputFile();
                return stringArray;
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.closeExtraFile();
            this.closeInputFile();
            throw throwable;
        }
    }

    private String[] basicLoadExtensionPointExtraData() throws IOException {
        String[] result = new String[]{this.readStringOrNull(this.extraInput, false), this.readStringOrNull(this.extraInput, false), this.readStringOrNull(this.extraInput, false), this.readStringOrNull(this.extraInput, false), Long.toString(this.extraInput.readLong())};
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeyedHashSet loadNamespaces() {
        KeyedHashSet keyedHashSet;
        FilterInputStream namespaceInput = null;
        try {
            try {
                namespaceInput = new DataInputStream(new BufferedInputStream(new FileInputStream(contributionsFile)));
                int size = ((DataInputStream)namespaceInput).readInt();
                KeyedHashSet result = new KeyedHashSet(size);
                int i = 0;
                while (true) {
                    if (i >= size) {
                        keyedHashSet = result;
                        Object var6_9 = null;
                        if (namespaceInput == null) return keyedHashSet;
                        break;
                    }
                    Contribution n = new Contribution(((DataInputStream)namespaceInput).readLong());
                    n.setRawChildren(this.readArray((DataInputStream)namespaceInput));
                    result.add(n);
                    ++i;
                }
            }
            catch (IOException e) {
                InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, NLS.bind((String)Messages.meta_regCacheIOExceptionReading, (Object)contributionsFile), e));
                KeyedHashSet keyedHashSet2 = null;
                Object var6_10 = null;
                if (namespaceInput == null) return keyedHashSet2;
                try {
                    namespaceInput.close();
                    return keyedHashSet2;
                }
                catch (IOException iOException) {}
                return keyedHashSet2;
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            if (namespaceInput == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            namespaceInput.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        namespaceInput.close();
        return keyedHashSet;
    }

    private void loadAllOrphans(RegistryObjectManager objectManager) throws IOException {
        int orphans = objectManager.getOrphanExtensions().size();
        int k = 0;
        while (k < orphans) {
            int numberOfOrphanExtensions = this.mainInput.readInt();
            int i = 0;
            while (i < numberOfOrphanExtensions) {
                this.loadFullExtension(objectManager);
                ++i;
            }
            i = 0;
            while (i < numberOfOrphanExtensions) {
                int nbrOfCe = this.mainInput.readInt();
                int j = 0;
                while (j < nbrOfCe) {
                    objectManager.add(this.loadConfigurationElementAndChildren(this.mainInput, this.extraInput, 1, Integer.MAX_VALUE, objectManager, null), true);
                    ++j;
                }
                ++i;
            }
            ++k;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean readAllCache(RegistryObjectManager objectManager) {
        try {
            try {
                int size = objectManager.getExtensionPoints().size();
                int i = 0;
                while (true) {
                    block6: {
                        if (i < size) break block6;
                        this.loadAllOrphans(objectManager);
                        break;
                    }
                    objectManager.add(this.readAllExtensionPointTree(objectManager), this.holdObjects);
                    ++i;
                }
            }
            catch (IOException e) {
                InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 0, Messages.meta_regCacheIOExceptionReading, e));
                Object var4_5 = null;
                this.closeExtraFile();
                this.closeInputFile();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeExtraFile();
            this.closeInputFile();
            throw throwable;
        }
        {
            Object var4_7 = null;
            this.closeExtraFile();
            this.closeInputFile();
            return true;
        }
    }

    public ExtensionPoint readAllExtensionPointTree(RegistryObjectManager objectManager) throws IOException {
        ExtensionPoint xpt = this.loadFullExtensionPoint();
        int[] children = xpt.getRawChildren();
        int nbrOfExtension = children.length;
        int i = 0;
        while (i < nbrOfExtension) {
            this.loadFullExtension(objectManager);
            ++i;
        }
        i = 0;
        while (i < nbrOfExtension) {
            int nbrOfCe = this.mainInput.readInt();
            int j = 0;
            while (j < nbrOfCe) {
                objectManager.add(this.loadConfigurationElementAndChildren(this.mainInput, this.extraInput, 1, Integer.MAX_VALUE, objectManager, null), true);
                ++j;
            }
            ++i;
        }
        return xpt;
    }

    private ExtensionPoint loadFullExtensionPoint() throws IOException {
        ExtensionPoint xpt = this.basicLoadExtensionPoint();
        String[] tmp = this.basicLoadExtensionPointExtraData();
        xpt.setLabel(tmp[0]);
        xpt.setSchema(tmp[1]);
        xpt.setUniqueIdentifier(tmp[2]);
        xpt.setNamespace(tmp[3]);
        xpt.setBundleId(Long.parseLong(tmp[4]));
        return xpt;
    }

    private Extension loadFullExtension(RegistryObjectManager objectManager) throws IOException {
        Extension loaded = this.basicLoadExtension(this.mainInput);
        String[] tmp = this.basicLoadExtensionExtraData();
        loaded.setLabel(tmp[0]);
        loaded.setExtensionPointIdentifier(tmp[1]);
        objectManager.add(loaded, this.holdObjects);
        return loaded;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap loadOrphans() {
        HashMap<String, int[]> hashMap;
        FilterInputStream orphanInput = null;
        try {
            try {
                orphanInput = new DataInputStream(new BufferedInputStream(new FileInputStream(orphansFile)));
                int size = ((DataInputStream)orphanInput).readInt();
                HashMap<String, int[]> result = new HashMap<String, int[]>(size);
                int i = 0;
                while (true) {
                    if (i >= size) {
                        hashMap = result;
                        Object var7_9 = null;
                        if (orphanInput == null) return hashMap;
                        break;
                    }
                    String key = ((DataInputStream)orphanInput).readUTF();
                    int[] value = this.readArray((DataInputStream)orphanInput);
                    result.put(key, value);
                    ++i;
                }
            }
            catch (IOException iOException) {
                HashMap hashMap2 = null;
                Object var7_10 = null;
                if (orphanInput == null) return hashMap2;
                try {
                    orphanInput.close();
                    return hashMap2;
                }
                catch (IOException iOException2) {}
                return hashMap2;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (orphanInput == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            orphanInput.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        orphanInput.close();
        return hashMap;
    }

    public void setHoldObjects(boolean holdObjects) {
        this.holdObjects = holdObjects;
    }
}

