/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.ListenerList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class PerformanceStatsProcessor
extends Job {
    private static final PerformanceStatsProcessor instance = new PerformanceStatsProcessor();
    private static final long SCHEDULE_DELAY = 2000L;
    private final ArrayList changes = new ArrayList();
    private final HashMap failures = new HashMap();
    private final ListenerList listeners = new ListenerList();

    public static void addListener(PerformanceStats.PerformanceListener listener) {
        PerformanceStatsProcessor.instance.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changed(PerformanceStats stats) {
        PerformanceStatsProcessor performanceStatsProcessor = instance;
        synchronized (performanceStatsProcessor) {
            PerformanceStatsProcessor.instance.changes.add(stats);
        }
        instance.schedule(2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void failed(PerformanceStats stats, long elapsed) {
        PerformanceStatsProcessor performanceStatsProcessor = instance;
        synchronized (performanceStatsProcessor) {
            PerformanceStatsProcessor.instance.failures.put(stats, new Long(elapsed));
        }
        instance.schedule(2000L);
        InternalPlatform platform = InternalPlatform.getDefault();
        String pluginId = platform.getBundleId(stats.getBlame());
        if (pluginId == null) {
            pluginId = "org.eclipse.core.runtime";
        }
        String msg = "Performance failure: " + stats.getEvent() + " blame: " + stats.getBlameString() + " context: " + stats.getContext() + " duration: " + elapsed;
        platform.log(new Status(2, pluginId, 1, msg, new RuntimeException()));
    }

    public static void printStats(PrintWriter out) {
        PerformanceStats stats;
        long totalTime = 0L;
        int totalCount = 0;
        PerformanceStats[] allStats = PerformanceStats.getAllStats();
        int i = 0;
        while (i < allStats.length) {
            stats = allStats[i];
            totalTime += stats.getRunningTime();
            totalCount += stats.getRunCount();
            ++i;
        }
        out.println("---------------------------------------------------------------");
        i = 0;
        while (i < allStats.length) {
            long runTime;
            stats = allStats[i];
            out.print("Event: ");
            out.print(stats.getEvent());
            out.print(" Blame: ");
            out.print(stats.getBlame());
            if (stats.getContext() != null) {
                out.print(" Context: ");
                out.print(stats.getContext());
            }
            out.println();
            int runCount = stats.getRunCount();
            if (runCount > 0) {
                out.print("Run count: ");
                out.print(Integer.toString(runCount));
                out.print(" (");
                out.print(Integer.toString((int)((double)runCount * 100.0 / (double)totalCount)));
                out.println(" % of total)");
            }
            if ((runTime = stats.getRunningTime()) > 0L) {
                out.print("Duration (ms): ");
                out.print(Long.toString(runTime));
                out.print(" (");
                out.print(Integer.toString((int)((double)runTime * 100.0 / (double)totalTime)));
                out.println(" % of total)");
            }
            out.println("");
            ++i;
        }
    }

    public static void removeListener(PerformanceStats.PerformanceListener listener) {
        PerformanceStatsProcessor.instance.listeners.remove(listener);
    }

    private PerformanceStatsProcessor() {
        super("Event Stats");
        this.setSystem(true);
        this.setPriority(50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        Long[] failedTimes;
        PerformanceStats[] failedEvents;
        PerformanceStats[] events;
        PerformanceStatsProcessor performanceStatsProcessor = this;
        synchronized (performanceStatsProcessor) {
            events = this.changes.toArray(new PerformanceStats[this.changes.size()]);
            this.changes.clear();
            failedEvents = this.failures.keySet().toArray(new PerformanceStats[this.failures.size()]);
            failedTimes = this.failures.values().toArray(new Long[this.failures.size()]);
            this.failures.clear();
        }
        Object[] toNotify = this.listeners.getListeners();
        int i = 0;
        while (i < toNotify.length) {
            PerformanceStats.PerformanceListener listener = (PerformanceStats.PerformanceListener)toNotify[i];
            if (events.length > 0) {
                listener.eventsOccurred(events);
            }
            int j = 0;
            while (j < failedEvents.length) {
                listener.eventFailed(failedEvents[j], failedTimes[j]);
                ++j;
            }
            ++i;
        }
        this.schedule(2000L);
        return Status.OK_STATUS;
    }

    public boolean shouldRun() {
        return !this.changes.isEmpty();
    }
}

