/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.Control;

class StyledTextBidi {
    private GC gc;
    private int[] bidiSegments;
    private int[] renderPositions;
    private int[] order;
    private int[] dx;
    private byte[] classBuffer;
    private char[] glyphBuffer;
    private boolean isRightOriented;

    public StyledTextBidi(GC gc, int tabWidth, String text, StyleRange[] ranges, Font boldFont, int[] offsets) {
        int length = text.length();
        this.isRightOriented = (gc.getStyle() & 0x8000000) != 0;
        this.gc = gc;
        this.bidiSegments = offsets;
        this.renderPositions = new int[length];
        this.order = new int[length];
        this.dx = new int[length];
        this.classBuffer = new byte[length];
        if (length == 0) {
            this.glyphBuffer = new char[0];
        } else {
            this.glyphBuffer = BidiUtil.getRenderInfo(gc, text, this.order, this.classBuffer, this.dx, 0, offsets);
            if (ranges != null) {
                StyleRange[] segmentedRanges = StyledTextBidi.isCharacterShaped(gc) ? this.getSegmentedRangesFor(ranges) : ranges;
                Font normalFont = gc.getFont();
                gc.setFont(boldFont);
                int i = 0;
                while (i < segmentedRanges.length) {
                    StyleRange segmentedRange = segmentedRanges[i];
                    int rangeStart = segmentedRange.start;
                    int rangeLength = segmentedRange.length;
                    this.prepareFontStyledText(text, rangeStart, rangeLength);
                    ++i;
                }
                gc.setFont(normalFont);
            }
            this.calculateTabStops(text, tabWidth);
            this.calculateRenderPositions();
        }
    }

    public StyledTextBidi(GC gc, String text, int[] offsets) {
        int length = text.length();
        this.isRightOriented = (gc.getStyle() & 0x8000000) != 0;
        this.gc = gc;
        this.bidiSegments = offsets;
        this.order = new int[length];
        this.classBuffer = new byte[length];
        BidiUtil.getOrderInfo(gc, text, this.order, this.classBuffer, 0, offsets);
        this.dx = new int[0];
        this.renderPositions = new int[0];
        this.glyphBuffer = new char[0];
    }

    static void addLanguageListener(Control control, Runnable runnable) {
        BidiUtil.addLanguageListener(control.handle, runnable);
    }

    static int getKeyboardLanguageDirection() {
        int language = BidiUtil.getKeyboardLanguage();
        if (language == 1) {
            return 131072;
        }
        if (BidiUtil.isKeyboardBidi()) {
            return 16384;
        }
        return -1;
    }

    static boolean isBidiPlatform() {
        return BidiUtil.isBidiPlatform();
    }

    static boolean isCharacterShaped(GC gc) {
        return (BidiUtil.getFontBidiAttributes(gc) & 0x10) != 0;
    }

    static boolean isLigated(GC gc) {
        return (BidiUtil.getFontBidiAttributes(gc) & 0x20) != 0;
    }

    static void removeLanguageListener(Control control) {
        BidiUtil.removeLanguageListener(control.handle);
    }

    private void calculateRenderPositions() {
        this.renderPositions = new int[this.dx.length];
        this.renderPositions[0] = 3;
        int i = 0;
        while (i < this.dx.length - 1) {
            this.renderPositions[i + 1] = this.renderPositions[i] + this.dx[i];
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void calculateTabStops(String text, int tabWidth) {
        tabIndex = text.indexOf(9, 0);
        logicalIndex = 0;
        x = 0;
        spaceWidth = this.gc.stringExtent((String)" ").x;
        ** GOTO lbl16
        {
            x += this.dx[this.order[logicalIndex]];
            ++logicalIndex;
            do {
                if (logicalIndex < tabIndex) continue block0;
                tabStop = x + tabWidth;
                if (tabWidth - tabStop % tabWidth < spaceWidth) {
                    tabStop += tabWidth;
                }
                tabStop -= tabStop % tabWidth;
                this.dx[this.order[tabIndex]] = tabStop - x;
                tabIndex = text.indexOf(9, tabIndex + 1);
lbl16:
                // 2 sources

            } while (tabIndex != -1);
        }
    }

    void drawBidiText(int logicalStart, int length, int xOffset, int yOffset) {
        int endOffset = logicalStart + length;
        if (logicalStart < 0 || endOffset > this.getTextLength()) {
            return;
        }
        Enumeration directionRuns = this.getDirectionRuns(logicalStart, length).elements();
        while (directionRuns.hasMoreElements()) {
            DirectionRun run = (DirectionRun)directionRuns.nextElement();
            int visualStart = run.getVisualStart();
            int visualEnd = run.getVisualEnd();
            int x = xOffset + run.getRenderStartX();
            this.drawGlyphs(visualStart, visualEnd - visualStart + 1, x, yOffset);
        }
    }

    private void drawGlyphs(int visualStart, int length, int x, int y) {
        char[] renderBuffer = new char[length];
        int[] renderDx = new int[length];
        if (length == 0) {
            return;
        }
        System.arraycopy(this.glyphBuffer, visualStart, renderBuffer, 0, length);
        System.arraycopy(this.dx, visualStart, renderDx, 0, length);
        BidiUtil.drawGlyphs(this.gc, renderBuffer, renderDx, x, y);
    }

    /*
     * Unable to fully structure code
     */
    void fillBackground(int logicalStart, int length, int xOffset, int yOffset, int height) {
        directionRuns = this.getDirectionRuns(logicalStart, length).elements();
        if (logicalStart >= 0 && logicalStart + length <= this.getTextLength()) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            run = (DirectionRun)directionRuns.nextElement();
            startX = run.getRenderStartX();
            this.gc.fillRectangle(xOffset + startX, yOffset, run.getRenderStopX() - startX, height);
lbl7:
            // 2 sources

            ** while (directionRuns.hasMoreElements())
        }
lbl8:
        // 1 sources

    }

    int[] getCaretOffsetAndDirectionAtX(int x) {
        int direction;
        boolean visualLeft;
        int lineLength = this.getTextLength();
        if (lineLength == 0) {
            return new int[2];
        }
        int eol = this.renderPositions[this.renderPositions.length - 1] + this.dx[this.dx.length - 1];
        if (x >= eol) {
            return new int[]{lineLength, 0x1000004};
        }
        int visualOffset = this.getVisualOffsetAtX(x);
        int halfway = this.renderPositions[visualOffset] + this.dx[visualOffset] / 2;
        int offset = this.getLogicalOffset(visualOffset);
        if (this.isRightOriented) {
            visualLeft = x > halfway;
        } else {
            boolean bl = visualLeft = x <= halfway;
        }
        if (this.isRightToLeft(offset)) {
            if (visualLeft) {
                if (StyledTextBidi.isLigated(this.gc)) {
                    offset = this.getLigatureEndOffset(offset);
                }
                direction = 0x1000004;
            } else {
                direction = 0x1000003;
            }
        } else if (visualLeft) {
            direction = 0x1000003;
        } else {
            ++offset;
            direction = 0x1000004;
        }
        return new int[]{++offset, direction};
    }

    private Vector getDirectionRuns(int logicalStart, int length) {
        int checkSide;
        int segmentLogicalStart;
        Vector<DirectionRun> directionRuns = new Vector<DirectionRun>();
        int logicalEnd = logicalStart + length - 1;
        int segmentLogicalEnd = segmentLogicalStart = logicalStart;
        int n = checkSide = this.isRightOriented ? -1 : 1;
        if (logicalEnd < this.getTextLength()) {
            int bidiSegmentIndex = 0;
            int bidiSegmentEnd = this.bidiSegments[bidiSegmentIndex + 1];
            while (bidiSegmentIndex < this.bidiSegments.length - 2 && bidiSegmentEnd <= logicalStart) {
                bidiSegmentEnd = this.bidiSegments[++bidiSegmentIndex + 1];
            }
            while (segmentLogicalEnd <= logicalEnd) {
                boolean isRightToLeftSegment = this.isRightToLeft(segmentLogicalStart);
                while (segmentLogicalEnd < logicalEnd && (this.order[segmentLogicalEnd + 1] == this.order[segmentLogicalEnd] || isRightToLeftSegment && this.order[segmentLogicalEnd + 1] + checkSide == this.order[segmentLogicalEnd] || !isRightToLeftSegment && this.order[segmentLogicalEnd + 1] - checkSide == this.order[segmentLogicalEnd]) && segmentLogicalEnd + 1 < bidiSegmentEnd) {
                    ++segmentLogicalEnd;
                }
                directionRuns.addElement(new DirectionRun(segmentLogicalStart, segmentLogicalEnd));
                segmentLogicalStart = ++segmentLogicalEnd;
                if (segmentLogicalEnd != bidiSegmentEnd || bidiSegmentIndex >= this.bidiSegments.length - 2) continue;
                bidiSegmentEnd = this.bidiSegments[++bidiSegmentIndex + 1];
            }
        }
        return directionRuns;
    }

    /*
     * Unable to fully structure code
     */
    int getLigatureEndOffset(int offset) {
        newOffset = offset;
        i = offset + 1;
        if (offset >= 0 && offset < this.order.length && this.isRightToLeft(offset)) ** GOTO lbl6
        return offset;
lbl-1000:
        // 1 sources

        {
            newOffset = i++;
lbl6:
            // 2 sources

            ** while (i < this.order.length && this.order[i] == this.order[offset])
        }
lbl7:
        // 1 sources

        return newOffset;
    }

    /*
     * Unable to fully structure code
     */
    int getLigatureStartOffset(int offset) {
        newOffset = offset;
        i = offset - 1;
        if (offset >= 0 && offset < this.order.length && this.isRightToLeft(offset)) ** GOTO lbl6
        return offset;
lbl-1000:
        // 1 sources

        {
            newOffset = i--;
lbl6:
            // 2 sources

            ** while (i >= 0 && this.order[i] == this.order[offset])
        }
lbl7:
        // 1 sources

        return newOffset;
    }

    int getLogicalOffset(int visualOffset) {
        int logicalOffset = 0;
        while (logicalOffset < this.order.length && this.order[logicalOffset] != visualOffset) {
            ++logicalOffset;
        }
        return logicalOffset;
    }

    int getOffsetAtX(int x) {
        if (this.getTextLength() == 0) {
            return 0;
        }
        if (x >= this.renderPositions[this.renderPositions.length - 1] + this.dx[this.dx.length - 1]) {
            return -1;
        }
        int visualOffset = this.getVisualOffsetAtX(x);
        return this.getLogicalOffset(visualOffset);
    }

    private int[] getRenderIndexesFor(int start, int length) {
        int[] positions = new int[length];
        int end = start + length;
        int i = start;
        while (i < end) {
            positions[i - start] = this.order[i];
            ++i;
        }
        return positions;
    }

    private StyleRange[] getSegmentedRangesFor(StyleRange[] ranges) {
        if (this.bidiSegments == null || this.bidiSegments.length == 0) {
            return ranges;
        }
        Vector<StyleRange> newRanges = new Vector<StyleRange>();
        int j = 0;
        int i = 0;
        while (i < ranges.length) {
            StyleRange newStyle;
            int start = ranges[i].start;
            int end = start + ranges[i].length;
            int startSegment = -1;
            int endSegment = -1;
            boolean done = false;
            while (j < this.bidiSegments.length && !done) {
                if (this.bidiSegments[j] <= start) {
                    startSegment = j;
                }
                if (this.bidiSegments[j] >= end) {
                    endSegment = j - 1;
                    --j;
                }
                boolean bl = done = startSegment != -1 && endSegment != -1;
                if (done) continue;
                ++j;
            }
            if (startSegment == endSegment) {
                newStyle = new StyleRange(start, end - start, null, null);
                newRanges.addElement(newStyle);
            } else if (startSegment <= endSegment) {
                newStyle = new StyleRange(start, this.bidiSegments[startSegment + 1] - start, null, null);
                newRanges.addElement(newStyle);
                int k = ++startSegment;
                while (k < endSegment) {
                    newStyle = new StyleRange(this.bidiSegments[k], this.bidiSegments[k + 1] - this.bidiSegments[k], null, null);
                    newRanges.addElement(newStyle);
                    ++k;
                }
                newStyle = new StyleRange(this.bidiSegments[endSegment], end - this.bidiSegments[endSegment], null, null);
                newRanges.addElement(newStyle);
            }
            ++i;
        }
        StyleRange[] rangeArray = new StyleRange[newRanges.size()];
        int i2 = 0;
        while (i2 < newRanges.size()) {
            rangeArray[i2] = (StyleRange)newRanges.elementAt(i2);
            ++i2;
        }
        return rangeArray;
    }

    private int getTextLength() {
        return this.dx.length;
    }

    int getTextPosition(int logicalOffset) {
        return this.getTextPosition(logicalOffset, 0x1000004);
    }

    int getTextPosition(int logicalOffset, int direction) {
        int caretX;
        if (this.getTextLength() == 0 || logicalOffset < 0) {
            return 3;
        }
        boolean isRightToLeft = this.isRightToLeft(logicalOffset);
        if (logicalOffset >= this.order.length) {
            logicalOffset = Math.min(logicalOffset, this.order.length - 1);
            isRightToLeft = this.isRightToLeft(logicalOffset);
            int visualOffset = this.order[logicalOffset];
            caretX = !this.isRightOriented && !isRightToLeft || this.isRightOriented && isRightToLeft ? this.renderPositions[visualOffset] + this.dx[visualOffset] : this.renderPositions[visualOffset];
        } else if (logicalOffset == 0) {
            int visualOffset = this.order[logicalOffset];
            caretX = !this.isRightOriented && !isRightToLeft || this.isRightOriented && isRightToLeft ? this.renderPositions[visualOffset] : this.renderPositions[visualOffset] + this.dx[visualOffset];
        } else if (direction == 0x1000004 && (this.isRightToLeft(logicalOffset) != this.isRightToLeft(logicalOffset - 1) || this.isLocalNumber(logicalOffset) != this.isLocalNumber(logicalOffset - 1) || this.isStartOfBidiSegment(logicalOffset))) {
            int visualOffset = this.order[logicalOffset - 1];
            isRightToLeft = this.isRightToLeft(logicalOffset - 1);
            caretX = !this.isRightOriented && !isRightToLeft || this.isRightOriented && isRightToLeft ? this.renderPositions[visualOffset] + this.dx[visualOffset] : this.renderPositions[visualOffset];
        } else if (direction == 0x1000003 && this.isRightToLeftInput(logicalOffset) != this.isRightToLeftInput(logicalOffset - 1)) {
            int visualOffset = this.order[logicalOffset];
            isRightToLeft = this.isRightToLeft(logicalOffset - 1);
            caretX = !this.isRightOriented && !isRightToLeft || this.isRightOriented && isRightToLeft ? this.renderPositions[visualOffset] + this.dx[visualOffset] : this.renderPositions[visualOffset];
        } else {
            int visualOffset = this.order[logicalOffset];
            caretX = !this.isRightOriented && !isRightToLeft || this.isRightOriented && isRightToLeft ? this.renderPositions[visualOffset] : this.renderPositions[visualOffset] + this.dx[visualOffset];
        }
        return caretX;
    }

    int getTextWidth() {
        int width = 0;
        if (this.getTextLength() > 0) {
            width = this.renderPositions[this.renderPositions.length - 1] + this.dx[this.dx.length - 1];
        }
        return width;
    }

    int getVisualOffset(int logicalOffset) {
        return this.order[logicalOffset];
    }

    private int getVisualOffsetAtX(int x) {
        int lineLength = this.getTextLength();
        int low = -1;
        int high = lineLength;
        while (high - low > 1) {
            int offset = (high + low) / 2;
            int visualX = this.renderPositions[offset];
            if (x < visualX + this.dx[offset]) {
                high = offset;
                continue;
            }
            if (high == lineLength && high - offset == 1) {
                high = -1;
                continue;
            }
            low = offset;
        }
        return high;
    }

    boolean isLatinNumber(int logicalIndex) {
        boolean isLatinNumber = false;
        if (logicalIndex >= 0 && logicalIndex < this.classBuffer.length) {
            isLatinNumber = this.classBuffer[logicalIndex] == 5;
        }
        return isLatinNumber;
    }

    boolean isLocalNumber(int logicalIndex) {
        boolean isLocalNumber = false;
        if (logicalIndex >= 0 && logicalIndex < this.classBuffer.length) {
            isLocalNumber = this.classBuffer[logicalIndex] == 4;
        }
        return isLocalNumber;
    }

    boolean isRightToLeft(int logicalIndex) {
        boolean isRightToLeft = false;
        if (logicalIndex >= 0 && logicalIndex < this.classBuffer.length) {
            isRightToLeft = this.classBuffer[logicalIndex] == 2 || this.classBuffer[logicalIndex] == 2;
        }
        return isRightToLeft;
    }

    boolean isRightToLeftInput(int logicalIndex) {
        boolean isRightToLeft = false;
        if (logicalIndex >= 0 && logicalIndex < this.classBuffer.length) {
            isRightToLeft = this.classBuffer[logicalIndex] == 2 || this.classBuffer[logicalIndex] == 2 || this.classBuffer[logicalIndex] == 4;
        }
        return isRightToLeft;
    }

    private boolean isStartOfBidiSegment(int logicalIndex) {
        int i = 0;
        while (i < this.bidiSegments.length) {
            if (this.bidiSegments[i] == logicalIndex) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void prepareFontStyledText(String textline, int logicalStart, int length) {
        int byteCount = length;
        int flags = 0;
        String text = textline.substring(logicalStart, logicalStart + length);
        if (logicalStart != 0 && StyledTextBidi.isCharacterShaped(this.gc) && !this.isStartOfBidiSegment(logicalStart) && !Compatibility.isWhitespace(textline.charAt(logicalStart - 1)) && this.isRightToLeft(logicalStart - 1)) {
            flags |= 2;
        }
        if (logicalStart + byteCount != this.dx.length && StyledTextBidi.isCharacterShaped(this.gc) && !this.isStartOfBidiSegment(logicalStart + length) && !Compatibility.isWhitespace(textline.charAt(logicalStart + byteCount)) && this.isRightToLeft(logicalStart + byteCount)) {
            flags |= 4;
        }
        flags |= 1;
        byte[] classArray = new byte[byteCount];
        int[] renderIndexes = this.getRenderIndexesFor(logicalStart, byteCount);
        int i = 0;
        while (i < byteCount) {
            classArray[i] = this.classBuffer[renderIndexes[i]];
            ++i;
        }
        int[] dxArray = new int[byteCount];
        int[] orderArray = new int[byteCount];
        int[] nArray = new int[2];
        nArray[1] = text.length();
        char[] boldGlyphBuffer = BidiUtil.getRenderInfo(this.gc, text, orderArray, classArray, dxArray, flags, nArray);
        int i2 = 0;
        while (i2 < dxArray.length) {
            int index = orderArray[i2];
            int visualIndex = renderIndexes[i2];
            this.dx[visualIndex] = dxArray[index];
            this.glyphBuffer[visualIndex] = boldGlyphBuffer[index];
            ++i2;
        }
    }

    void redrawRange(Control parent, int logicalStart, int length, int xOffset, int yOffset, int height) {
        if (logicalStart < 0 || logicalStart + length > this.getTextLength()) {
            return;
        }
        Enumeration directionRuns = this.getDirectionRuns(logicalStart, length).elements();
        while (directionRuns.hasMoreElements()) {
            DirectionRun run = (DirectionRun)directionRuns.nextElement();
            int startX = run.getRenderStartX();
            parent.redraw(xOffset + startX, yOffset, run.getRenderStopX() - startX, height, true);
        }
    }

    void setKeyboardLanguage(int logicalIndex) {
        int language;
        int current = BidiUtil.getKeyboardLanguage();
        if (logicalIndex < 0 || logicalIndex >= this.classBuffer.length) {
            return;
        }
        if (this.isRightToLeftInput(logicalIndex)) {
            if (current == 1) {
                return;
            }
            language = 1;
        } else {
            if (current == 0) {
                return;
            }
            language = 0;
        }
        BidiUtil.setKeyboardLanguage(language);
    }

    static boolean setOrientation(Control control, int orientation) {
        return BidiUtil.setOrientation(control.handle, orientation);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("StyledTextBidi {{");
        int i = 0;
        while (i < this.order.length) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(this.order[i]);
            ++i;
        }
        buf.append("}, {");
        i = 0;
        while (i < this.renderPositions.length) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(this.renderPositions[i]);
            ++i;
        }
        buf.append("}, {");
        i = 0;
        while (i < this.dx.length) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(this.dx[i]);
            ++i;
        }
        buf.append("}, {");
        i = 0;
        while (i < this.classBuffer.length) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(this.classBuffer[i]);
            ++i;
        }
        buf.append("}, {");
        buf.append(this.glyphBuffer);
        buf.append("}}");
        return buf.toString();
    }

    class DirectionRun {
        int logicalStart;
        int logicalEnd;

        DirectionRun(int logicalStart, int logicalEnd) {
            this.logicalStart = logicalStart;
            this.logicalEnd = logicalEnd;
        }

        int getVisualStart() {
            int visualStart = StyledTextBidi.this.order[this.logicalStart];
            int visualEnd = StyledTextBidi.this.order[this.logicalEnd];
            if (visualEnd < visualStart) {
                visualStart = visualEnd;
            }
            return visualStart;
        }

        int getVisualEnd() {
            int visualStart = StyledTextBidi.this.order[this.logicalStart];
            int visualEnd = StyledTextBidi.this.order[this.logicalEnd];
            if (visualEnd < visualStart) {
                visualEnd = visualStart;
            }
            return visualEnd;
        }

        int getRenderStartX() {
            return StyledTextBidi.this.renderPositions[this.getVisualStart()];
        }

        int getRenderStopX() {
            int visualEnd = this.getVisualEnd();
            return StyledTextBidi.this.renderPositions[visualEnd] + StyledTextBidi.this.dx[visualEnd];
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("vStart,Stop:" + this.getVisualStart() + "," + this.getVisualEnd() + " lStart,Stop:" + this.logicalStart + "," + this.logicalEnd + " renderStart,Stop: " + this.getRenderStartX() + "," + this.getRenderStopX());
            return buf.toString();
        }
    }
}

