/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventWindowState;
import org.eclipse.swt.internal.gtk.GdkGeometry;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GdkWindowAttr;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XCrossingEvent;
import org.eclipse.swt.internal.gtk.XFocusChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.TypedListener;

public class Shell
extends Decorations {
    int shellHandle;
    int tooltipsHandle;
    boolean hasFocus;
    boolean mapped;
    boolean moved;
    boolean resized;
    boolean opened;
    int oldX;
    int oldY;
    int oldWidth;
    int oldHeight;
    int minWidth;
    int minHeight;
    Control lastActive;
    Region region;

    public Shell() {
        this((Display)null);
    }

    public Shell(int style) {
        this((Display)null, style);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int style) {
        this(display, null, style, 0);
    }

    Shell(Display display, Shell parent, int style, int handle) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Shell.checkStyle(style);
        this.parent = parent;
        this.display = display;
        this.handle = handle;
        this.createWidget(0);
    }

    public Shell(Shell parent) {
        this(parent, 2144);
    }

    public Shell(Shell parent, int style) {
        this(parent != null ? parent.display : null, parent, style, 0);
    }

    public static Shell gtk_new(Display display, int handle) {
        return new Shell(display, null, 8, handle);
    }

    static int checkStyle(int style) {
        if (((style = Decorations.checkStyle(style)) & 0x4000) != 0) {
            style &= 0xFFFFFB0F;
        }
        int mask = 229376;
        int bits = style & ~mask;
        if ((style & 0x20000) != 0) {
            return bits | 0x20000;
        }
        if ((style & 0x10000) != 0) {
            return bits | 0x10000;
        }
        if ((style & 0x8000) != 0) {
            return bits | 0x8000;
        }
        return bits;
    }

    public void addShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(21, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
        this.addListener(26, typedListener);
        this.addListener(27, typedListener);
    }

    void adjustTrim() {
        int[] width = new int[1];
        int[] height = new int[1];
        OS.gtk_window_get_size((int)this.shellHandle, (int[])width, (int[])height);
        int window = OS.GTK_WIDGET_WINDOW((int)this.shellHandle);
        GdkRectangle rect = new GdkRectangle();
        OS.gdk_window_get_frame_extents((int)window, (GdkRectangle)rect);
        int trimWidth = Math.max(0, rect.width - width[0]);
        int trimHeight = Math.max(0, rect.height - height[0]);
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        if ((this.style & 8) == 0) {
            hasTitle = (this.style & 0x4E0) != 0;
            hasResize = (this.style & 0x10) != 0;
            boolean bl = hasBorder = (this.style & 0x800) != 0;
        }
        if (hasTitle) {
            if (hasResize) {
                this.display.titleResizeTrimWidth = trimWidth;
                this.display.titleResizeTrimHeight = trimHeight;
                return;
            }
            if (hasBorder) {
                this.display.titleBorderTrimWidth = trimWidth;
                this.display.titleBorderTrimHeight = trimHeight;
                return;
            }
            this.display.titleTrimWidth = trimWidth;
            this.display.titleTrimHeight = trimHeight;
            return;
        }
        if (hasResize) {
            this.display.resizeTrimWidth = trimWidth;
            this.display.resizeTrimHeight = trimHeight;
            return;
        }
        if (hasBorder) {
            this.display.borderTrimWidth = trimWidth;
            this.display.borderTrimHeight = trimHeight;
            return;
        }
    }

    void bringToTop(boolean force) {
        if (!OS.GTK_WIDGET_VISIBLE((int)this.shellHandle)) {
            return;
        }
        if (this.hasFocus) {
            return;
        }
        Shell shell = this.display.getActiveShell();
        if (!force) {
            if (shell == null) {
                return;
            }
            int focusHandle = OS.gtk_window_get_focus((int)shell.shellHandle);
            if (focusHandle != 0 && !OS.GTK_WIDGET_HAS_FOCUS((int)focusHandle)) {
                return;
            }
        }
        if (shell != null) {
            shell.hasFocus = false;
        }
        int window = OS.GTK_WIDGET_WINDOW((int)this.shellHandle);
        if ((this.style & 0x4000) != 0 && OS.GDK_WINDOWING_X11()) {
            int xDisplay = OS.gdk_x11_drawable_get_xdisplay((int)window);
            int xWindow = OS.gdk_x11_drawable_get_xid((int)window);
            OS.gdk_error_trap_push();
            OS.XSetInputFocus((int)xDisplay, (int)xWindow, (int)2, (int)OS.gtk_get_current_event_time());
            OS.gdk_error_trap_pop();
        } else {
            OS.gdk_window_focus((int)window, (int)OS.gtk_get_current_event_time());
        }
        this.hasFocus = true;
    }

    void checkBorder() {
    }

    void checkOpen() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrim(x, y, width, height);
        int trimWidth = this.trimWidth();
        int trimHeight = this.trimHeight();
        trim.x -= trimWidth / 2;
        trim.y -= trimHeight - trimWidth / 2;
        trim.width += trimWidth;
        trim.height += trimHeight;
        if (this.menuBar != null) {
            this.forceResize();
            int menuBarHeight = OS.GTK_WIDGET_HEIGHT((int)this.menuBar.handle);
            trim.y -= menuBarHeight;
            trim.height += menuBarHeight;
        }
        return trim;
    }

    void createHandle(int index) {
        int bits;
        boolean modal;
        this.state |= 0xA;
        if (this.handle == 0) {
            int type = 0;
            if ((this.style & 0x4000) != 0) {
                type = 1;
            }
            this.shellHandle = OS.gtk_window_new((int)type);
        } else {
            this.shellHandle = OS.gtk_plug_new((int)this.handle);
        }
        if (this.shellHandle == 0) {
            SWT.error(2);
        }
        if (this.parent != null) {
            OS.gtk_window_set_transient_for((int)this.shellHandle, (int)this.parent.topHandle());
            OS.gtk_window_set_destroy_with_parent((int)this.shellHandle, (boolean)true);
            int orientations = 0x6000000;
            if ((this.style & ~orientations) != 0 && (this.style & 0x4008) == 0) {
                OS.gtk_window_set_type_hint((int)this.shellHandle, (int)1);
            }
        }
        if ((this.style & 0x10) != 0) {
            OS.gtk_widget_set_size_request((int)this.shellHandle, (int)0, (int)0);
            OS.gtk_window_set_resizable((int)this.shellHandle, (boolean)true);
        } else {
            OS.gtk_window_set_resizable((int)this.shellHandle, (boolean)false);
        }
        this.createHandle(index, true);
        OS.gtk_widget_realize((int)this.shellHandle);
        int window = OS.GTK_WIDGET_WINDOW((int)this.shellHandle);
        int decorations = 0;
        if ((this.style & 8) == 0) {
            if ((this.style & 0x80) != 0) {
                decorations |= 0x20;
            }
            if ((this.style & 0x400) != 0) {
                decorations |= 0x40;
            }
            if ((this.style & 0x10) != 0) {
                decorations |= 4;
            }
            if ((this.style & 0x800) != 0) {
                decorations |= 2;
            }
            if ((this.style & 0x40) != 0) {
                decorations |= 0x10;
            }
            if ((this.style & 0x20) != 0) {
                decorations |= 8;
            }
            if ((this.style & 0x10) != 0) {
                decorations |= 2;
            }
        }
        OS.gdk_window_set_decorations((int)window, (int)decorations);
        OS.gtk_window_set_title((int)this.shellHandle, (byte[])new byte[1]);
        if ((this.style & 0x4000) != 0) {
            OS.gdk_window_set_override_redirect((int)window, (boolean)true);
        }
        if ((this.style & 0x818) == 0) {
            OS.gtk_container_set_border_width((int)this.shellHandle, (int)1);
            GdkColor color = new GdkColor();
            OS.gtk_style_get_black((int)OS.gtk_widget_get_style((int)this.shellHandle), (GdkColor)color);
            OS.gtk_widget_modify_bg((int)this.shellHandle, (int)0, (GdkColor)color);
        }
        boolean bl = modal = (this.style & (bits = 229376)) != 0;
        if ((this.style & 0x4000) == 0) {
            modal |= this.parent != null && (this.parent.style & bits) != 0;
        }
        OS.gtk_window_set_modal((int)this.shellHandle, (boolean)modal);
    }

    boolean hasBorder() {
        return false;
    }

    void hookEvents() {
        super.hookEvents();
        int shellMapProc = this.display.shellMapProc;
        int windowProc3 = this.display.windowProc3;
        OS.g_signal_connect((int)this.shellHandle, (byte[])OS.map_event, (int)windowProc3, (int)25);
        OS.g_signal_connect((int)this.shellHandle, (byte[])OS.unmap_event, (int)windowProc3, (int)46);
        OS.g_signal_connect((int)this.shellHandle, (byte[])OS.window_state_event, (int)windowProc3, (int)50);
        OS.g_signal_connect((int)this.shellHandle, (byte[])OS.size_allocate, (int)windowProc3, (int)39);
        OS.g_signal_connect((int)this.shellHandle, (byte[])OS.configure_event, (int)windowProc3, (int)7);
        OS.g_signal_connect((int)this.shellHandle, (byte[])OS.delete_event, (int)windowProc3, (int)8);
        OS.g_signal_connect((int)this.shellHandle, (byte[])OS.focus_in_event, (int)windowProc3, (int)16);
        OS.g_signal_connect((int)this.shellHandle, (byte[])OS.focus_out_event, (int)windowProc3, (int)17);
        OS.g_signal_connect((int)this.shellHandle, (byte[])OS.map_event, (int)shellMapProc, (int)0);
        OS.g_signal_connect((int)this.shellHandle, (byte[])OS.enter_notify_event, (int)windowProc3, (int)11);
        OS.g_signal_connect((int)this.shellHandle, (byte[])OS.move_focus, (int)windowProc3, (int)28);
        if (OS.GDK_WINDOWING_X11()) {
            int window = OS.GTK_WIDGET_WINDOW((int)this.shellHandle);
            OS.gdk_window_add_filter((int)window, (int)this.display.filterProc, (int)this.shellHandle);
        }
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void register() {
        super.register();
        this.display.addWidget(this.shellHandle, this);
    }

    void releaseChild() {
    }

    int topHandle() {
        return this.shellHandle;
    }

    int filterProc(int xEvent, int gdkEvent, int data) {
        XFocusChangeEvent focusEvent = new XFocusChangeEvent();
        OS.memmove((XFocusChangeEvent)focusEvent, (int)xEvent, (int)4);
        switch (focusEvent.type) {
            case 9: {
                OS.memmove((XFocusChangeEvent)focusEvent, (int)xEvent, (int)XFocusChangeEvent.sizeof);
                if (focusEvent.detail != 5) break;
                focusEvent.detail = 3;
                OS.memmove((int)xEvent, (XFocusChangeEvent)focusEvent, (int)XFocusChangeEvent.sizeof);
                break;
            }
            case 7: {
                XCrossingEvent crossingEvent = new XCrossingEvent();
                OS.memmove((XCrossingEvent)crossingEvent, (int)xEvent, (int)XCrossingEvent.sizeof);
                if (!crossingEvent.focus) break;
                crossingEvent.focus = false;
                OS.memmove((int)xEvent, (XCrossingEvent)crossingEvent, (int)XCrossingEvent.sizeof);
            }
        }
        return 0;
    }

    void fixShell(Shell newShell, Control control) {
        if (this == newShell) {
            return;
        }
        if (control == this.lastActive) {
            this.setActiveControl(null);
        }
        if (this.tooltipsHandle != 0) {
            this.setToolTipText(control.handle, null);
        }
        newShell.setToolTipText(control.handle, control.toolTipText);
    }

    void forceResize() {
    }

    public Point getLocation() {
        this.checkWidget();
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gtk_window_get_position((int)this.shellHandle, (int[])x, (int[])y);
        return new Point(x[0], y[0]);
    }

    public Point getMinimumSize() {
        this.checkWidget();
        int width = Math.max(1, this.minWidth + this.trimWidth());
        int height = Math.max(1, this.minHeight + this.trimHeight());
        return new Point(width, height);
    }

    public Point getSize() {
        this.checkWidget();
        int width = OS.GTK_WIDGET_WIDTH((int)this.scrolledHandle);
        int height = OS.GTK_WIDGET_HEIGHT((int)this.scrolledHandle);
        if (this.menuBar != null) {
            int barHandle = this.menuBar.handle;
            height += OS.GTK_WIDGET_HEIGHT((int)barHandle);
        }
        return new Point(width + this.trimWidth(), height + this.trimHeight());
    }

    public boolean getVisible() {
        this.checkWidget();
        return OS.GTK_WIDGET_VISIBLE((int)this.shellHandle);
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    Shell _getShell() {
        return this;
    }

    public Shell[] getShells() {
        this.checkWidget();
        int count = 0;
        Shell[] shells = this.display.getShells();
        int i = 0;
        while (i < shells.length) {
            Composite shell = shells[i];
            while ((shell = shell.getParent()) != null && shell != this) {
            }
            if (shell == this) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        int i2 = 0;
        while (i2 < shells.length) {
            Composite shell = shells[i2];
            while ((shell = shell.getParent()) != null && shell != this) {
            }
            if (shell == this) {
                result[index++] = shells[i2];
            }
            ++i2;
        }
        return result;
    }

    int gtk_configure_event(int widget, int event) {
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gtk_window_get_position((int)this.shellHandle, (int[])x, (int[])y);
        if (!this.moved || this.oldX != x[0] || this.oldY != y[0]) {
            this.moved = true;
            this.oldX = x[0];
            this.oldY = y[0];
            this.sendEvent(10);
        }
        return 0;
    }

    int gtk_delete_event(int widget, int event) {
        if (this.isEnabled()) {
            this.closeWidget();
        }
        return 1;
    }

    int gtk_enter_notify_event(int widget, int event) {
        if (widget != this.shellHandle) {
            return super.gtk_enter_notify_event(widget, event);
        }
        return 0;
    }

    int gtk_focus(int widget, int directionType) {
        switch (directionType) {
            case 0: 
            case 1: {
                Control control = this.display.getFocusControl();
                if (control == null || (control.state & 2) == 0 || (control.style & 0x1000000) == 0) break;
                int traversal = directionType == 0 ? 16 : 8;
                control.traverse(traversal);
                return 1;
            }
        }
        return super.gtk_focus(widget, directionType);
    }

    int gtk_move_focus(int widget, int directionType) {
        Control control = this.display.getFocusControl();
        if (control != null) {
            int focusHandle = control.focusHandle();
            OS.gtk_widget_child_focus((int)focusHandle, (int)directionType);
        }
        OS.g_signal_stop_emission_by_name((int)this.shellHandle, (byte[])OS.move_focus);
        return 1;
    }

    int gtk_focus_in_event(int widget, int event) {
        if (widget != this.shellHandle) {
            return super.gtk_focus_in_event(widget, event);
        }
        if (this.tooltipsHandle != 0) {
            OS.gtk_tooltips_enable((int)this.tooltipsHandle);
        }
        this.hasFocus = true;
        this.sendEvent(26);
        return 0;
    }

    int gtk_focus_out_event(int widget, int event) {
        if (widget != this.shellHandle) {
            return super.gtk_focus_out_event(widget, event);
        }
        if (this.tooltipsHandle != 0) {
            OS.gtk_tooltips_disable((int)this.tooltipsHandle);
        }
        this.sendEvent(27);
        this.setActiveControl(null);
        this.hasFocus = false;
        return 0;
    }

    int gtk_map_event(int widget, int event) {
        this.minimized = false;
        this.sendEvent(20);
        return 0;
    }

    int gtk_size_allocate(int widget, int allocation) {
        int[] width = new int[1];
        int[] height = new int[1];
        OS.gtk_window_get_size((int)this.shellHandle, (int[])width, (int[])height);
        if (!this.resized || this.oldWidth != width[0] || this.oldHeight != height[0]) {
            this.oldWidth = width[0];
            this.oldHeight = height[0];
            this.resizeBounds(width[0], height[0], true);
        }
        return 0;
    }

    int gtk_unmap_event(int widget, int event) {
        this.minimized = true;
        this.sendEvent(19);
        return 0;
    }

    int gtk_window_state_event(int widget, int event) {
        GdkEventWindowState gdkEvent = new GdkEventWindowState();
        OS.memmove((GdkEventWindowState)gdkEvent, (int)event, (int)GdkEventWindowState.sizeof);
        this.minimized = (gdkEvent.new_window_state & 2) != 0;
        this.maximized = (gdkEvent.new_window_state & 4) != 0;
        return 0;
    }

    public void open() {
        this.checkWidget();
        this.setVisible(true);
        if (this.isDisposed()) {
            return;
        }
        this.bringToTop(false);
        if (!this.restoreFocus() && !this.traverseGroup(true)) {
            this.setFocus();
        }
    }

    public void removeShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(21, listener);
        this.eventTable.unhook(19, listener);
        this.eventTable.unhook(20, listener);
        this.eventTable.unhook(26, listener);
        this.eventTable.unhook(27, listener);
    }

    public void setActive() {
        this.checkWidget();
        this.bringToTop(false);
    }

    void setActiveControl(Control control) {
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] activate = control == null ? new Control[]{} : control.getPath();
        Control[] deactivate = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int index = 0;
        int length = Math.min(activate.length, deactivate.length);
        while (index < length) {
            if (activate[index] != deactivate[index]) break;
            ++index;
        }
        int i = deactivate.length - 1;
        while (i >= index) {
            if (!deactivate[i].isDisposed()) {
                deactivate[i].sendEvent(27);
            }
            --i;
        }
        i = activate.length - 1;
        while (i >= index) {
            if (!activate[i].isDisposed()) {
                activate[i].sendEvent(26);
            }
            --i;
        }
    }

    void resizeBounds(int width, int height, boolean notify) {
        if (this.redrawWindow != 0) {
            OS.gdk_window_resize((int)this.redrawWindow, (int)width, (int)height);
        }
        if (this.enableWindow != 0) {
            OS.gdk_window_resize((int)this.enableWindow, (int)width, (int)height);
        }
        int border = OS.gtk_container_get_border_width((int)this.shellHandle);
        int menuHeight = 0;
        GtkRequisition requisition = new GtkRequisition();
        if (this.menuBar != null) {
            int menuHandle = this.menuBar.handle;
            OS.gtk_widget_size_request((int)menuHandle, (GtkRequisition)requisition);
            menuHeight = OS.GTK_WIDGET_REQUISITION_HEIGHT((int)menuHandle);
            OS.gtk_widget_set_size_request((int)menuHandle, (int)(width - border * 2), (int)menuHeight);
            height = Math.max(1, height - menuHeight);
        }
        OS.gtk_fixed_move((int)this.fixedHandle, (int)this.scrolledHandle, (int)0, (int)menuHeight);
        OS.gtk_widget_set_size_request((int)this.scrolledHandle, (int)(width - border * 2), (int)(height - border * 2));
        OS.gtk_widget_size_request((int)this.fixedHandle, (GtkRequisition)requisition);
        OS.gtk_container_resize_children((int)this.fixedHandle);
        if (notify) {
            this.resized = true;
            this.sendEvent(11);
            if (this.isDisposed()) {
                return;
            }
            if (this.layout != null) {
                this.markLayout(false, false);
                this.updateLayout(false);
            }
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        if (this.getMaximized()) {
            boolean sameExtent;
            Rectangle rect = this.getBounds();
            boolean sameOrigin = !move || rect.x == x && rect.y == y;
            boolean bl = sameExtent = !resize || rect.width == width && rect.height == height;
            if (sameOrigin && sameExtent) {
                return 0;
            }
            this.setMaximized(false);
        }
        int result = 0;
        if (move) {
            int[] x_pos = new int[1];
            int[] y_pos = new int[1];
            OS.gtk_window_get_position((int)this.shellHandle, (int[])x_pos, (int[])y_pos);
            OS.gtk_window_move((int)this.shellHandle, (int)x, (int)y);
            if (x_pos[0] != x || y_pos[0] != y) {
                this.moved = true;
                this.oldX = x;
                this.oldY = y;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return 0;
                }
                result |= 0x80;
            }
        }
        if (resize) {
            boolean changed;
            width = Math.max(1, Math.max(this.minWidth, width - this.trimWidth()));
            height = Math.max(1, Math.max(this.minHeight, height - this.trimHeight()));
            OS.gtk_window_resize((int)this.shellHandle, (int)width, (int)height);
            boolean bl = changed = width != this.oldWidth || height != this.oldHeight;
            if (changed) {
                this.oldWidth = width;
                this.oldHeight = height;
                result |= 0x100;
            }
            this.resizeBounds(width, height, changed);
        }
        return result;
    }

    void setCursor(int cursor) {
        if (this.enableWindow != 0) {
            OS.gdk_window_set_cursor((int)this.enableWindow, (int)cursor);
            OS.gdk_flush();
        }
        super.setCursor(cursor);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 0x10) == 0 == enabled) {
            return;
        }
        Control control = null;
        boolean fixFocus = false;
        if (!enabled && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        this.state = enabled ? (this.state &= 0xFFFFFFEF) : (this.state |= 0x10);
        this.enableWidget(enabled);
        if (enabled) {
            if (this.enableWindow != 0) {
                OS.gdk_window_set_user_data((int)this.enableWindow, (int)0);
                OS.gdk_window_destroy((int)this.enableWindow);
                this.enableWindow = 0;
            }
        } else {
            int parentHandle = this.shellHandle;
            OS.gtk_widget_realize((int)parentHandle);
            int window = OS.GTK_WIDGET_WINDOW((int)parentHandle);
            Rectangle rect = this.getBounds();
            GdkWindowAttr attributes = new GdkWindowAttr();
            attributes.width = rect.width;
            attributes.height = rect.height;
            attributes.event_mask = -32769;
            attributes.wclass = 1;
            attributes.window_type = 2;
            this.enableWindow = OS.gdk_window_new((int)window, (GdkWindowAttr)attributes, (int)0);
            if (this.enableWindow != 0) {
                if (this.cursor != null) {
                    OS.gdk_window_set_cursor((int)this.enableWindow, (int)this.cursor.handle);
                    OS.gdk_flush();
                }
                OS.gdk_window_set_user_data((int)this.enableWindow, (int)parentHandle);
                OS.gdk_window_show((int)this.enableWindow);
            }
        }
        if (fixFocus) {
            this.fixFocus(control);
        }
        if (enabled && this.hasFocus && !this.restoreFocus()) {
            this.traverseGroup(false);
        }
    }

    public void setImeInputMode(int mode) {
        this.checkWidget();
    }

    void setInitialBounds() {
        Monitor monitor = this.getMonitor();
        Rectangle rect = monitor.getClientArea();
        int width = rect.width * 5 / 8;
        int height = rect.height * 5 / 8;
        OS.gtk_widget_set_size_request((int)this.scrolledHandle, (int)width, (int)height);
        OS.gtk_window_resize((int)this.shellHandle, (int)width, (int)height);
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request((int)this.fixedHandle, (GtkRequisition)requisition);
        OS.gtk_container_resize_children((int)this.fixedHandle);
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        super.setMaximized(maximized);
        if (maximized) {
            OS.gtk_window_maximize((int)this.shellHandle);
        } else {
            OS.gtk_window_unmaximize((int)this.shellHandle);
        }
    }

    public void setMenuBar(Menu menu) {
        int menuHandle;
        boolean both;
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        boolean bl = both = menu != null && this.menuBar != null;
        if (menu != null) {
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        if (this.menuBar != null) {
            menuHandle = this.menuBar.handle;
            OS.gtk_widget_hide((int)menuHandle);
            this.destroyAccelGroup();
        }
        this.menuBar = menu;
        if (this.menuBar != null) {
            menuHandle = menu.handle;
            OS.gtk_widget_show((int)menuHandle);
            this.createAccelGroup();
            this.menuBar.addAccelerators(this.accelGroup);
        }
        int[] width = new int[1];
        int[] height = new int[1];
        OS.gtk_window_get_size((int)this.shellHandle, (int[])width, (int[])height);
        this.resizeBounds(width[0], height[0], !both);
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        if (this.minimized == minimized) {
            return;
        }
        super.setMinimized(minimized);
        if (minimized) {
            OS.gtk_window_iconify((int)this.shellHandle);
        } else {
            OS.gtk_window_deiconify((int)this.shellHandle);
            this.bringToTop(false);
        }
    }

    public void setMinimumSize(int width, int height) {
        this.checkWidget();
        GdkGeometry geometry = new GdkGeometry();
        this.minWidth = geometry.min_width = Math.max(width, this.trimWidth()) - this.trimWidth();
        this.minHeight = geometry.min_height = Math.max(height, this.trimHeight()) - this.trimHeight();
        OS.gtk_window_set_geometry_hints((int)this.shellHandle, (int)0, (GdkGeometry)geometry, (int)2);
    }

    public void setMinimumSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setMinimumSize(size.x, size.y);
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        int window = OS.GTK_WIDGET_WINDOW((int)this.shellHandle);
        int shape_region = region == null ? 0 : region.handle;
        OS.gdk_window_shape_combine_region((int)window, (int)shape_region, (int)0, (int)0);
        this.region = region;
    }

    public void setText(String string) {
        super.setText(string);
        int length = string.length();
        char[] chars = new char[Math.max(6, length) + 1];
        string.getChars(0, length, chars, 0);
        int i = length;
        while (i < chars.length) {
            chars[i] = 32;
            ++i;
        }
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        OS.gtk_window_set_title((int)this.shellHandle, (byte[])buffer);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (OS.GTK_WIDGET_MAPPED((int)this.shellHandle) == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            this.mapped = false;
            OS.gtk_widget_show((int)this.shellHandle);
            if (this.isDisposed()) {
                return;
            }
            this.display.dispatchEvents = new int[]{2, 12, 13, 14, 15, 30};
            Display display = this.display;
            display.putGdkEvents();
            boolean iconic = false;
            Shell shell = this.parent != null ? this.parent.getShell() : null;
            do {
                OS.g_main_context_iteration((int)0, (boolean)false);
                if (this.isDisposed()) break;
                boolean bl = iconic = this.minimized || shell != null && shell.minimized;
            } while (!this.mapped && !iconic);
            display.dispatchEvents = null;
            if (this.isDisposed()) {
                return;
            }
            if (!iconic) {
                this.update(true);
                if (this.isDisposed()) {
                    return;
                }
                this.adjustTrim();
            }
            this.mapped = true;
            int mask = 229376;
            if ((this.style & mask) != 0) {
                OS.gdk_pointer_ungrab((int)0);
            }
            this.opened = true;
            if (!this.moved) {
                this.moved = true;
                Point location = this.getLocation();
                this.oldX = location.x;
                this.oldY = location.y;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (!this.resized) {
                this.resized = true;
                Point size = this.getSize();
                this.oldWidth = size.x - this.trimWidth();
                this.oldHeight = size.y - this.trimHeight();
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false);
                }
            }
        } else {
            OS.gtk_widget_hide((int)this.shellHandle);
            this.sendEvent(23);
        }
    }

    void setZOrder(Control sibling, boolean above) {
        this.setZOrder(sibling, above, false);
    }

    int shellMapProc(int handle, int arg0, int user_data) {
        this.mapped = true;
        this.display.dispatchEvents = null;
        return 0;
    }

    void showWidget() {
        OS.gtk_container_add((int)this.shellHandle, (int)this.fixedHandle);
        if (this.scrolledHandle != 0) {
            OS.gtk_widget_show((int)this.scrolledHandle);
        }
        if (this.handle != 0) {
            OS.gtk_widget_show((int)this.handle);
        }
        if (this.fixedHandle != 0) {
            OS.gtk_widget_show((int)this.fixedHandle);
        }
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    int trimHeight() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        hasTitle = (this.style & 0x4E0) != 0;
        hasResize = (this.style & 0x10) != 0;
        boolean bl = hasBorder = (this.style & 0x800) != 0;
        if (hasTitle) {
            if (hasResize) {
                return this.display.titleResizeTrimHeight;
            }
            if (hasBorder) {
                return this.display.titleBorderTrimHeight;
            }
            return this.display.titleTrimHeight;
        }
        if (hasResize) {
            return this.display.resizeTrimHeight;
        }
        if (hasBorder) {
            return this.display.borderTrimHeight;
        }
        return 0;
    }

    int trimWidth() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        hasTitle = (this.style & 0x4E0) != 0;
        hasResize = (this.style & 0x10) != 0;
        boolean bl = hasBorder = (this.style & 0x800) != 0;
        if (hasTitle) {
            if (hasResize) {
                return this.display.titleResizeTrimWidth;
            }
            if (hasBorder) {
                return this.display.titleBorderTrimWidth;
            }
            return this.display.titleTrimWidth;
        }
        if (hasResize) {
            return this.display.resizeTrimWidth;
        }
        if (hasBorder) {
            return this.display.borderTrimWidth;
        }
        return 0;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.shellHandle);
    }

    public void dispose() {
        Shell activeShell;
        if (this.isDisposed()) {
            return;
        }
        OS.gtk_widget_hide((int)this.shellHandle);
        if (this.parent != null && (activeShell = this.display.getActiveShell()) == this) {
            Shell shell = this.parent.getShell();
            shell.bringToTop(false);
        }
        super.dispose();
    }

    public void forceActive() {
        this.checkWidget();
        this.bringToTop(true);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gtk_window_get_position((int)this.shellHandle, (int[])x, (int[])y);
        int width = OS.GTK_WIDGET_WIDTH((int)this.scrolledHandle);
        int height = OS.GTK_WIDGET_HEIGHT((int)this.scrolledHandle);
        if (this.menuBar != null) {
            int barHandle = this.menuBar.handle;
            height += OS.GTK_WIDGET_HEIGHT((int)barHandle);
        }
        return new Rectangle(x[0], y[0], width + this.trimWidth(), height + this.trimHeight());
    }

    void releaseHandle() {
        super.releaseHandle();
        this.shellHandle = 0;
    }

    void releaseShells() {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.releaseResources();
            }
            ++i;
        }
    }

    void releaseWidget() {
        this.releaseShells();
        this.destroyAccelGroup();
        super.releaseWidget();
        if (this.tooltipsHandle != 0) {
            OS.g_object_unref((int)this.tooltipsHandle);
        }
        this.tooltipsHandle = 0;
        this.region = null;
        this.lastActive = null;
    }

    void setToolTipText(int widget, String string) {
        byte[] buffer = null;
        if (string != null && string.length() > 0) {
            buffer = Converter.wcsToMbcs(null, string, true);
        }
        if (this.tooltipsHandle == 0) {
            this.tooltipsHandle = OS.gtk_tooltips_new();
            if (this.tooltipsHandle == 0) {
                this.error(2);
            }
            OS.g_object_ref((int)this.tooltipsHandle);
            OS.gtk_object_sink((int)this.tooltipsHandle);
        }
        OS.gtk_tooltips_set_tip((int)this.tooltipsHandle, (int)widget, (byte[])buffer, null);
    }
}

