/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XClientMessageEvent;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    Tray parent;
    String toolTipText;
    int imageHandle;
    int tooltipsHandle;
    ImageList imageList;

    public TrayItem(Tray parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(parent.getItemCount());
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.parent.createItem(this, index);
    }

    void createHandle(int index) {
        this.state |= 8;
        this.handle = OS.gtk_plug_new((int)0);
        if (this.handle == 0) {
            this.error(2);
        }
        this.imageHandle = OS.gtk_image_new();
        if (this.imageHandle == 0) {
            this.error(2);
        }
        OS.gtk_container_add((int)this.handle, (int)this.imageHandle);
        OS.gtk_widget_show((int)this.handle);
        OS.gtk_widget_show((int)this.imageHandle);
        int id = OS.gtk_plug_get_id((int)this.handle);
        int monitor = 0;
        int screen = OS.gdk_screen_get_default();
        if (screen != 0) {
            monitor = OS.gdk_screen_get_number((int)screen);
        }
        byte[] trayBuffer = Converter.wcsToMbcs(null, "_NET_SYSTEM_TRAY_S" + monitor, true);
        int trayAtom = OS.gdk_atom_intern((byte[])trayBuffer, (boolean)true);
        int xTrayAtom = OS.gdk_x11_atom_to_xatom((int)trayAtom);
        int xDisplay = OS.GDK_DISPLAY();
        int trayWindow = OS.XGetSelectionOwner((int)xDisplay, (int)xTrayAtom);
        byte[] messageBuffer = Converter.wcsToMbcs(null, "_NET_SYSTEM_TRAY_OPCODE", true);
        int messageAtom = OS.gdk_atom_intern((byte[])messageBuffer, (boolean)true);
        int xMessageAtom = OS.gdk_x11_atom_to_xatom((int)messageAtom);
        XClientMessageEvent event = new XClientMessageEvent();
        event.type = 33;
        event.window = trayWindow;
        event.message_type = xMessageAtom;
        event.format = 32;
        event.data[0] = 0;
        event.data[1] = 0;
        event.data[2] = id;
        int clientEvent = OS.g_malloc((int)XClientMessageEvent.sizeof);
        OS.memmove((int)clientEvent, (XClientMessageEvent)event, (int)XClientMessageEvent.sizeof);
        OS.XSendEvent((int)OS.GDK_DISPLAY(), (int)trayWindow, (boolean)false, (int)0, (int)clientEvent);
        OS.g_free((int)clientEvent);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    int gtk_button_press_event(int widget, int eventPtr) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove((GdkEventButton)gdkEvent, (int)eventPtr, (int)GdkEventButton.sizeof);
        if (gdkEvent.type == 6) {
            return 0;
        }
        if (gdkEvent.button == 3 && gdkEvent.type == 4) {
            this.sendEvent(35);
            return 0;
        }
        if (gdkEvent.type == 5) {
            this.postEvent(14);
        } else {
            this.postEvent(13);
        }
        return 0;
    }

    void hookEvents() {
        int eventMask = 256;
        OS.gtk_widget_add_events((int)this.handle, (int)eventMask);
        OS.g_signal_connect((int)this.handle, (byte[])OS.button_press_event, (int)this.display.windowProc3, (int)2);
    }

    public boolean getVisible() {
        this.checkWidget();
        return OS.GTK_WIDGET_VISIBLE((int)this.handle);
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.tooltipsHandle != 0) {
            OS.g_object_unref((int)this.tooltipsHandle);
        }
        this.tooltipsHandle = 0;
        this.imageHandle = 0;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        this.toolTipText = null;
        if (this.handle != 0) {
            OS.gtk_widget_destroy((int)this.handle);
        }
        this.handle = 0;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (image != null) {
            int imageIndex;
            Rectangle rect = image.getBounds();
            OS.gtk_widget_set_size_request((int)this.handle, (int)rect.width, (int)rect.height);
            if (this.imageList == null) {
                this.imageList = new ImageList();
            }
            if ((imageIndex = this.imageList.indexOf(image)) == -1) {
                imageIndex = this.imageList.add(image);
            }
            int pixbuf = this.imageList.getPixbuf(imageIndex);
            OS.gtk_image_set_from_pixbuf((int)this.imageHandle, (int)pixbuf);
            OS.gtk_widget_show((int)this.imageHandle);
        } else {
            OS.gtk_widget_set_size_request((int)this.handle, (int)1, (int)1);
            OS.gtk_image_set_from_pixbuf((int)this.imageHandle, (int)0);
            OS.gtk_widget_hide((int)this.imageHandle);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        byte[] buffer = null;
        if (string != null && string.length() > 0) {
            buffer = Converter.wcsToMbcs(null, string, true);
        }
        if (this.tooltipsHandle == 0) {
            this.tooltipsHandle = OS.gtk_tooltips_new();
            if (this.tooltipsHandle == 0) {
                this.error(2);
            }
            OS.g_object_ref((int)this.tooltipsHandle);
            OS.gtk_object_sink((int)this.tooltipsHandle);
        }
        OS.gtk_tooltips_set_tip((int)this.tooltipsHandle, (int)this.handle, (byte[])buffer, null);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (OS.GTK_WIDGET_VISIBLE((int)this.handle) == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            OS.gtk_widget_show((int)this.handle);
        } else {
            OS.gtk_widget_hide((int)this.handle);
            this.sendEvent(23);
        }
    }
}

