/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.bindings;

import org.eclipse.jface.bindings.BindingManager;

public final class BindingManagerEvent {
    private final boolean activeBindingsChanged;
    private final boolean activeSchemeChanged;
    private final boolean localeChanged;
    private final boolean platformChanged;
    private final BindingManager manager;
    private final String schemeId;
    private final boolean schemeIdDefined;
    private final boolean schemeIdUndefined;

    public BindingManagerEvent(BindingManager manager, boolean activeBindingsChanged, boolean activeSchemeChanged, String schemeId, boolean schemeIdDefined, boolean schemeIdUndefined, boolean localeChanged, boolean platformChanged) {
        if (manager == null) {
            throw new NullPointerException("A binding manager event needs a binding manager");
        }
        if (schemeIdDefined || schemeIdUndefined) {
            if (schemeId == null) {
                throw new NullPointerException("If a scheme changed defined state, then there should be a scheme identifier");
            }
        } else if (schemeId != null) {
            throw new IllegalArgumentException("The scheme has not changed defined state");
        }
        this.manager = manager;
        this.activeBindingsChanged = activeBindingsChanged;
        this.activeSchemeChanged = activeSchemeChanged;
        this.schemeId = schemeId;
        this.schemeIdDefined = schemeIdDefined;
        this.schemeIdUndefined = schemeIdUndefined;
        this.localeChanged = localeChanged;
        this.platformChanged = platformChanged;
    }

    public final BindingManager getManager() {
        return this.manager;
    }

    public final String getSchemeId() {
        return this.schemeId;
    }

    public final boolean hasActiveSchemeChanged() {
        return this.activeSchemeChanged;
    }

    public boolean hasLocaleChanged() {
        return this.localeChanged;
    }

    public boolean hasPlatformChanged() {
        return this.platformChanged;
    }

    public final boolean haveActiveBindingsChanged() {
        return this.activeBindingsChanged;
    }

    public final boolean isSchemeIdDefined() {
        return this.schemeIdDefined;
    }

    public final boolean isSchemeIdUndefined() {
        return this.schemeIdUndefined;
    }
}

