/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.bindings.keys;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.keys.CharacterKey;
import org.eclipse.jface.bindings.keys.ModifierKey;
import org.eclipse.jface.bindings.keys.NaturalKey;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.bindings.keys.SpecialKey;
import org.eclipse.jface.bindings.keys.formatting.KeyFormatterFactory;
import org.eclipse.jface.util.Util;

public final class KeyStroke
extends Trigger
implements Comparable {
    public static final String KEY_DELIMITER = Character.toString('+');
    private static final int HASH_INITIAL;
    public static final String KEY_DELIMITERS;
    private final SortedSet modifierKeys;
    private final transient ModifierKey[] modifierKeysAsArray;
    private final NaturalKey naturalKey;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.bindings.keys.KeyStroke");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
        KEY_DELIMITERS = KEY_DELIMITER;
    }

    public static final KeyStroke getInstance(ModifierKey modifierKey, NaturalKey naturalKey) {
        if (modifierKey == null) {
            throw new NullPointerException();
        }
        return new KeyStroke(new TreeSet<ModifierKey>(Collections.singletonList(modifierKey)), naturalKey);
    }

    public static final KeyStroke getInstance(ModifierKey[] modifierKeys, NaturalKey naturalKey) {
        return new KeyStroke(new TreeSet<ModifierKey>(Arrays.asList(modifierKeys)), naturalKey);
    }

    public static final KeyStroke getInstance(NaturalKey naturalKey) {
        return new KeyStroke(Util.EMPTY_SORTED_SET, naturalKey);
    }

    public static final KeyStroke getInstance(SortedSet modifierKeys, NaturalKey naturalKey) {
        return new KeyStroke(modifierKeys, naturalKey);
    }

    public static final KeyStroke getInstance(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException();
        }
        TreeSet<ModifierKey> modifierKeys = new TreeSet<ModifierKey>();
        NaturalKey naturalKey = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, KEY_DELIMITERS, true);
        int i = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if (i % 2 == 0) {
                if (stringTokenizer.hasMoreTokens()) {
                    ModifierKey modifierKey = (ModifierKey)ModifierKey.modifierKeysByName.get(token = token.toUpperCase());
                    if (modifierKey == null || !modifierKeys.add(modifierKey)) {
                        throw new ParseException("Cannot create key stroke with duplicate or non-existent modifier key: " + token);
                    }
                } else {
                    if (token.length() == 1) {
                        naturalKey = CharacterKey.getInstance(token.charAt(0));
                        break;
                    }
                    naturalKey = (NaturalKey)CharacterKey.characterKeysByName.get(token = token.toUpperCase());
                    if (naturalKey == null) {
                        naturalKey = (NaturalKey)SpecialKey.specialKeysByName.get(token);
                    }
                    if (naturalKey == null) {
                        throw new ParseException("Cannot create key stroke with invalid natural key: " + token);
                    }
                }
            }
            ++i;
        }
        try {
            return new KeyStroke(modifierKeys, naturalKey);
        }
        catch (Throwable throwable) {
            throw new ParseException("Cannot create key stroke with " + modifierKeys + " and " + naturalKey);
        }
    }

    protected KeyStroke(SortedSet modifierKeys, NaturalKey naturalKey) {
        this.modifierKeys = new TreeSet(modifierKeys);
        this.naturalKey = naturalKey;
        this.modifierKeysAsArray = this.modifierKeys.toArray(new ModifierKey[this.modifierKeys.size()]);
    }

    public final int compareTo(Object object) {
        KeyStroke castedObject = (KeyStroke)object;
        int compareTo = Util.compare(this.modifierKeysAsArray, castedObject.modifierKeysAsArray);
        if (compareTo == 0) {
            compareTo = Util.compare(this.naturalKey, castedObject.naturalKey);
        }
        return compareTo;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof KeyStroke)) {
            return false;
        }
        KeyStroke castedObject = (KeyStroke)object;
        boolean equals = true;
        equals &= this.modifierKeys.equals(castedObject.modifierKeys);
        return equals &= Util.equals(this.naturalKey, castedObject.naturalKey);
    }

    public final String format() {
        return KeyFormatterFactory.getDefault().format(this);
    }

    public final Set getModifierKeys() {
        return Collections.unmodifiableSet(this.modifierKeys);
    }

    public final NaturalKey getNaturalKey() {
        return this.naturalKey;
    }

    public final int hashCode() {
        if (!this.hashCodeComputed) {
            this.hashCode = HASH_INITIAL;
            this.hashCode = this.hashCode * 89 + this.modifierKeys.hashCode();
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.naturalKey);
            this.hashCodeComputed = true;
        }
        return this.hashCode;
    }

    public final boolean isComplete() {
        return this.naturalKey != null;
    }

    public final String toString() {
        return KeyFormatterFactory.getFormalKeyFormatter().format(this);
    }
}

