/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.motif.OS;

public abstract class ByteArrayTransfer
extends Transfer {
    public TransferData[] getSupportedTypes() {
        int[] types = this.getTypeIds();
        TransferData[] data = new TransferData[types.length];
        int i = 0;
        while (i < types.length) {
            data[i] = new TransferData();
            data[i].type = types[i];
            ++i;
        }
        return data;
    }

    public boolean isSupportedType(TransferData transferData) {
        if (transferData == null) {
            return false;
        }
        int[] types = this.getTypeIds();
        int i = 0;
        while (i < types.length) {
            if (transferData.type == types[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof byte[]) || !this.isSupportedType(transferData)) {
            transferData.result = 0;
            return;
        }
        byte[] buffer = (byte[])object;
        transferData.pValue = OS.XtMalloc(buffer.length);
        OS.memmove(transferData.pValue, buffer, buffer.length);
        transferData.length = buffer.length;
        transferData.format = 8;
        transferData.result = 1;
    }

    protected Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) && transferData.pValue != 0) {
            return null;
        }
        int size = transferData.format * transferData.length / 8;
        byte[] buffer = new byte[size];
        OS.memmove(buffer, transferData.pValue, size);
        return buffer;
    }
}

