/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XmDropFinishCallback;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    private Control control;
    private Listener controlListener;
    private Transfer[] transferAgents = new Transfer[0];
    private static final String DRAGSOURCEID = "DragSource";
    private static Callback ConvertProc = new Callback(class$org$eclipse$swt$dnd$DragSource == null ? (class$org$eclipse$swt$dnd$DragSource = DragSource.class$("org.eclipse.swt.dnd.DragSource")) : class$org$eclipse$swt$dnd$DragSource, "ConvertProcCallback", 10);
    private static Callback DragDropFinish = new Callback(class$org$eclipse$swt$dnd$DragSource == null ? (class$org$eclipse$swt$dnd$DragSource = DragSource.class$("org.eclipse.swt.dnd.DragSource")) : class$org$eclipse$swt$dnd$DragSource, "DragDropFinishCallback", 3);
    private static Callback DropFinish = new Callback(class$org$eclipse$swt$dnd$DragSource == null ? (class$org$eclipse$swt$dnd$DragSource = DragSource.class$("org.eclipse.swt.dnd.DragSource")) : class$org$eclipse$swt$dnd$DragSource, "DropFinishCallback", 3);
    private boolean moveRequested;
    int dragContext;
    static /* synthetic */ Class class$org$eclipse$swt$dnd$DragSource;

    public DragSource(Control control, int style) {
        super(control, DragSource.checkStyle(style));
        if (ConvertProc == null || DragDropFinish == null || DropFinish == null) {
            DND.error(2000);
        }
        this.control = control;
        if (control.getData(DRAGSOURCEID) != null) {
            DND.error(2000);
        }
        control.setData(DRAGSOURCEID, this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 12 && !DragSource.this.isDisposed()) {
                    DragSource.this.dispose();
                }
                if (event.type == 29 && !DragSource.this.isDisposed()) {
                    DragSource.this.drag();
                }
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                DragSource.this.onDispose();
            }
        });
    }

    static DragSource FindDragSource(int handle) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        return (DragSource)display.getData(Integer.toString(handle));
    }

    private static int ConvertProcCallback(int widget, int pSelection, int pTarget, int pType_return, int ppValue_return, int pLength_return, int pFormat_return, int max_length, int client_data, int request_id) {
        DragSource source = DragSource.FindDragSource(widget);
        if (source == null) {
            return 0;
        }
        return source.convertProcCallback(widget, pSelection, pTarget, pType_return, ppValue_return, pLength_return, pFormat_return, max_length, client_data, request_id);
    }

    private static int DragDropFinishCallback(int widget, int client_data, int call_data) {
        DragSource source = DragSource.FindDragSource(widget);
        if (source == null) {
            return 0;
        }
        return source.dragDropFinishCallback(widget, client_data, call_data);
    }

    private static int DropFinishCallback(int widget, int client_data, int call_data) {
        DragSource source = DragSource.FindDragSource(widget);
        if (source == null) {
            return 0;
        }
        return source.dropFinishCallback(widget, client_data, call_data);
    }

    public void addDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        this.addListener(2008, typedListener);
        this.addListener(2001, typedListener);
        this.addListener(2000, typedListener);
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = (class$org$eclipse$swt$dnd$DragSource == null ? (class$org$eclipse$swt$dnd$DragSource = DragSource.class$("org.eclipse.swt.dnd.DragSource")) : class$org$eclipse$swt$dnd$DragSource).getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    private int convertProcCallback(int widget, int pSelection, int pTarget, int pType_return, int ppValue_return, int pLength_return, int pFormat_return, int max_length, int client_data, int request_id) {
        if (pSelection == 0) {
            return 0;
        }
        int[] selection = new int[1];
        OS.memmove(selection, pSelection, 4);
        int xDisplay = this.getDisplay().xDisplay;
        byte[] bName = Converter.wcsToMbcs(null, "_MOTIF_DROP", true);
        int motifDropAtom = OS.XmInternAtom(xDisplay, bName, true);
        if (selection[0] != motifDropAtom) {
            return 0;
        }
        int[] target = new int[1];
        OS.memmove(target, pTarget, 4);
        bName = Converter.wcsToMbcs(null, "DELETE", true);
        int deleteAtom = OS.XmInternAtom(xDisplay, bName, true);
        if (target[0] == deleteAtom) {
            this.moveRequested = true;
            bName = Converter.wcsToMbcs(null, "NULL", true);
            int nullAtom = OS.XmInternAtom(xDisplay, bName, true);
            OS.memmove(pType_return, new int[]{nullAtom}, 4);
            OS.memmove(ppValue_return, new int[]{0}, 4);
            OS.memmove(pLength_return, new int[]{0}, 4);
            OS.memmove(pFormat_return, new int[]{8}, 4);
            return 1;
        }
        boolean dataMatch = false;
        TransferData transferData = new TransferData();
        transferData.type = target[0];
        int i = 0;
        while (i < this.transferAgents.length) {
            if (this.transferAgents[i].isSupportedType(transferData)) {
                dataMatch = true;
                break;
            }
            ++i;
        }
        if (!dataMatch) {
            return 0;
        }
        DNDEvent event = new DNDEvent();
        event.widget = this.control;
        event.dataType = transferData;
        try {
            this.notifyListeners(2001, event);
        }
        catch (Throwable err) {
            return 0;
        }
        if (event.data == null) {
            return 0;
        }
        Transfer transferAgent = null;
        int i2 = 0;
        while (i2 < this.transferAgents.length) {
            if (this.transferAgents[i2].isSupportedType(transferData)) {
                transferAgent = this.transferAgents[i2];
                break;
            }
            ++i2;
        }
        if (transferAgent == null) {
            return 0;
        }
        transferAgent.javaToNative(event.data, transferData);
        if (transferData.result == 1) {
            OS.memmove(ppValue_return, new int[]{transferData.pValue}, 4);
            OS.memmove(pType_return, new int[]{transferData.type}, 4);
            OS.memmove(pLength_return, new int[]{transferData.length}, 4);
            OS.memmove(pFormat_return, new int[]{transferData.format}, 4);
            return 1;
        }
        OS.memmove(ppValue_return, new int[]{0}, 4);
        OS.memmove(pLength_return, new int[]{0}, 4);
        OS.memmove(pFormat_return, new int[]{8}, 4);
        return 0;
    }

    private void drag() {
        Display display = this.control.getDisplay();
        if (display.xEvent.type != 4) {
            return;
        }
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = display.xEvent.pad2;
        event.doit = true;
        try {
            this.notifyListeners(2008, event);
        }
        catch (Throwable e) {
            event.doit = false;
        }
        if (!event.doit || this.transferAgents == null || this.transferAgents.length == 0) {
            int time = display.xEvent.pad2;
            int dc = OS.XmGetDragContext(this.control.handle, time);
            if (dc != 0) {
                OS.XmDragCancel(dc);
            }
            return;
        }
        TransferData[] transferData = new TransferData[]{};
        int i = 0;
        while (i < this.transferAgents.length) {
            TransferData[] data = this.transferAgents[i].getSupportedTypes();
            TransferData[] newTransferData = new TransferData[transferData.length + data.length];
            System.arraycopy(transferData, 0, newTransferData, 0, transferData.length);
            System.arraycopy(data, 0, newTransferData, transferData.length, data.length);
            transferData = newTransferData;
            ++i;
        }
        int[] dataTypes = new int[transferData.length];
        int i2 = 0;
        while (i2 < transferData.length) {
            dataTypes[i2] = transferData[i2].type;
            ++i2;
        }
        int pExportTargets = OS.XtMalloc(dataTypes.length * 4);
        OS.memmove(pExportTargets, dataTypes, dataTypes.length * 4);
        int[] args = new int[]{OS.XmNexportTargets, pExportTargets, OS.XmNnumExportTargets, dataTypes.length, OS.XmNdragOperations, this.opToOsOp(this.getStyle()), OS.XmNconvertProc, ConvertProc.getAddress(), OS.XmNoperationCursorIcon, 0, OS.XmNsourceCursorIcon, 0, OS.XmNstateCursorIcon, 0, OS.XmNclientData, 0, OS.XmNblendModel, 0};
        int time = display.xEvent.pad2;
        this.dragContext = OS.XmGetDragContext(this.control.handle, time);
        if (this.dragContext != 0) {
            OS.XtSetValues(this.dragContext, args, args.length / 2);
        } else {
            this.dragContext = OS.XmDragStart(this.control.handle, display.xEvent, args, args.length / 2);
        }
        OS.XtFree(pExportTargets);
        if (this.dragContext == 0) {
            return;
        }
        OS.XtAddCallback(this.dragContext, OS.XmNdragDropFinishCallback, DragDropFinish.getAddress(), 0);
        OS.XtAddCallback(this.dragContext, OS.XmNdropFinishCallback, DropFinish.getAddress(), 0);
        display.setData(Integer.toString(this.dragContext), this);
    }

    private int dragDropFinishCallback(int widget, int client_data, int call_data) {
        this.dragContext = 0;
        this.getDisplay().setData(Integer.toString(this.dragContext), null);
        return 0;
    }

    private int dropFinishCallback(int widget, int client_data, int call_data) {
        XmDropFinishCallback data = new XmDropFinishCallback();
        OS.memmove(data, call_data, 17);
        if (data.dropAction != 0 || data.dropSiteStatus != 3) {
            DNDEvent event = new DNDEvent();
            event.widget = this.control;
            event.time = data.timeStamp;
            event.detail = 0;
            event.doit = false;
            try {
                this.notifyListeners(2000, event);
            }
            catch (Throwable err) {
                // empty catch block
            }
            return 0;
        }
        DNDEvent event = new DNDEvent();
        event.widget = this.control;
        event.time = data.timeStamp;
        event.detail = this.moveRequested ? 2 : (data.operation == 1 ? 0 : this.osOpToOp(data.operation));
        event.doit = data.completionStatus != 0;
        try {
            this.notifyListeners(2000, event);
        }
        catch (Throwable err) {
            // empty catch block
        }
        this.moveRequested = false;
        return 0;
    }

    public Control getControl() {
        return this.control;
    }

    public Display getDisplay() {
        if (this.control == null) {
            DND.error(24);
        }
        return this.control.getDisplay();
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    private void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData(DRAGSOURCEID, null);
        this.control = null;
        this.transferAgents = null;
    }

    private byte opToOsOp(int operation) {
        byte osOperation = 0;
        if ((operation & 1) == 1) {
            osOperation = (byte)(osOperation | 2);
        }
        if ((operation & 2) == 2) {
            osOperation = (byte)(osOperation | 1);
        }
        if ((operation & 4) == 4) {
            osOperation = (byte)(osOperation | 4);
        }
        return osOperation;
    }

    private int osOpToOp(byte osOperation) {
        int operation = 0;
        if ((osOperation & 2) == 2) {
            operation |= 1;
        }
        if ((osOperation & 1) == 1) {
            operation |= 2;
        }
        if ((osOperation & 4) == 4) {
            operation |= 4;
        }
        return operation;
    }

    public void removeDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2008, listener);
        this.removeListener(2001, listener);
        this.removeListener(2000, listener);
    }

    public void setTransfer(Transfer[] transferAgents) {
        this.transferAgents = transferAgents;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

