/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragUnderEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.NoDragUnderEffect;
import org.eclipse.swt.dnd.TableDragUnderEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragUnderEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XmDragProcCallback;
import org.eclipse.swt.internal.motif.XmDropProcCallback;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    private Control control;
    private Listener controlListener;
    private Transfer[] transferAgents = new Transfer[0];
    private DragUnderEffect effect;
    private static final String DROPTARGETID = "DropTarget";
    private static Callback DropProc = new Callback(class$org$eclipse$swt$dnd$DropTarget == null ? (class$org$eclipse$swt$dnd$DropTarget = DropTarget.class$("org.eclipse.swt.dnd.DropTarget")) : class$org$eclipse$swt$dnd$DropTarget, "DropProcCallback", 3);
    private static Callback DragProc = new Callback(class$org$eclipse$swt$dnd$DropTarget == null ? (class$org$eclipse$swt$dnd$DropTarget = DropTarget.class$("org.eclipse.swt.dnd.DropTarget")) : class$org$eclipse$swt$dnd$DropTarget, "DragProcCallback", 3);
    private static Callback TransferProc = new Callback(class$org$eclipse$swt$dnd$DropTarget == null ? (class$org$eclipse$swt$dnd$DropTarget = DropTarget.class$("org.eclipse.swt.dnd.DropTarget")) : class$org$eclipse$swt$dnd$DropTarget, "TransferProcCallback", 7);
    static int DELETE_TYPE = Transfer.registerType("DELETE\u0000");
    private TransferData selectedDataType;
    private TransferData[] dataTypes;
    private int dropTransferObject;
    private XmDropProcCallback droppedEventData;
    private static final int DRAGOVER_HYSTERESIS = 50;
    private long dragOverStart;
    private Runnable dragOverHeartbeat;
    private DNDEvent dragOverEvent;
    private int lastOperation;
    private int selectionTimeout;
    private boolean registered = false;
    static /* synthetic */ Class class$org$eclipse$swt$dnd$DropTarget;

    public DropTarget(Control control, int style) {
        super(control, DropTarget.checkStyle(style));
        if (DropProc == null || DragProc == null || TransferProc == null) {
            DND.error(2001);
        }
        this.control = control;
        if (control.getData(DROPTARGETID) != null) {
            DND.error(2001);
        }
        control.setData(DROPTARGETID, this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        if (DropTarget.this.isDisposed()) break;
                        DropTarget.this.onDispose();
                        break;
                    }
                    case 22: {
                        Display display = event.display;
                        display.asyncExec(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                if (DropTarget.access$200(1.access$100(this.this$1)) == null || DropTarget.access$200(1.access$100(this.this$1)).isDisposed() || !DropTarget.access$200(1.access$100(this.this$1)).isVisible()) {
                                    return;
                                }
                                DropTarget.access$300(1.access$100(this.this$1));
                            }
                        });
                        break;
                    }
                    case 23: {
                        Display display = event.display;
                        display.asyncExec(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                if (DropTarget.access$200(1.access$100(this.this$1)) == null || DropTarget.access$200(1.access$100(this.this$1)).isDisposed() || DropTarget.access$200(1.access$100(this.this$1)).isVisible()) {
                                    return;
                                }
                                DropTarget.access$400(1.access$100(this.this$1));
                            }
                        });
                        break;
                    }
                }
            }

            static /* synthetic */ DropTarget access$100(1 x0) {
                return x0.DropTarget.this;
            }
        };
        control.addListener(12, this.controlListener);
        Control c = control;
        while (c != null) {
            c.addListener(22, this.controlListener);
            c.addListener(23, this.controlListener);
            c = c.getParent();
        }
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (DropTarget.this.control == null || DropTarget.this.control.isDisposed()) {
                    return;
                }
                DropTarget.this.unregisterDropTarget();
                DropTarget.this.onDispose();
            }
        });
        this.effect = control instanceof Tree ? new TreeDragUnderEffect((Tree)control) : (control instanceof Table ? new TableDragUnderEffect((Table)control) : new NoDragUnderEffect(control));
        if (control.isVisible()) {
            this.registerDropTarget();
        }
    }

    static DropTarget FindDropTarget(int handle) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(handle);
        if (widget == null) {
            return null;
        }
        return (DropTarget)widget.getData(DROPTARGETID);
    }

    private static int DragProcCallback(int widget, int client_data, int call_data) {
        DropTarget target = DropTarget.FindDropTarget(widget);
        if (target == null) {
            return 0;
        }
        return target.dragProcCallback(widget, client_data, call_data);
    }

    private static int DropProcCallback(int widget, int client_data, int call_data) {
        DropTarget target = DropTarget.FindDropTarget(widget);
        if (target == null) {
            return 0;
        }
        return target.dropProcCallback(widget, client_data, call_data);
    }

    private static int TransferProcCallback(int widget, int client_data, int pSelection, int pType, int pValue, int pLength, int pFormat) {
        DropTarget target = DropTarget.FindDropTarget(client_data);
        if (target == null) {
            return 0;
        }
        return target.transferProcCallback(widget, client_data, pSelection, pType, pValue, pLength, pFormat);
    }

    public void addDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        this.addListener(2002, typedListener);
        this.addListener(2003, typedListener);
        this.addListener(2004, typedListener);
        this.addListener(2005, typedListener);
        this.addListener(2006, typedListener);
        this.addListener(2007, typedListener);
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = (class$org$eclipse$swt$dnd$DropTarget == null ? (class$org$eclipse$swt$dnd$DropTarget = DropTarget.class$("org.eclipse.swt.dnd.DropTarget")) : class$org$eclipse$swt$dnd$DropTarget).getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    private int dragProcCallback(int widget, int client_data, int call_data) {
        int allowedOperations;
        XmDragProcCallback callbackData = new XmDragProcCallback();
        OS.memmove(callbackData, call_data, 24);
        if (callbackData.reason == 2) {
            this.releaseDropInfo();
            int ppExportTargets = OS.XtMalloc(4);
            int pNumExportTargets = OS.XtMalloc(4);
            int[] args = new int[]{OS.XmNexportTargets, ppExportTargets, OS.XmNnumExportTargets, pNumExportTargets};
            OS.XtGetValues(callbackData.dragContext, args, args.length / 2);
            int[] numExportTargets = new int[1];
            OS.memmove(numExportTargets, pNumExportTargets, 4);
            OS.XtFree(pNumExportTargets);
            int[] pExportTargets = new int[1];
            OS.memmove(pExportTargets, ppExportTargets, 4);
            OS.XtFree(ppExportTargets);
            int[] exportTargets = new int[numExportTargets[0]];
            OS.memmove(exportTargets, pExportTargets[0], 4 * numExportTargets[0]);
            int i = 0;
            int length = exportTargets.length;
            while (i < length) {
                int j = 0;
                int length2 = this.transferAgents.length;
                while (j < length2) {
                    TransferData transferData = new TransferData();
                    transferData.type = exportTargets[i];
                    if (this.transferAgents[j].isSupportedType(transferData)) {
                        TransferData[] newDataTypes = new TransferData[this.dataTypes.length + 1];
                        System.arraycopy(this.dataTypes, 0, newDataTypes, 0, this.dataTypes.length);
                        newDataTypes[this.dataTypes.length] = transferData;
                        this.dataTypes = newDataTypes;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.dataTypes == null || this.dataTypes.length == 0) {
            callbackData.dropSiteStatus = (byte)2;
            callbackData.operation = this.opToOsOp(0);
            OS.memmove(call_data, callbackData, 24);
            return 0;
        }
        if (this.selectedDataType == null) {
            this.selectedDataType = this.dataTypes[0];
        }
        DNDEvent event = new DNDEvent();
        event.widget = this.control;
        event.time = callbackData.timeStamp;
        short[] root_x = new short[1];
        short[] root_y = new short[1];
        OS.XtTranslateCoords(this.control.handle, callbackData.x, callbackData.y, root_x, root_y);
        event.x = root_x[0];
        event.y = root_y[0];
        event.dataTypes = this.dataTypes;
        event.feedback = 1;
        event.operations = allowedOperations = this.osOpToOp(callbackData.operations);
        event.dataType = this.selectedDataType;
        try {
            switch (callbackData.reason) {
                case 2: {
                    int mask;
                    event.detail = this.osOpToOp(callbackData.operation);
                    if ((this.getStyle() & 0x10) != 0) {
                        int xDisplay = this.getDisplay().xDisplay;
                        int xWindow = OS.XDefaultRootWindow(xDisplay);
                        int[] unused = new int[1];
                        int[] mask_return = new int[1];
                        OS.XQueryPointer(xDisplay, xWindow, unused, unused, unused, unused, unused, unused, mask_return);
                        mask = mask_return[0];
                        if ((mask & 1) == 0 && (mask & 4) == 0) {
                            event.detail = 16;
                        }
                    }
                    this.updateDragOverHover(50L, event);
                    this.notifyListeners(2002, event);
                    this.effect.show(event.feedback, event.x, event.y);
                    break;
                }
                case 3: {
                    event.detail = this.lastOperation;
                    this.updateDragOverHover(50L, event);
                    this.notifyListeners(2004, event);
                    this.effect.show(event.feedback, event.x, event.y);
                    break;
                }
                case 8: {
                    int mask;
                    event.detail = this.osOpToOp(callbackData.operation);
                    if ((this.getStyle() & 0x10) != 0) {
                        int xDisplay = this.getDisplay().xDisplay;
                        int xWindow = OS.XDefaultRootWindow(xDisplay);
                        int[] unused = new int[1];
                        int[] mask_return = new int[1];
                        OS.XQueryPointer(xDisplay, xWindow, unused, unused, unused, unused, unused, unused, mask_return);
                        mask = mask_return[0];
                        if ((mask & 1) == 0 && (mask & 4) == 0) {
                            event.detail = 16;
                        }
                    }
                    this.updateDragOverHover(50L, event);
                    this.notifyListeners(2005, event);
                    this.effect.show(event.feedback, event.x, event.y);
                    break;
                }
                case 1: {
                    event.detail = 0;
                    this.updateDragOverHover(0L, null);
                    this.notifyListeners(2003, event);
                    this.effect.show(0, 0, 0);
                    return 0;
                }
            }
        }
        catch (Throwable err) {
            callbackData.dropSiteStatus = (byte)2;
            callbackData.operation = this.opToOsOp(0);
            OS.memmove(call_data, callbackData, 24);
            return 0;
        }
        if (event.detail == 16) {
            event.detail = 2;
        }
        this.selectedDataType = null;
        int i = 0;
        while (i < this.dataTypes.length) {
            if (this.dataTypes[i].equals(event.dataType)) {
                this.selectedDataType = event.dataType;
                break;
            }
            ++i;
        }
        this.lastOperation = 0;
        if (this.selectedDataType != null && (event.detail & allowedOperations) != 0) {
            this.lastOperation = event.detail;
        }
        callbackData.dropSiteStatus = (byte)3;
        callbackData.operation = this.opToOsOp(this.lastOperation);
        OS.memmove(call_data, callbackData, 24);
        if (this.dragOverHeartbeat == null) {
            this.dragOverHeartbeat = new Runnable(){

                public void run() {
                    if (DropTarget.this.control.isDisposed() || DropTarget.this.dragOverStart == 0L) {
                        return;
                    }
                    long time = System.currentTimeMillis();
                    int delay = 50;
                    if (time >= DropTarget.this.dragOverStart) {
                        int allowedOperations;
                        if (DropTarget.this.selectedDataType == null) {
                            DropTarget.this.selectedDataType = ((DropTarget)DropTarget.this).dragOverEvent.dataTypes[0];
                        }
                        DNDEvent event = new DNDEvent();
                        event.widget = DropTarget.this.control;
                        event.time = (int)time;
                        event.x = ((DropTarget)DropTarget.this).dragOverEvent.x;
                        event.y = ((DropTarget)DropTarget.this).dragOverEvent.y;
                        event.dataTypes = ((DropTarget)DropTarget.this).dragOverEvent.dataTypes;
                        event.feedback = 1;
                        event.operations = allowedOperations = ((DropTarget)DropTarget.this).dragOverEvent.operations;
                        event.dataType = DropTarget.this.selectedDataType;
                        event.detail = DropTarget.this.lastOperation;
                        DropTarget.this.notifyListeners(2004, event);
                        DropTarget.this.effect.show(event.feedback, event.x, event.y);
                        DropTarget.this.selectedDataType = null;
                        int i = 0;
                        while (i < DropTarget.this.dataTypes.length) {
                            if (DropTarget.this.dataTypes[i].equals(event.dataType)) {
                                DropTarget.this.selectedDataType = event.dataType;
                                break;
                            }
                            ++i;
                        }
                        DropTarget.this.lastOperation = 0;
                        if (DropTarget.this.selectedDataType != null && (event.detail & allowedOperations) == event.detail) {
                            DropTarget.this.lastOperation = event.detail;
                        }
                    } else {
                        delay = (int)(DropTarget.this.dragOverStart - time);
                    }
                    DropTarget.this.control.getDisplay().timerExec(delay, DropTarget.this.dragOverHeartbeat);
                }
            };
            this.dragOverHeartbeat.run();
        }
        return 0;
    }

    private int dropProcCallback(int widget, int client_data, int call_data) {
        int allowedOperations;
        this.updateDragOverHover(0L, null);
        this.effect.show(0, 0, 0);
        this.droppedEventData = new XmDropProcCallback();
        OS.memmove(this.droppedEventData, call_data, 24);
        DNDEvent event = new DNDEvent();
        event.widget = this.control;
        event.time = this.droppedEventData.timeStamp;
        short[] root_x = new short[1];
        short[] root_y = new short[1];
        OS.XtTranslateCoords(this.control.handle, this.droppedEventData.x, this.droppedEventData.y, root_x, root_y);
        event.x = root_x[0];
        event.y = root_y[0];
        event.dataTypes = this.dataTypes;
        event.operations = allowedOperations = this.osOpToOp(this.droppedEventData.operations);
        event.dataType = this.selectedDataType;
        event.detail = this.lastOperation;
        try {
            this.notifyListeners(2007, event);
        }
        catch (Throwable err) {
            event.detail = 0;
            event.dataType = null;
        }
        this.selectedDataType = null;
        int i = 0;
        while (i < this.dataTypes.length) {
            if (this.dataTypes[i].equals(event.dataType)) {
                this.selectedDataType = event.dataType;
                break;
            }
            ++i;
        }
        this.lastOperation = 0;
        if (this.selectedDataType != null && (event.detail & allowedOperations) == event.detail) {
            this.lastOperation = event.detail;
        }
        if (this.lastOperation == 0) {
            int[] args = new int[]{OS.XmNtransferStatus, 0, OS.XmNnumDropTransfers, 0};
            this.dropTransferObject = OS.XmDropTransferStart(this.droppedEventData.dragContext, args, args.length / 2);
            return 0;
        }
        int[] transferEntries = new int[]{this.control.handle, this.selectedDataType.type};
        int pTransferEntries = OS.XtMalloc(transferEntries.length * 4);
        OS.memmove(pTransferEntries, transferEntries, transferEntries.length * 4);
        int xtContext = OS.XtDisplayToApplicationContext(this.getDisplay().xDisplay);
        this.selectionTimeout = OS.XtAppGetSelectionTimeout(xtContext);
        OS.XtAppSetSelectionTimeout(xtContext, Integer.MAX_VALUE);
        int[] args = new int[]{OS.XmNdropTransfers, pTransferEntries, OS.XmNnumDropTransfers, transferEntries.length / 2, OS.XmNtransferProc, TransferProc.getAddress()};
        this.dropTransferObject = OS.XmDropTransferStart(this.droppedEventData.dragContext, args, args.length / 2);
        OS.XtFree(pTransferEntries);
        return 0;
    }

    public Control getControl() {
        return this.control;
    }

    public Display getDisplay() {
        if (this.control == null) {
            DND.error(24);
        }
        return this.control.getDisplay();
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    public void notifyListeners(int eventType, Event event) {
        Point coordinates = new Point(event.x, event.y);
        coordinates = this.control.toControl(coordinates);
        if (this.control instanceof Tree) {
            event.item = ((Tree)this.control).getItem(coordinates);
        }
        if (this.control instanceof Table) {
            event.item = ((Table)this.control).getItem(coordinates);
        }
        super.notifyListeners(eventType, event);
    }

    private void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            Control c = this.control;
            while (c != null) {
                c.removeListener(22, this.controlListener);
                c.removeListener(23, this.controlListener);
                c = c.getParent();
            }
            this.control.removeListener(12, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData(DROPTARGETID, null);
        this.control = null;
        this.transferAgents = null;
    }

    private byte opToOsOp(int operation) {
        byte osOperation = 0;
        if ((operation & 1) == 1) {
            osOperation = (byte)(osOperation | 2);
        }
        if ((operation & 2) == 2) {
            osOperation = (byte)(osOperation | 1);
        }
        if ((operation & 4) == 4) {
            osOperation = (byte)(osOperation | 4);
        }
        return osOperation;
    }

    private int osOpToOp(byte osOperation) {
        int operation = 0;
        if ((osOperation & 2) == 2) {
            operation |= 1;
        }
        if ((osOperation & 1) == 1) {
            operation |= 2;
        }
        if ((osOperation & 4) == 4) {
            operation |= 4;
        }
        return operation;
    }

    private void registerDropTarget() {
        if (this.control == null || this.control.isDisposed() || this.registered) {
            return;
        }
        int[] args = new int[]{OS.XmNdropSiteOperations, this.opToOsOp(this.getStyle()), OS.XmNdropSiteActivity, 0, OS.XmNdropProc, DropProc.getAddress(), OS.XmNdragProc, DragProc.getAddress(), OS.XmNanimationStyle, 0, OS.XmNdropSiteType, 1};
        if (this.transferAgents.length != 0) {
            TransferData[] transferData = new TransferData[]{};
            int i = 0;
            int length = this.transferAgents.length;
            while (i < length) {
                TransferData[] data = this.transferAgents[i].getSupportedTypes();
                TransferData[] newTransferData = new TransferData[transferData.length + data.length];
                System.arraycopy(transferData, 0, newTransferData, 0, transferData.length);
                System.arraycopy(data, 0, newTransferData, transferData.length, data.length);
                transferData = newTransferData;
                ++i;
            }
            int[] atoms = new int[transferData.length];
            int i2 = 0;
            int length2 = transferData.length;
            while (i2 < length2) {
                atoms[i2] = transferData[i2].type;
                ++i2;
            }
            int pImportTargets = OS.XtMalloc(atoms.length * 4);
            OS.memmove(pImportTargets, atoms, atoms.length * 4);
            int[] args2 = new int[]{OS.XmNimportTargets, pImportTargets, OS.XmNnumImportTargets, atoms.length};
            int[] newArgs = new int[args.length + args2.length];
            System.arraycopy(args, 0, newArgs, 0, args.length);
            System.arraycopy(args2, 0, newArgs, args.length, args2.length);
            args = newArgs;
        }
        OS.XmDropSiteRegister(this.control.handle, args, args.length / 2);
        this.registered = true;
    }

    private void releaseDropInfo() {
        this.selectedDataType = null;
        this.dataTypes = new TransferData[0];
        this.droppedEventData = null;
        this.dropTransferObject = 0;
    }

    private void unregisterDropTarget() {
        if (this.control == null || this.control.isDisposed() || !this.registered) {
            return;
        }
        OS.XmDropSiteUnregister(this.control.handle);
        this.registered = false;
    }

    private void updateDragOverHover(long delay, DNDEvent event) {
        if (delay == 0L) {
            this.dragOverStart = 0L;
            this.dragOverEvent = null;
            this.dragOverHeartbeat = null;
            return;
        }
        this.dragOverStart = System.currentTimeMillis() + delay;
        if (this.dragOverEvent == null) {
            this.dragOverEvent = new DNDEvent();
        }
        this.dragOverEvent.x = event.x;
        this.dragOverEvent.y = event.y;
        this.dragOverEvent.dataTypes = event.dataTypes;
        this.dragOverEvent.operations = event.operations;
        this.dragOverEvent.dataType = event.dataType;
        this.dragOverEvent.detail = event.detail;
    }

    public void removeDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2002, listener);
        this.removeListener(2003, listener);
        this.removeListener(2004, listener);
        this.removeListener(2005, listener);
        this.removeListener(2006, listener);
        this.removeListener(2007, listener);
    }

    public void setTransfer(Transfer[] transferAgents) {
        if (transferAgents == null) {
            DND.error(4);
        }
        this.transferAgents = transferAgents;
        if (!this.control.isVisible()) {
            return;
        }
        TransferData[] transferData = new TransferData[]{};
        int i = 0;
        int length = transferAgents.length;
        while (i < length) {
            TransferData[] data = transferAgents[i].getSupportedTypes();
            TransferData[] newTransferData = new TransferData[transferData.length + data.length];
            System.arraycopy(transferData, 0, newTransferData, 0, transferData.length);
            System.arraycopy(data, 0, newTransferData, transferData.length, data.length);
            transferData = newTransferData;
            ++i;
        }
        int[] atoms = new int[transferData.length];
        int i2 = 0;
        int length2 = transferData.length;
        while (i2 < length2) {
            atoms[i2] = transferData[i2].type;
            ++i2;
        }
        int pImportTargets = OS.XtMalloc(atoms.length * 4);
        OS.memmove(pImportTargets, atoms, atoms.length * 4);
        int[] args = new int[]{OS.XmNimportTargets, pImportTargets, OS.XmNnumImportTargets, atoms.length};
        OS.XmDropSiteUpdate(this.control.handle, args, args.length / 2);
        OS.XtFree(pImportTargets);
    }

    private int transferProcCallback(int widget, int client_data, int pSelection, int pType, int pValue, int pLength, int pFormat) {
        int[] type = new int[1];
        OS.memmove(type, pType, 4);
        Transfer transferAgent = null;
        TransferData transferData = new TransferData();
        transferData.type = type[0];
        int i = 0;
        while (i < this.transferAgents.length) {
            if (this.transferAgents[i].isSupportedType(transferData)) {
                transferAgent = this.transferAgents[i];
                break;
            }
            ++i;
        }
        if (transferAgent != null) {
            transferData.pValue = pValue;
            int[] length = new int[1];
            OS.memmove(length, pLength, 4);
            transferData.length = length[0];
            int[] format = new int[1];
            OS.memmove(format, pFormat, 4);
            transferData.format = format[0];
            Object data = transferAgent.nativeToJava(transferData);
            OS.XtFree(transferData.pValue);
            DNDEvent event = new DNDEvent();
            event.widget = this.control;
            event.time = this.droppedEventData.timeStamp;
            short[] root_x = new short[1];
            short[] root_y = new short[1];
            OS.XtTranslateCoords(this.control.handle, this.droppedEventData.x, this.droppedEventData.y, root_x, root_y);
            event.x = root_x[0];
            event.y = root_y[0];
            event.dataTypes = this.dataTypes;
            event.operations = this.osOpToOp(this.droppedEventData.operations);
            event.dataType = transferData;
            event.detail = this.lastOperation;
            event.data = data;
            try {
                this.notifyListeners(2006, event);
            }
            catch (Throwable err) {
                event.detail = 0;
            }
            int xtContext = OS.XtDisplayToApplicationContext(this.getDisplay().xDisplay);
            OS.XtAppSetSelectionTimeout(xtContext, this.selectionTimeout);
            if ((event.detail & 2) == 2) {
                int[] args = new int[]{this.control.handle, DELETE_TYPE};
                OS.XmDropTransferAdd(this.dropTransferObject, args, args.length / 2);
            }
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$300(DropTarget x0) {
        x0.registerDropTarget();
    }
}

