/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XRectangle;

public final class Region {
    public int handle;

    public Region() {
        this.handle = OS.XCreateRegion();
    }

    Region(int handle) {
        this.handle = handle;
    }

    public void add(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        if (rect.width < 0 || rect.height < 0) {
            SWT.error(5);
        }
        XRectangle xRect = new XRectangle();
        xRect.x = (short)rect.x;
        xRect.y = (short)rect.y;
        xRect.width = (short)rect.width;
        xRect.height = (short)rect.height;
        OS.XUnionRectWithRegion(xRect, this.handle, this.handle);
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.XUnionRegion(this.handle, region.handle, this.handle);
    }

    public boolean contains(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.XPointInRegion(this.handle, x, y);
    }

    public boolean contains(Point pt) {
        if (pt == null) {
            SWT.error(4);
        }
        return this.contains(pt.x, pt.y);
    }

    public void dispose() {
        if (this.handle != 0) {
            OS.XDestroyRegion(this.handle);
        }
        this.handle = 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.handle == region.handle;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        XRectangle rect = new XRectangle();
        OS.XClipBox(this.handle, rect);
        return new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean intersects(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.XRectInRegion(this.handle, x, y, width, height) != 0;
    }

    public boolean intersects(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        return this.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.XEmptyRegion(this.handle);
    }

    public static Region motif_new(int handle) {
        return new Region(handle);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

