/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class GridLayout
extends Layout {
    public int marginWidth = 5;
    public int marginHeight = 5;
    public int numColumns = 1;
    public boolean makeColumnsEqualWidth = false;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;
    Vector grid = new Vector();
    int[] pixelColumnWidths;
    int[] pixelRowHeights;
    int[] expandableColumns;
    int[] expandableRows;

    public GridLayout() {
    }

    public GridLayout(int numColumns, boolean makeColumnsEqualWidth) {
        this.numColumns = numColumns;
        this.makeColumnsEqualWidth = makeColumnsEqualWidth;
    }

    void adjustGridDimensions(Composite composite, boolean flushCache) {
        int row = 0;
        while (row < this.grid.size()) {
            int column = 0;
            while (column < this.numColumns) {
                GridData spec = ((GridData[])this.grid.elementAt(row))[column];
                if (spec.isItemData()) {
                    int i;
                    int j;
                    int i2;
                    int extraSpaceNeeded;
                    int spannedSize;
                    int lastSpanIndex;
                    Point extent;
                    Control child;
                    if (spec.hSpan > 1) {
                        child = composite.getChildren()[spec.childIndex];
                        extent = child.computeSize(spec.widthHint, spec.heightHint, flushCache);
                        lastSpanIndex = column + spec.hSpan;
                        spannedSize = 0;
                        int c = column;
                        while (c < lastSpanIndex) {
                            spannedSize = spannedSize + this.pixelColumnWidths[c] + this.horizontalSpacing;
                            ++c;
                        }
                        if (extent.x + spec.horizontalIndent > (spannedSize -= this.horizontalSpacing)) {
                            int colWidth;
                            extraSpaceNeeded = extent.x + spec.horizontalIndent - spannedSize;
                            int lastColumn = column + spec.hSpan - 1;
                            if (this.makeColumnsEqualWidth) {
                                int columnExtra = extraSpaceNeeded / this.numColumns;
                                int columnRemainder = extraSpaceNeeded % this.numColumns;
                                int i3 = 0;
                                while (i3 < this.pixelColumnWidths.length) {
                                    this.pixelColumnWidths[i3] = colWidth = this.pixelColumnWidths[i3] + columnExtra;
                                    ++i3;
                                }
                                this.pixelColumnWidths[lastColumn] = colWidth = this.pixelColumnWidths[lastColumn] + columnRemainder;
                            } else {
                                Vector<Integer> localExpandableColumns = new Vector<Integer>();
                                i2 = column;
                                while (i2 <= lastColumn) {
                                    j = 0;
                                    while (j < this.expandableColumns.length) {
                                        if (this.expandableColumns[j] == i2) {
                                            localExpandableColumns.addElement(new Integer(i2));
                                        }
                                        ++j;
                                    }
                                    ++i2;
                                }
                                if (localExpandableColumns.size() > 0) {
                                    int columnExtra = extraSpaceNeeded / localExpandableColumns.size();
                                    int columnRemainder = extraSpaceNeeded % localExpandableColumns.size();
                                    i = 0;
                                    while (i < localExpandableColumns.size()) {
                                        int expandableCol = (Integer)localExpandableColumns.elementAt(i);
                                        this.pixelColumnWidths[expandableCol] = colWidth = this.pixelColumnWidths[expandableCol] + columnExtra;
                                        ++i;
                                    }
                                    this.pixelColumnWidths[lastColumn] = colWidth = this.pixelColumnWidths[lastColumn] + columnRemainder;
                                } else {
                                    this.pixelColumnWidths[lastColumn] = colWidth = this.pixelColumnWidths[lastColumn] + extraSpaceNeeded;
                                }
                            }
                        }
                    }
                    if (spec.verticalSpan > 1) {
                        child = composite.getChildren()[spec.childIndex];
                        extent = child.computeSize(spec.widthHint, spec.heightHint, flushCache);
                        lastSpanIndex = row + spec.verticalSpan;
                        spannedSize = 0;
                        int r = row;
                        while (r < lastSpanIndex) {
                            spannedSize = spannedSize + this.pixelRowHeights[r] + this.verticalSpacing;
                            ++r;
                        }
                        if (extent.y > (spannedSize -= this.verticalSpacing)) {
                            int rowHeight;
                            extraSpaceNeeded = extent.y - spannedSize;
                            int lastRow = row + spec.verticalSpan - 1;
                            Vector<Integer> localExpandableRows = new Vector<Integer>();
                            i2 = row;
                            while (i2 <= lastRow) {
                                j = 0;
                                while (j < this.expandableRows.length) {
                                    if (this.expandableRows[j] == i2) {
                                        localExpandableRows.addElement(new Integer(i2));
                                    }
                                    ++j;
                                }
                                ++i2;
                            }
                            if (localExpandableRows.size() > 0) {
                                int rowExtra = extraSpaceNeeded / localExpandableRows.size();
                                int rowRemainder = extraSpaceNeeded % localExpandableRows.size();
                                i = 0;
                                while (i < localExpandableRows.size()) {
                                    int expandableRow = (Integer)localExpandableRows.elementAt(i);
                                    this.pixelRowHeights[expandableRow] = rowHeight = this.pixelRowHeights[expandableRow] + rowExtra;
                                    ++i;
                                }
                                this.pixelRowHeights[lastRow] = rowHeight = this.pixelRowHeights[lastRow] + rowRemainder;
                            } else {
                                this.pixelRowHeights[lastRow] = rowHeight = this.pixelRowHeights[lastRow] + extraSpaceNeeded;
                            }
                        }
                    }
                }
                ++column;
            }
            ++row;
        }
    }

    void calculateGridDimensions(Composite composite, boolean flushCache) {
        int row;
        int maxWidth;
        Control[] children = composite.getChildren();
        Point[] childSizes = new Point[children.length];
        this.pixelColumnWidths = new int[this.numColumns];
        this.pixelRowHeights = new int[this.grid.size()];
        int column = 0;
        while (column < this.numColumns) {
            maxWidth = 0;
            row = 0;
            while (row < this.grid.size()) {
                GridData spec = ((GridData[])this.grid.elementAt(row))[column];
                if (spec.isItemData()) {
                    Control child = children[spec.childIndex];
                    childSizes[spec.childIndex] = child.computeSize(spec.widthHint, spec.heightHint, flushCache);
                    int childWidth = childSizes[spec.childIndex].x + spec.horizontalIndent;
                    if (spec.hSpan == 1) {
                        maxWidth = Math.max(maxWidth, childWidth);
                    }
                }
                ++row;
            }
            this.pixelColumnWidths[column] = maxWidth;
            ++column;
        }
        if (this.makeColumnsEqualWidth) {
            maxWidth = 0;
            int i = 0;
            while (i < this.numColumns) {
                maxWidth = Math.max(maxWidth, this.pixelColumnWidths[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < this.numColumns) {
                this.pixelColumnWidths[i2] = maxWidth;
                ++i2;
            }
        }
        row = 0;
        while (row < this.grid.size()) {
            int maxHeight = 0;
            int column2 = 0;
            while (column2 < this.numColumns) {
                GridData spec = ((GridData[])this.grid.elementAt(row))[column2];
                if (spec.isItemData()) {
                    int childHeight = childSizes[spec.childIndex].y;
                    if (spec.verticalSpan == 1) {
                        maxHeight = Math.max(maxHeight, childHeight);
                    }
                }
                ++column2;
            }
            this.pixelRowHeights[row] = maxHeight;
            ++row;
        }
    }

    void computeExpandableCells() {
        Hashtable<Integer, Object> growColumns = new Hashtable<Integer, Object>();
        Hashtable<Integer, Object> growRows = new Hashtable<Integer, Object>();
        int col = 0;
        while (col < this.numColumns) {
            int row = 0;
            while (row < this.grid.size()) {
                GridData spec = ((GridData[])this.grid.elementAt(row))[col];
                if (spec.grabExcessHorizontalSpace) {
                    growColumns.put(new Integer(col + spec.hSpan - 1), new Object());
                }
                if (spec.grabExcessVerticalSpace) {
                    growRows.put(new Integer(row + spec.verticalSpan - 1), new Object());
                }
                ++row;
            }
            ++col;
        }
        int i = 0;
        Enumeration enumeration = growColumns.keys();
        this.expandableColumns = new int[growColumns.size()];
        while (enumeration.hasMoreElements()) {
            this.expandableColumns[i] = (Integer)enumeration.nextElement();
            ++i;
        }
        i = 0;
        enumeration = growRows.keys();
        this.expandableRows = new int[growRows.size()];
        while (enumeration.hasMoreElements()) {
            this.expandableRows[i] = (Integer)enumeration.nextElement();
            ++i;
        }
    }

    Point computeLayoutSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        if (this.grid.size() == 0) {
            this.createGrid(composite);
            this.calculateGridDimensions(composite, flushCache);
            this.computeExpandableCells();
            this.adjustGridDimensions(composite, flushCache);
        }
        int cols = this.numColumns;
        int rows = this.grid.size();
        int totalMarginHeight = this.marginHeight;
        int totalMarginWidth = this.marginWidth;
        int totalWidth = totalMarginWidth * 2 + (cols - 1) * this.horizontalSpacing;
        int i = 0;
        while (i < this.pixelColumnWidths.length) {
            totalWidth += this.pixelColumnWidths[i];
            ++i;
        }
        int totalHeight = totalMarginHeight * 2 + (rows - 1) * this.verticalSpacing;
        int i2 = 0;
        while (i2 < this.pixelRowHeights.length) {
            totalHeight += this.pixelRowHeights[i2];
            ++i2;
        }
        if (wHint != -1) {
            totalWidth = wHint;
        }
        if (hHint != -1) {
            totalHeight = hHint;
        }
        return new Point(totalWidth, totalHeight);
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control[] children = composite.getChildren();
        int numChildren = children.length;
        if (numChildren == 0) {
            return new Point(0, 0);
        }
        if (flushCache) {
            this.grid.removeAllElements();
        }
        return this.computeLayoutSize(composite, wHint, hHint, flushCache);
    }

    Point getFirstEmptyCell(int row, int column) {
        GridData[] rowData = (GridData[])this.grid.elementAt(row);
        while (column < this.numColumns && rowData[column] != null) {
            ++column;
        }
        if (column == this.numColumns) {
            column = 0;
            if (++row == this.grid.size()) {
                this.grid.addElement(this.emptyRow());
            }
            return this.getFirstEmptyCell(row, column);
        }
        return new Point(row, column);
    }

    Point getLastEmptyCell(int row, int column) {
        GridData[] rowData = (GridData[])this.grid.elementAt(row);
        while (column < this.numColumns && rowData[column] == null) {
            ++column;
        }
        return new Point(row, column - 1);
    }

    Point getCell(int row, int column, int width, int height) {
        Point start = this.getFirstEmptyCell(row, column);
        Point end = this.getLastEmptyCell(start.x, start.y);
        if (end.y + 1 - start.y >= width) {
            return start;
        }
        GridData[] rowData = (GridData[])this.grid.elementAt(start.x);
        int j = start.y;
        while (j < end.y + 1) {
            GridData spacerSpec = new GridData();
            spacerSpec.isItemData = false;
            rowData[j] = spacerSpec;
            ++j;
        }
        return this.getCell(end.x, end.y, width, height);
    }

    void createGrid(Composite composite) {
        GridData spacerSpec;
        Control[] children = composite.getChildren();
        this.grid.addElement(this.emptyRow());
        int row = 0;
        int column = 0;
        int i = 0;
        while (i < children.length) {
            int c;
            Control child = children[i];
            GridData spec = (GridData)child.getLayoutData();
            if (spec == null) {
                spec = new GridData();
                child.setLayoutData(spec);
            }
            spec.hSpan = Math.min(spec.horizontalSpan, this.numColumns);
            Point p = this.getCell(row, column, spec.hSpan, spec.verticalSpan);
            row = p.x;
            column = p.y;
            int j = 2;
            while (j <= spec.verticalSpan) {
                if (row + j > this.grid.size()) {
                    this.grid.addElement(this.emptyRow());
                }
                ++j;
            }
            ((GridData[])this.grid.elementAt((int)row))[column] = spec;
            spec.childIndex = i;
            int rowFill = spec.verticalSpan - 1;
            int columnFill = spec.hSpan - 1;
            int r = 1;
            while (r <= rowFill) {
                c = 0;
                while (c < spec.hSpan) {
                    spacerSpec = new GridData();
                    spacerSpec.isItemData = false;
                    ((GridData[])this.grid.elementAt((int)(row + r)))[column + c] = spacerSpec;
                    ++c;
                }
                ++r;
            }
            c = 1;
            while (c <= columnFill) {
                int r2 = 0;
                while (r2 < spec.verticalSpan) {
                    spacerSpec = new GridData();
                    spacerSpec.isItemData = false;
                    ((GridData[])this.grid.elementAt((int)(row + r2)))[column + c] = spacerSpec;
                    ++r2;
                }
                ++c;
            }
            column = column + spec.hSpan - 1;
            ++i;
        }
        int r = row;
        while (r < this.grid.size()) {
            GridData[] rowData = (GridData[])this.grid.elementAt(r);
            int c = 0;
            while (c < this.numColumns) {
                if (rowData[c] == null) {
                    spacerSpec = new GridData();
                    spacerSpec.isItemData = false;
                    rowData[c] = spacerSpec;
                }
                ++c;
            }
            ++r;
        }
    }

    GridData[] emptyRow() {
        GridData[] row = new GridData[this.numColumns];
        int i = 0;
        while (i < this.numColumns) {
            row[i] = null;
            ++i;
        }
        return row;
    }

    protected void layout(Composite composite, boolean flushCache) {
        int rowHeight;
        Control[] children;
        if (flushCache) {
            this.grid.removeAllElements();
        }
        if ((children = composite.getChildren()).length == 0) {
            return;
        }
        Point extent = this.computeSize(composite, -1, -1, flushCache);
        int[] columnWidths = new int[this.numColumns];
        int i = 0;
        while (i < this.pixelColumnWidths.length) {
            columnWidths[i] = this.pixelColumnWidths[i];
            ++i;
        }
        int[] rowHeights = new int[this.grid.size()];
        int i2 = 0;
        while (i2 < this.pixelRowHeights.length) {
            rowHeights[i2] = this.pixelRowHeights[i2];
            ++i2;
        }
        int columnWidth = 0;
        int rowSize = Math.max(1, this.grid.size());
        int compositeWidth = extent.x;
        int compositeHeight = extent.y;
        int excessHorizontal = composite.getClientArea().width - compositeWidth;
        int excessVertical = composite.getClientArea().height - compositeHeight;
        if (this.expandableColumns.length != 0) {
            int colWidth;
            int excess = excessHorizontal / this.expandableColumns.length;
            int remainder = excessHorizontal % this.expandableColumns.length;
            int last = 0;
            int i3 = 0;
            while (i3 < this.expandableColumns.length) {
                int expandableCol = this.expandableColumns[i3];
                colWidth = columnWidths[expandableCol];
                columnWidths[expandableCol] = colWidth += excess;
                last = Math.max(last, expandableCol);
                ++i3;
            }
            colWidth = columnWidths[last];
            columnWidths[last] = colWidth += remainder;
        }
        int i4 = 0;
        while (i4 < this.expandableColumns.length) {
            int expandableCol = this.expandableColumns[i4];
            int colWidth = columnWidths[expandableCol];
            int minWidth = 0;
            int j = 0;
            while (j < this.grid.size()) {
                GridData[] row = (GridData[])this.grid.elementAt(j);
                GridData spec = row[expandableCol];
                if (spec.hSpan == 1) {
                    minWidth = Math.max(minWidth, spec.widthHint);
                }
                ++j;
            }
            columnWidths[expandableCol] = Math.max(colWidth, minWidth);
            ++i4;
        }
        if (this.expandableRows.length != 0) {
            int rowHeight2;
            int excess = excessVertical / this.expandableRows.length;
            int remainder = excessVertical % this.expandableRows.length;
            int last = 0;
            int i5 = 0;
            while (i5 < this.expandableRows.length) {
                int expandableRow = this.expandableRows[i5];
                rowHeight2 = rowHeights[expandableRow];
                rowHeights[expandableRow] = rowHeight2 += excess;
                last = Math.max(last, expandableRow);
                ++i5;
            }
            rowHeight2 = rowHeights[last];
            rowHeights[last] = rowHeight2 += remainder;
        }
        int i6 = 0;
        while (i6 < this.expandableRows.length) {
            int expandableRow = this.expandableRows[i6];
            rowHeight = rowHeights[expandableRow];
            int minHeight = 0;
            GridData[] row = (GridData[])this.grid.elementAt(expandableRow);
            int j = 0;
            while (j < this.numColumns) {
                GridData spec = row[j];
                if (spec.verticalSpan == 1) {
                    minHeight = Math.max(minHeight, spec.heightHint);
                }
                ++j;
            }
            rowHeights[expandableRow] = Math.max(rowHeight, minHeight);
            ++i6;
        }
        int columnX = this.marginWidth + composite.getClientArea().x;
        int rowY = this.marginHeight + composite.getClientArea().y;
        int r = 0;
        while (r < rowSize) {
            rowHeight = rowHeights[r];
            GridData[] row = (GridData[])this.grid.elementAt(r);
            int c = 0;
            while (c < row.length) {
                int spannedWidth = 0;
                int spannedHeight = 0;
                int hAlign = 0;
                int vAlign = 0;
                int widgetX = 0;
                int widgetY = 0;
                int widgetW = 0;
                int widgetH = 0;
                GridData spec = row[c];
                if (this.makeColumnsEqualWidth) {
                    columnWidth = composite.getClientArea().width - 2 * this.marginWidth - (this.numColumns - 1) * this.horizontalSpacing;
                    columnWidth /= this.numColumns;
                    int i7 = 0;
                    while (i7 < columnWidths.length) {
                        columnWidths[i7] = columnWidth;
                        ++i7;
                    }
                } else {
                    columnWidth = columnWidths[c];
                }
                spannedWidth = columnWidth;
                int k = 1;
                while (k < spec.hSpan) {
                    if (c + k <= this.numColumns) {
                        if (!this.makeColumnsEqualWidth) {
                            columnWidth = columnWidths[c + k];
                        }
                        spannedWidth = spannedWidth + columnWidth + this.horizontalSpacing;
                    }
                    ++k;
                }
                spannedHeight = rowHeight;
                int k2 = 1;
                while (k2 < spec.verticalSpan) {
                    if (r + k2 <= this.grid.size()) {
                        spannedHeight = spannedHeight + rowHeights[r + k2] + this.verticalSpacing;
                    }
                    ++k2;
                }
                if (spec.isItemData()) {
                    Control child = children[spec.childIndex];
                    Point childExtent = child.computeSize(spec.widthHint, spec.heightHint, flushCache);
                    hAlign = spec.horizontalAlignment;
                    widgetX = columnX;
                    widgetX = hAlign == 2 ? widgetX + spannedWidth / 2 - childExtent.x / 2 : (hAlign == 3 ? widgetX + spannedWidth - childExtent.x - spec.horizontalIndent : (widgetX += spec.horizontalIndent));
                    if (hAlign == 4) {
                        widgetW = spannedWidth - spec.horizontalIndent;
                        widgetX = columnX + spec.horizontalIndent;
                    } else {
                        widgetW = childExtent.x;
                    }
                    vAlign = spec.verticalAlignment;
                    widgetY = rowY;
                    if (vAlign == 2) {
                        widgetY = widgetY + spannedHeight / 2 - childExtent.y / 2;
                    } else if (vAlign == 3) {
                        widgetY = widgetY + spannedHeight - childExtent.y;
                    }
                    if (vAlign == 4) {
                        widgetH = spannedHeight;
                        widgetY = rowY;
                    } else {
                        widgetH = childExtent.y;
                    }
                    child.setBounds(widgetX, widgetY, widgetW, widgetH);
                }
                columnX = columnX + columnWidths[c] + this.horizontalSpacing;
                ++c;
            }
            rowY = rowY + rowHeights[r] + this.verticalSpacing;
            columnX = this.marginWidth + composite.getClientArea().x;
            ++r;
        }
    }
}

