/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XAnyEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XtWidgetGeometry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Button
extends Control {
    Image image;
    Image bitmap;
    Image disabled;
    static final byte[] ARM_AND_ACTIVATE;

    public Button(Composite parent, int style) {
        super(parent, Button.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        if (((style = Widget.checkBits(style, 8, 4, 32, 16, 2, 0)) & 8) != 0) {
            return Widget.checkBits(style, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((style & 0x32) != 0) {
            return Widget.checkBits(style, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((style & 4) != 0) {
            return Widget.checkBits(style, 128, 1024, 16384, 131072, 0, 0);
        }
        return style;
    }

    void click() {
        OS.XtCallActionProc(this.handle, ARM_AND_ACTIVATE, new XAnyEvent(), null, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        if ((this.style & 4) != 0) {
            Display display = this.getDisplay();
            width += display.scrolledMarginX;
            height += display.scrolledMarginY;
            if (wHint != -1) {
                width = wHint + border * 2;
            }
            if (hHint != -1) {
                height = hHint + border * 2;
            }
            return new Point(width, height);
        }
        XtWidgetGeometry result = new XtWidgetGeometry();
        result.request_mode = 12;
        int[] argList2 = new int[]{OS.XmNrecomputeSize, 1};
        OS.XtSetValues(this.handle, argList2, argList2.length / 2);
        OS.XtQueryGeometry(this.handle, null, result);
        int[] argList3 = new int[]{OS.XmNrecomputeSize, 0};
        OS.XtSetValues(this.handle, argList3, argList3.length / 2);
        width += result.width;
        height += result.height;
        int[] argList = new int[]{OS.XmNlabelType, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (argList[1] == 2) {
            int[] argList1 = new int[]{OS.XmNlabelString, 0};
            OS.XtGetValues(this.handle, argList1, argList1.length / 2);
            int xmString = argList1[1];
            if (OS.XmStringEmpty(xmString)) {
                height += this.getFontHeight();
            }
            if (xmString != 0) {
                OS.XmStringFree(xmString);
            }
        }
        if (wHint != -1 || hHint != -1) {
            int[] argList4 = new int[]{OS.XmNmarginLeft, 0, OS.XmNmarginRight, 0, OS.XmNmarginTop, 0, OS.XmNmarginBottom, 0};
            OS.XtGetValues(this.handle, argList4, argList4.length / 2);
            if (wHint != -1) {
                width = wHint + argList4[1] + argList4[3] + border * 2;
            }
            if (hHint != -1) {
                height = hHint + argList4[5] + argList4[7] + border * 2;
            }
        }
        return new Point(width, height);
    }

    void createHandle(int index) {
        this.state |= 0x800;
        int borderWidth = (this.style & 0x800) != 0 ? 1 : 0;
        int parentHandle = this.parent.handle;
        if ((this.style & 4) != 0) {
            int alignment = 0;
            if ((this.style & 0x80) != 0) {
                alignment = 0;
            }
            if ((this.style & 0x400) != 0) {
                alignment = 1;
            }
            if ((this.style & 0x4000) != 0) {
                alignment = 2;
            }
            if ((this.style & 0x20000) != 0) {
                alignment = 3;
            }
            int[] argList = new int[]{OS.XmNtraversalOn, 0, OS.XmNarrowDirection, alignment, OS.XmNborderWidth, borderWidth, OS.XmNancestorSensitive, 1};
            this.handle = OS.XmCreateArrowButton(parentHandle, null, argList, argList.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            if ((this.style & 0x800000) != 0) {
                int[] argList1 = new int[]{OS.XmNbottomShadowColor, 0};
                OS.XtGetValues(this.handle, argList1, argList1.length / 2);
                int[] argList2 = new int[]{OS.XmNshadowThickness, 1, OS.XmNtopShadowColor, argList1[1]};
                OS.XtSetValues(this.handle, argList2, argList2.length / 2);
            }
            return;
        }
        int alignment = 0;
        if ((this.style & 0x1000000) != 0) {
            alignment = 1;
        }
        if ((this.style & 0x20000) != 0) {
            alignment = 2;
        }
        if ((this.style & 2) != 0) {
            Display display = this.getDisplay();
            int thickness = display.buttonShadowThickness;
            int[] argList = new int[]{OS.XmNancestorSensitive, 1, OS.XmNrecomputeSize, 0, OS.XmNindicatorOn, 0, OS.XmNshadowThickness, (this.style & 0x800000) != 0 ? 1 : thickness, OS.XmNalignment, alignment, OS.XmNborderWidth, borderWidth};
            this.handle = OS.XmCreateToggleButton(parentHandle, null, argList, argList.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            if ((this.style & 0x800000) != 0) {
                int[] argList1 = new int[]{OS.XmNbottomShadowColor, 0};
                OS.XtGetValues(this.handle, argList1, argList1.length / 2);
                int[] argList2 = new int[]{OS.XmNtopShadowColor, argList1[1]};
                OS.XtSetValues(this.handle, argList2, argList2.length / 2);
            }
            return;
        }
        if ((this.style & 0x30) != 0) {
            int indicatorType = 2;
            if ((this.style & 0x20) != 0) {
                indicatorType = 1;
            }
            int[] argList = new int[]{OS.XmNancestorSensitive, 1, OS.XmNrecomputeSize, 0, OS.XmNindicatorType, indicatorType, OS.XmNalignment, alignment, OS.XmNborderWidth, borderWidth};
            this.handle = OS.XmCreateToggleButton(parentHandle, null, argList, argList.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            return;
        }
        int[] argList = new int[]{OS.XmNancestorSensitive, 1, OS.XmNrecomputeSize, 0, OS.XmNalignment, alignment, OS.XmNborderWidth, borderWidth};
        this.handle = OS.XmCreatePushButton(parentHandle, null, argList, argList.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 0x800000) != 0) {
            int[] argList1 = new int[]{OS.XmNbottomShadowColor, 0};
            OS.XtGetValues(this.handle, argList1, argList1.length / 2);
            int[] argList2 = new int[]{OS.XmNshadowThickness, 1, OS.XmNtopShadowColor, argList1[1]};
            OS.XtSetValues(this.handle, argList2, argList2.length / 2);
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        if ((this.style & 8) == 0) {
            return;
        }
        if (this.getShell().parent == null) {
            return;
        }
        int[] argList = new int[]{OS.XmNdefaultButtonShadowThickness, 1};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    int defaultBackground() {
        return this.getDisplay().buttonBackground;
    }

    Font defaultFont() {
        return this.getDisplay().buttonFont;
    }

    int defaultForeground() {
        return this.getDisplay().buttonForeground;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int[] argList = new int[]{OS.XmNarrowDirection, 0};
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            int direction = argList[1];
            if (direction == 0) {
                return 128;
            }
            if (direction == 1) {
                return 1024;
            }
            if (direction == 2) {
                return 16384;
            }
            if (direction == 3) {
                return 131072;
            }
            return 128;
        }
        int[] argList = new int[]{OS.XmNalignment, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int alignment = argList[1];
        if (alignment == 0) {
            return 16384;
        }
        if (alignment == 1) {
            return 0x1000000;
        }
        if (alignment == 2) {
            return 131072;
        }
        return 0x1000000;
    }

    boolean getDefault() {
        if ((this.style & 8) == 0) {
            return false;
        }
        int[] argList = new int[]{OS.XmNshowAsDefault, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1] != 0;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        int[] argList = new int[]{OS.XmNset, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1] != 0;
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        int[] argList = new int[]{OS.XmNlabelString, 0, OS.XmNmnemonic, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int xmString = argList[1];
        int mnemonic = argList[3];
        if (mnemonic == 0xFFFFFF) {
            mnemonic = 0;
        }
        if (xmString == 0) {
            this.error(12);
        }
        char[] result = null;
        int address = OS.XmStringUnparse(xmString, null, 0, 0, null, 0, 0);
        if (address != 0) {
            int length = OS.strlen(address);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, address, length);
            OS.XtFree(address);
            result = Converter.mbcsToWcs(this.getCodePage(), buffer);
        }
        OS.XmStringFree(xmString);
        int count = 0;
        if (mnemonic != 0) {
            ++count;
        }
        int i = 0;
        while (i < result.length - 1) {
            if (result[i] == '&') {
                ++count;
            }
            ++i;
        }
        char[] newResult = result;
        if (count != 0 || mnemonic != 0) {
            newResult = new char[result.length + count];
            int i2 = 0;
            int j = 0;
            while (i2 < result.length) {
                if (mnemonic != 0 && result[i2] == mnemonic) {
                    if (j < newResult.length) {
                        newResult[j++] = 38;
                    }
                    mnemonic = 0;
                }
                if ((newResult[j++] = result[i2++]) != '&' || j >= newResult.length) continue;
                newResult[j++] = 38;
            }
        }
        return new String(newResult);
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.getDisplay().windowProc;
        if ((this.style & 0x32) != 0) {
            OS.XtAddCallback(this.handle, OS.XmNvalueChangedCallback, windowProc, 25);
        } else {
            OS.XtAddCallback(this.handle, OS.XmNactivateCallback, windowProc, 9);
        }
    }

    boolean mnemonicHit(char key) {
        if (!this.setFocus()) {
            return false;
        }
        this.click();
        return true;
    }

    boolean mnemonicMatch(char key) {
        char mnemonic = this.findMnemonic(this.getText());
        if (mnemonic == '\u0000') {
            return false;
        }
        return Character.toUpperCase(key) == Character.toUpperCase(mnemonic);
    }

    void releaseWidget() {
        super.releaseWidget();
        int[] argList = new int[]{OS.XmNlabelPixmap, 2, OS.XmNlabelInsensitivePixmap, 2};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        if (this.bitmap != null) {
            this.bitmap.dispose();
        }
        if (this.disabled != null) {
            this.disabled.dispose();
        }
        this.disabled = null;
        this.bitmap = null;
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectRadio() {
        Control[] children = this.parent._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (this != child) {
                child.setRadioSelection(false);
            }
            ++i;
        }
        this.setSelection(true);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int[] argList = new int[]{OS.XmNarrowDirection, 0};
            if ((alignment & 0x80) != 0) {
                argList[1] = 0;
            }
            if ((alignment & 0x400) != 0) {
                argList[1] = 1;
            }
            if ((alignment & 0x4000) != 0) {
                argList[1] = 2;
            }
            if ((alignment & 0x20000) != 0) {
                argList[1] = 3;
            }
            OS.XtSetValues(this.handle, argList, argList.length / 2);
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNalignment, 0};
        if ((alignment & 0x1000000) != 0) {
            argList[1] = 1;
        }
        if ((alignment & 0x20000) != 0) {
            argList[1] = 2;
        }
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
        int[] argList = new int[]{OS.XmNlabelType, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (argList[1] == 1) {
            this.setBitmap(this.image);
        }
    }

    void setBitmap(Image image) {
        int labelPixmap = 2;
        int labelInsensitivePixmap = 2;
        if (this.bitmap != null) {
            this.bitmap.dispose();
        }
        if (this.disabled != null) {
            this.disabled.dispose();
        }
        this.disabled = null;
        this.bitmap = null;
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            Display display = this.getDisplay();
            switch (image.type) {
                case 0: {
                    labelPixmap = image.pixmap;
                    this.disabled = new Image((Device)display, image, 1);
                    labelInsensitivePixmap = this.disabled.pixmap;
                    break;
                }
                case 1: {
                    Rectangle rect = image.getBounds();
                    this.bitmap = new Image((Device)display, rect.width, rect.height);
                    GC gc = new GC(this.bitmap);
                    gc.setBackground(this.getBackground());
                    gc.fillRectangle(rect);
                    gc.drawImage(image, 0, 0);
                    gc.dispose();
                    labelPixmap = this.bitmap.pixmap;
                    this.disabled = new Image((Device)display, this.bitmap, 1);
                    labelInsensitivePixmap = this.disabled.pixmap;
                    break;
                }
                default: {
                    this.error(20);
                }
            }
        }
        int[] argList = new int[]{OS.XmNlabelType, 1, OS.XmNlabelPixmap, labelPixmap, OS.XmNlabelInsensitivePixmap, labelInsensitivePixmap};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    void setDefault(boolean value) {
        if ((this.style & 8) == 0) {
            return;
        }
        if (this.getShell().parent == null) {
            return;
        }
        int[] argList = new int[]{OS.XmNshowAsDefault, value ? 1 : 0};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.image = image;
        this.setBitmap(this.image);
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNset, selected ? 1 : 0};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        this.updateShadows();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        char[] text = new char[string.length()];
        string.getChars(0, text.length, text, 0);
        int i = 0;
        int j = 0;
        int mnemonic = 0;
        while (i < text.length) {
            if ((text[j++] = text[i++]) != '&' || i == text.length) continue;
            if (text[i] == '&') {
                ++i;
                continue;
            }
            if (mnemonic == 0) {
                mnemonic = text[i];
            }
            --j;
        }
        while (j < text.length) {
            text[j++] = '\u0000';
        }
        byte[] buffer = Converter.wcsToMbcs(this.getCodePage(), text, true);
        int xmString = OS.XmStringParseText(buffer, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        if (xmString == 0) {
            this.error(13);
        }
        if (mnemonic == 0) {
            mnemonic = 0xFFFFFF;
        }
        int[] argList = new int[]{OS.XmNlabelType, 2, OS.XmNlabelString, xmString, OS.XmNmnemonic, mnemonic};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        if (xmString != 0) {
            OS.XmStringFree(xmString);
        }
    }

    int traversalCode(int key, XKeyEvent xEvent) {
        return super.traversalCode(key, xEvent) | 0x80;
    }

    void updateShadows() {
        if ((this.style & 0x800000) != 0 && (this.style & 2) != 0) {
            int[] argList1 = new int[]{OS.XmNset, 0};
            OS.XtGetValues(this.handle, argList1, argList1.length / 2);
            Display display = this.getDisplay();
            int pixel = argList1[1] == 0 ? display.compositeBottomShadow : display.compositeTopShadow;
            int[] argList2 = new int[]{OS.XmNtopShadowColor, pixel};
            OS.XtSetValues(this.handle, argList2, argList2.length / 2);
        }
    }

    int xFocusIn() {
        super.xFocusIn();
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 8) != 0) {
            this.menuShell().setDefaultButton(this, false);
        }
        return 0;
    }

    int xFocusOut() {
        super.xFocusOut();
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 8) != 0 && this.getDefault()) {
            this.menuShell().setDefaultButton(null, false);
        }
        return 0;
    }

    int XmNactivateCallback(int w, int client_data, int call_data) {
        this.postEvent(13);
        return 0;
    }

    int XmNvalueChangedCallback(int w, int client_data, int call_data) {
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.updateShadows();
        this.postEvent(13);
        return 0;
    }

    static {
        String name = "ArmAndActivate";
        int length = name.length();
        char[] unicode = new char[length];
        name.getChars(0, length, unicode, 0);
        byte[] buffer = new byte[length + 1];
        int i = 0;
        while (i < length) {
            buffer[i] = (byte)unicode[i];
            ++i;
        }
        ARM_AND_ACTIVATE = buffer;
    }
}

