/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.RunnableLock;

public class Synchronizer {
    Display display;
    int messageCount;
    RunnableLock[] messages;
    Object messageLock = new Object();
    Thread syncThread;

    public Synchronizer(Display display) {
        this.display = display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLast(RunnableLock lock) {
        Object object = this.messageLock;
        synchronized (object) {
            if (this.messages == null) {
                this.messages = new RunnableLock[4];
            }
            if (this.messageCount == this.messages.length) {
                RunnableLock[] newMessages = new RunnableLock[this.messageCount + 4];
                System.arraycopy(this.messages, 0, newMessages, 0, this.messageCount);
                this.messages = newMessages;
            }
            this.messages[this.messageCount++] = lock;
        }
    }

    protected void asyncExec(Runnable runnable) {
        if (runnable != null) {
            this.addLast(new RunnableLock(runnable));
        }
        this.display.wake();
    }

    void releaseSynchronizer() {
        this.display = null;
        this.messages = null;
        this.messageLock = null;
        this.syncThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RunnableLock removeFirst() {
        Object object = this.messageLock;
        synchronized (object) {
            if (this.messageCount == 0) {
                return null;
            }
            RunnableLock lock = this.messages[0];
            System.arraycopy(this.messages, 1, this.messages, 0, --this.messageCount);
            this.messages[this.messageCount] = null;
            if (this.messageCount == 0) {
                this.messages = null;
            }
            return lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean runAsyncMessages() {
        if (this.messageCount == 0) {
            return false;
        }
        RunnableLock lock = this.removeFirst();
        if (lock == null) {
            return true;
        }
        RunnableLock runnableLock = lock;
        synchronized (runnableLock) {
            this.syncThread = lock.thread;
            try {
                try {
                    lock.run();
                }
                catch (Throwable t) {
                    lock.throwable = t;
                    SWT.error(46, t);
                    Object var5_4 = null;
                    this.syncThread = null;
                    lock.notifyAll();
                }
                Object var5_3 = null;
                this.syncThread = null;
                lock.notifyAll();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.syncThread = null;
                lock.notifyAll();
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncExec(Runnable runnable) {
        if (this.display.isValidThread()) {
            if (runnable != null) {
                runnable.run();
            }
            return;
        }
        if (runnable == null) {
            this.display.wake();
            return;
        }
        RunnableLock lock = new RunnableLock(runnable);
        lock.thread = Thread.currentThread();
        RunnableLock runnableLock = lock;
        synchronized (runnableLock) {
            this.addLast(lock);
            this.display.wake();
            boolean interrupted = false;
            while (!lock.done()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Compatibility.interrupt();
            }
            if (lock.throwable != null) {
                SWT.error(46, lock.throwable);
            }
        }
    }
}

