/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    TabFolder parent;
    int x;
    int y;
    int width;
    int height = 0;
    String toolTipText;
    Control control;
    static final int LEFT_HORIZONTAL_MARGIN = 8;
    static final int RIGHT_HORIZONTAL_MARGIN = 2;
    static final int VERTICAL_MARGIN = 1;
    static final int ICON_MARGIN = 6;
    static final int SHADOW_WIDTH = 2;
    static final int DEFAULT_TEXT_WIDTH = 36;

    public TabItem(TabFolder parent, int style) {
        this(parent, style, parent.getItemCount());
    }

    public TabItem(TabFolder parent, int style, int index) {
        super(parent, style);
        parent.createChild(this, index);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        super.dispose();
        this.parent.destroyChild(this);
        this.parent = null;
        this.control = null;
        this.toolTipText = null;
    }

    void expand(int left, int top, int right, int bottom) {
        if (this.hasLocation()) {
            this.x -= left;
            this.y -= top;
            this.width = this.width + left + right;
            this.height = this.height + top + bottom;
        }
    }

    Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Display getDisplay() {
        if (this.parent == null) {
            this.error(24);
        }
        return this.parent.getDisplay();
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    boolean hasLocation() {
        return this.width != 0 || this.height != 0 || this.x != 0 || this.y != 0;
    }

    private int imageHeight() {
        Image image = this.getImage();
        if (this.parent.getImageHeight() != -1) {
            return this.parent.getImageHeight();
        }
        if (image != null && !image.isDisposed()) {
            return image.getBounds().height;
        }
        return 0;
    }

    private int imageWidth() {
        Image image = this.getImage();
        if (image != null && !image.isDisposed()) {
            return image.getBounds().width;
        }
        return 0;
    }

    void paint(GC gc, boolean isSelected) {
        int yCenter;
        gc.setForeground(this.parent.getDisplay().getSystemColor(20));
        gc.drawLine(this.x, this.y + this.height - 2, this.x, this.y + 2);
        gc.drawLine(this.x, this.y + 2, this.x + 2, this.y);
        gc.drawLine(this.x + 2, this.y, this.x + this.width - 3, this.y);
        gc.setForeground(this.parent.getDisplay().getSystemColor(19));
        gc.drawLine(this.x + 1, this.y + this.height - 2, this.x + 1, this.y + 2);
        gc.drawLine(this.x + 2, this.y + 1, this.x + this.width - 3, this.y + 1);
        gc.setForeground(this.parent.getDisplay().getSystemColor(21));
        gc.drawLine(this.x + this.width - 1, this.y + 2, this.x + this.width - 1, this.y + this.height - 1);
        gc.drawLine(this.x + this.width - 2, this.y + 1, this.x + this.width - 2, this.y + 1);
        gc.setForeground(this.parent.getDisplay().getSystemColor(18));
        gc.drawLine(this.x + this.width - 2, this.y + 2, this.x + this.width - 2, this.y + this.height - 1);
        if (this.parent.isFocusControl() && isSelected) {
            gc.drawFocus(this.x + 3, this.y + 3, this.width - 6, this.height - 3);
        }
        gc.setForeground(this.parent.getForeground());
        int xDraw = this.x + 8;
        int decorationHeight = 6;
        Image image = this.getImage();
        Rectangle sourceBounds = null;
        if (image != null) {
            sourceBounds = image.getBounds();
            yCenter = this.y + 2 + 1 + (this.height - decorationHeight - this.imageHeight()) / 2;
            gc.drawImage(image, sourceBounds.x, sourceBounds.y, sourceBounds.width, sourceBounds.height, xDraw, yCenter, sourceBounds.width, this.parent.getImageHeight());
        }
        xDraw += 6;
        if (sourceBounds != null) {
            xDraw += sourceBounds.width;
        }
        yCenter = this.y + 2 + 1 + (this.height - decorationHeight - this.textHeight(gc)) / 2;
        int flags = 8;
        gc.drawText(this.getText(), xDraw, yCenter, flags);
    }

    int preferredHeight(GC gc) {
        int height = this.textHeight(gc);
        if (this.imageHeight() > height) {
            height = this.imageHeight();
        }
        return height += 6;
    }

    int preferredWidth(GC gc) {
        return this.imageWidth() + this.textWidth(gc) + 8 + 2 + 6 + 4;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control oldControl = this.control;
        Control newControl = control;
        this.control = control;
        int index = this.parent.indexOf(this);
        if (index != this.parent.getSelectionIndex()) {
            if (newControl != null) {
                newControl.setVisible(false);
            }
            return;
        }
        if (newControl != null) {
            newControl.setBounds(this.parent.getClientArea());
            newControl.setVisible(true);
        }
        if (oldControl != null) {
            oldControl.setVisible(false);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        Image oldImage = this.image;
        super.setImage(image);
        if (image == null || !image.equals(oldImage)) {
            this.parent.itemChanged(this);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        String oldText = this.text;
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        if (!string.equals(oldText)) {
            this.parent.itemChanged(this);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    private int textHeight(GC gc) {
        String text = this.getText();
        if (text == null) {
            return 0;
        }
        int flags = 8;
        return gc.textExtent((String)text, (int)flags).y;
    }

    private int textWidth(GC gc) {
        String text = this.getText();
        int textWidth = 0;
        if (text != null) {
            int flags = 8;
            textWidth = gc.textExtent((String)text, (int)flags).x;
        }
        if (textWidth == 0) {
            textWidth = 36;
        }
        return textWidth;
    }
}

