/*
 * Decompiled with CFR 0.152.
 */
package org.argosdic.dictionary;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.argosdic.dictionary.DictionaryServer;
import org.argosdic.dictionary.SearchHistory;
import org.argosdic.resource.ResourceManager;
import org.argosdic.util.MimeTypeMap;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ServerWorker
implements Runnable {
    public static final long EXPIRATION = 1827387392L;
    private static Log log = LogFactory.getLog(ServerWorker.class);
    private DictionaryServer server;
    private ServerSocket socket;
    private String htmlDir;
    private String serverName;
    private MimeTypeMap mimeMap;
    private String systemCharset;
    private DateFormat df;
    private int id;
    static /* synthetic */ Class class$0;

    protected ServerWorker(DictionaryServer server, ServerSocket socket, int id) {
        Assert.isNotNull((Object)server);
        Assert.isNotNull((Object)socket);
        this.id = id;
        this.server = server;
        this.socket = socket;
        this.htmlDir = server.getHtmlDir();
        this.mimeMap = MimeTypeMap.getInstance();
        ResourceManager resources = ResourceManager.getInstance();
        this.systemCharset = resources.getString("default.charset");
        this.serverName = resources.getString("http.server");
        this.df = new SimpleDateFormat("E, dd M yyyy HH:mm:ss z", Locale.ENGLISH);
        this.df.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private String getResponseHeader(int code, String msg) {
        return null;
    }

    public void run() {
        BufferedReader reader = null;
        OutputStream out = null;
        String word = null;
        while (!this.socket.isClosed()) {
            try {
                try {
                    Socket clientSocket = this.socket.accept();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Accepting new client - worker: " + this.id));
                    }
                    InputStream in = clientSocket.getInputStream();
                    out = clientSocket.getOutputStream();
                    reader = new BufferedReader(new InputStreamReader(in));
                    String resource = null;
                    Date ifModifiedSince = null;
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        if (line.trim().length() == 0) break;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Request header : " + line));
                        }
                        if (line.startsWith("GET")) {
                            StringTokenizer tokenizer = new StringTokenizer(line);
                            if (tokenizer.countTokens() <= 2) continue;
                            tokenizer.nextToken();
                            resource = tokenizer.nextToken();
                            if (!resource.startsWith("/")) continue;
                            resource = resource.substring(1);
                            continue;
                        }
                        if (!line.toLowerCase().startsWith("if-modified-since")) continue;
                        String value = line.substring(line.indexOf(":") + 1).trim();
                        try {
                            ifModifiedSince = this.df.parse(value);
                        }
                        catch (Exception e) {
                            if (!log.isWarnEnabled()) continue;
                            log.warn((Object)("Unable to parse date header : " + value), (Throwable)e);
                        }
                    }
                    resource = URLDecoder.decode(resource, this.systemCharset);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Finished reading client request - worker : " + this.id));
                    }
                    if (resource == null) continue;
                    IndexSearcher searcher = this.server.getSearcher();
                    if (resource.endsWith(".dic") && searcher != null) {
                        Hits hits;
                        int matches;
                        SearchHistory history;
                        Document document;
                        word = resource.substring(0, resource.length() - 4);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Searching for : " + word));
                        }
                        if ((document = (history = this.server.getSearchHistory()).get(word)) == null && (matches = (hits = this.server.search(word)).length()) > 0) {
                            int i = 0;
                            while (i < matches) {
                                Document doc = hits.doc(i);
                                if (word.equalsIgnoreCase(doc.getField("word").stringValue())) {
                                    document = doc;
                                    break;
                                }
                                ++i;
                            }
                            if (document == null) {
                                document = hits.doc(0);
                            }
                        }
                        if (document == null) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Writing server response... - worker : " + this.id));
                        }
                        Map headers = this.getDefaultHeaders();
                        headers.put("Cache-Control", "no-cache");
                        String header = this.server.getHttpHeader(200, "OK", headers);
                        FontData font = this.server.getFont();
                        Object[] args = new String[]{word, this.server.getDictionary().getCharset(), font.getName(), Integer.toString(font.getHeight()), document.getField("definition").stringValue()};
                        out.write(header.getBytes());
                        out.write(this.server.getHtmlContent(args).getBytes());
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Processing resource : " + resource));
                    }
                    StringBuffer buffer = new StringBuffer(this.htmlDir);
                    buffer.append(File.separator);
                    buffer.append(resource.replace('/', File.separatorChar));
                    File file = new File(buffer.toString());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("File name : " + file.getAbsolutePath()));
                    }
                    if (!file.exists() || file.isDirectory()) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("The specified file has not been found : " + file.getAbsolutePath()));
                        }
                        String header = this.server.getHttpHeader(404, "NOT FOUND");
                        out.write(header.getBytes());
                        out.write("The specified resource has not been found.".getBytes());
                        continue;
                    }
                    Date lastModified = new Date(file.lastModified());
                    if (ifModifiedSince != null && !ifModifiedSince.before(lastModified)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Using cached content : " + file.getAbsolutePath()));
                        }
                        String header = this.server.getHttpHeader(304);
                        out.write(header.getBytes());
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Writing file content...");
                    }
                    String contentType = this.mimeMap.getContentTypeFor(resource);
                    String length = Long.toString(file.length());
                    Date expires = new Date(System.currentTimeMillis() + 1827387392L);
                    Map headers = this.getDefaultHeaders();
                    headers.put("Last-Modified", this.df.format(lastModified));
                    headers.put("Accept-Ranges", "bytes");
                    headers.put("Content-Type", contentType);
                    headers.put("Content-Length", length);
                    headers.put("Expires", this.df.format(expires));
                    String header = this.server.getHttpHeader(200, "OK", headers);
                    out.write(header.getBytes());
                    FilterOutputStream dout = null;
                    InputStream fin = null;
                    try {
                        in = new DataInputStream(new FileInputStream(file));
                        in = new BufferedInputStream(in);
                        out = new BufferedOutputStream(out);
                        dout = new DataOutputStream(out);
                        int data = -1;
                        while ((data = in.read()) != -1) {
                            ((DataOutputStream)dout).writeByte(data);
                        }
                        ((DataOutputStream)dout).flush();
                    }
                    finally {
                        if (fin != null) {
                            try {
                                fin.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (dout != null) {
                            try {
                                dout.close();
                            }
                            catch (IOException ie) {}
                        }
                    }
                }
                catch (ParseException e) {
                    ResourceManager resources = ResourceManager.getInstance();
                    Shell parent = Display.getCurrent().getActiveShell();
                    String title = resources.getString("dialog.title.warning");
                    String msg = resources.getString("error.message.query");
                    MessageDialog.openWarning((Shell)parent, (String)title, (String)msg);
                }
                catch (SocketException e) {
                    this.socket.isClosed();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private Map getDefaultHeaders() {
        Date currentTime = new Date(System.currentTimeMillis());
        HashMap<String, String> headers = new HashMap<String, String>(10);
        headers.put("Connection", "close");
        headers.put("Server", this.serverName);
        headers.put("Date", this.df.format(currentTime));
        return headers;
    }
}

