/*
 * Decompiled with CFR 0.152.
 */
package org.argosdic.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.FileNameMap;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.util.Assert;

public class MimeTypeMap
implements FileNameMap {
    static Log log = LogFactory.getLog(MimeTypeMap.class);
    private static MimeTypeMap instance;
    private static final String MIME_TYPES = "/org/argosdic/resource/mime.types";
    public static final String MIME_DEFAULT = "application/octet-stream";
    private Map map = new HashMap(100);
    static /* synthetic */ Class class$0;

    private MimeTypeMap() {
        BufferedReader reader = null;
        if (log.isInfoEnabled()) {
            log.info((Object)"Initializing MimeTypeMap...");
        }
        try {
            try {
                InputStream in = this.getClass().getResourceAsStream(MIME_TYPES);
                Assert.isNotNull((Object)in);
                reader = new BufferedReader(new InputStreamReader(in));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    StringTokenizer tokenizer = new StringTokenizer(line);
                    if (!tokenizer.hasMoreTokens()) continue;
                    String type = tokenizer.nextToken().trim();
                    String ext = null;
                    if (type.startsWith("#")) continue;
                    while (tokenizer.hasMoreTokens()) {
                        ext = tokenizer.nextToken().trim();
                        this.map.put(ext, type);
                    }
                }
            }
            catch (IOException e) {
                if (log.isWarnEnabled()) {
                    String msg = "Unable to initialize MimeTypeMap.";
                    log.warn((Object)msg, (Throwable)e);
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"MimeTypeMap has been initialized successfully.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MimeTypeMap getInstance() {
        if (instance != null) return instance;
        Class<MimeTypeMap> clazz = MimeTypeMap.class;
        synchronized (MimeTypeMap.class) {
            instance = new MimeTypeMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getContentTypeFor(String fileName) {
        Assert.isNotNull((Object)fileName);
        Assert.isNotNull((Object)this.map);
        if (log.isDebugEnabled()) {
            log.info((Object)("File name : " + fileName));
        }
        String ext = null;
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            ext = fileName.substring(index + 1).trim().toLowerCase();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking for extension : " + ext));
        }
        String contentType = (String)this.map.get(ext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found mime type : " + contentType));
        }
        if (contentType == null) {
            contentType = MIME_DEFAULT;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using default mime type : application/octet-stream");
            }
        }
        return contentType;
    }
}

