package org.argosdic.action;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.util.Assert;

/**
 * ActionMap.java
 * @author Xavier Cho
 * @version $Revision: 1.1 $ $Date: 2003/09/12 10:23:53 $
 */
public class ActionMap {
    private Map actions;
    private ActionMap parent;

    public ActionMap() {
        this(null);
    }

    public ActionMap(ActionMap parent) {
        this.actions = new HashMap(20);
        this.parent = parent;
    }

    public BaseAction get(String name) {
        Assert.isNotNull(name);

        BaseAction action = (BaseAction) actions.get(name);

        if (action == null && parent != null) {
            action = parent.get(name);
        }

        return action;
    }

    public void put(BaseAction action) {
        Assert.isNotNull(action);

        actions.put(action.getId(), action);
    }

    public int getSize() {
        return actions.size();
    }

    public ActionMap getParent() {
        return parent;
    }

    public void setParent(ActionMap parent) {
        this.parent = parent;
    }
}