package org.argosdic.action;

import org.argosdic.ArgosDic;
import org.argosdic.resource.ResourceManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Assert;

/**
 * BaseAction.java
 * @author Xavier Cho
 * @version $Revision: 1.1 $ $Date: 2003/09/12 10:23:53 $
 */
public abstract class BaseAction extends Action {
    public static final String ACCELERATOR = "accelerator"; //$NON-NLS-1$

    protected ArgosDic application;

    private BaseAction() {
    }

    public BaseAction(ArgosDic application) {
        this(application, IAction.AS_UNSPECIFIED);
    }

    public BaseAction(ArgosDic application, int style) {
        super(null, style);

        Assert.isNotNull(application);

        this.application = application;

        ResourceManager resources = ResourceManager.getInstance();

        String prefix = getId().concat("."); //$NON-NLS-1$

        setText(resources.getString(prefix.concat(TEXT)));
        setDescription(resources.getString(prefix.concat(DESCRIPTION)));
        setImageDescriptor(resources.getImage(prefix.concat(IMAGE)));
        setToolTipText(getDescription());

        String accelerator = resources.getString(prefix.concat(ACCELERATOR));
        if (accelerator != null) {
            setAccelerator(Action.convertAccelerator(accelerator));
        }
    }

    public String getId() {
        return getClass().getName();
    }
}