package org.argosdic.action.program;

import org.argosdic.ArgosDic;
import org.argosdic.action.BaseAction;
import org.argosdic.preference.DictionaryPreferencePage;
import org.argosdic.resource.ResourceManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

/**
 * SettingsAction.java
 * @author Xavier Cho
 * @version $Revision: 1.3 $ $Date: 2003/10/12 10:49:23 $
 */
public class SettingsAction extends BaseAction {
    private PreferenceManager preferenceManager;

    public SettingsAction(ArgosDic application) {
        super(application);
    }

    /**
     * @see org.eclipse.jface.action.IAction#runWithEvent(org.eclipse.swt.widgets.Event)
     */
    public void runWithEvent(Event event) {
        Shell shell = application.getShell();

        if(preferenceManager==null) {
            createPreferenceManager();
        }

        PreferenceDialog dialog = 
            new PreferenceDialog(shell, preferenceManager);

        IPreferenceStore preferences = JFacePreferences.getPreferenceStore();

        dialog.setPreferenceStore(preferences);
        dialog.setMinimumPageSize(380, 280);
        dialog.open();
    }

    protected void createPreferenceManager() {
        this.preferenceManager = new PreferenceManager();

        ResourceManager resources = ResourceManager.getInstance();

        PreferenceNode node = new PreferenceNode(
            DictionaryPreferencePage.NAME, 
            resources.getString("preference.dictionary"),  //$NON-NLS-1$
            null, 
            DictionaryPreferencePage.class.getName());

        preferenceManager.addToRoot(node);
    }
}
