package org.argosdic.dictionary;

import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.TypedEvent;

/**
 * DictionaryEvent.java
 * @author Xavier Cho
 * @version $Revision: 1.1 $ $Date: 2003/09/12 10:23:53 $
 */
public class DictionaryEvent extends TypedEvent {
    private Dictionary dictionary; 

    /**
     * @param source
     */
    public DictionaryEvent(Object source) {
        this(source, null);
    }

	/**
     * @param source
	 * @param dictionary
	 */
	public DictionaryEvent(Object source, Dictionary dictionary) {
		super(source);

        Assert.isNotNull(source);

        this.dictionary = dictionary;
	}

	public Dictionary getDictionary() {
		return dictionary;
	}
}
