package viewer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

import javax.swing.JLabel;
import javax.swing.JPanel;

import collection.Tree;
import datatypes.CallGraphInfo;

public class CallGraphInfoPanel extends JPanel {
	private Tree<CallGraphInfo> info;
	private JLabel funcName;
	private JLabel name;
	private JLabel self;
	private JLabel child;
	private JLabel nameDes;
	private JLabel selfDes;
	private JLabel childDes;
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 7093422094390228275L;
	
	public CallGraphInfoPanel(){
		this.setLayout(null);
		funcName = new JLabel();
		funcName.setBounds(35, 65, 290, 60);
		funcName.setHorizontalAlignment(JLabel.CENTER);
		funcName.setFont(new Font(null, Font.BOLD, 17));
		this.add(funcName);
		name = new JLabel("Name");
		name.setBounds(360, 55, 80, 20);
		this.add(name);
		self = new JLabel("Self Time");
		self.setBounds(360, 85, 80, 20);
		this.add(self);
		child = new JLabel("Children Time");
		child.setBounds(360, 115, 80, 20);
		this.add(child);
		nameDes = new JLabel();
		nameDes.setBounds(460, 55, 280, 20);
		this.add(nameDes);
		selfDes = new JLabel();
		selfDes.setBounds(460, 85, 280, 20);
		this.add(selfDes);
		childDes = new JLabel();
		childDes.setBounds(460, 115, 280, 20);
		this.add(childDes);
	}
	
	@Override
	protected void paintComponent(Graphics g) {
		// TODO Auto-generated method stub
		super.paintComponent(g);
		g.setFont(new Font(null, Font.BOLD, 15));
		g.drawString(" Լ ", 20, 25);
		
		if(info == null){
			g.setColor(new Color(255, 255, 255));
		}
		else{
			g.setColor(new Color(220, 220, 255));
		}
		g.fillRect(30, 45, 300, 100);
		g.setColor(new Color(0, 0, 0));
		g.drawRect(30, 45, 300, 100);
		g.drawRect(350, 50, 100, 30);
		g.drawRect(350, 80, 100, 30);
		g.drawRect(350, 110, 100, 30);
		g.drawRect(450, 50, 300, 30);
		g.drawRect(450, 80, 300, 30);
		g.drawRect(450, 110, 300, 30);
	}
	public void setInfo(Tree<CallGraphInfo> info) {
		this.info = info;
		funcName.setText(this.info.getData().getName());
		nameDes.setText(this.info.getData().getName());
		selfDes.setText(""+this.info.getData().getSelf());
		childDes.setText(""+this.info.getData().getChildren());
		this.repaint();
	}

	public Tree<CallGraphInfo> getInfo() {
		return info;
	}
	
}
