package viewer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import collection.Tree;
import datatypes.CallGraphInfo;

public class CallGraphNode extends JPanel{
	private Tree<CallGraphInfo> info;
	public static final int defaultWidth = 120;
	public static final int defaultHight = 50;
	private int positionX, positionY;
	private static float rate = 1.0f;
	private JLabel funcName;
	private RootVisibleButton rootChange;
	private JButton viewSubNode;
	private boolean rootVal;
	private boolean visibleSubNodes = true;
	/**
	 * 
	 */
	private static final long serialVersionUID = -5700739878472594934L;
	
	public CallGraphNode(int posX, int posY, boolean rootVal, Tree<CallGraphInfo> info){
		this.info = info;
		this.positionX = posX;
		this.positionY = posY;
		this.rootVal = rootVal;
				
		this.setBounds(positionX, positionY, (int)(defaultWidth*rate)+1, (int)(defaultHight*rate)+1);
		this.setBackground(new Color(255, 255, 255));
		
		this.setLayout(null);
		
		funcName = new JLabel(info.getData().getName());
		funcName.setHorizontalAlignment(JLabel.CENTER);
		funcName.setBounds(5,25,(int)(defaultWidth*rate)-10,18);
		this.add(funcName);
		
		if(this.rootVal){
			rootChange = new RootVisibleButton("<", this);
		}
		else{
			rootChange = new RootVisibleButton(">", this);
		}
		
		rootChange.setMargin(new Insets(1, 1, 1, 1));
		rootChange.setBounds(5, 5, 20, 20);
		this.add(rootChange);
		
		if(this.visibleSubNodes){
			viewSubNode = new JButton("-");
		}
		else{
			viewSubNode = new JButton("+");
		}
		viewSubNode.setMargin(new Insets(1, 1, 1, 1));
		viewSubNode.setBounds((int)(defaultWidth*rate)-25, 5, 20, 20);
		this.add(viewSubNode);
	}
	
	@Override
	protected void paintComponent(Graphics g) {
		// TODO Auto-generated method stub
		super.paintComponent(g);
		
		g.drawRect(0, 0, (int)(defaultWidth*rate), (int)(defaultHight*rate));
	}
	
	public boolean isRoot(){
		return rootVal;
	}

	public Tree<CallGraphInfo> getInfo() {
		return info;
	}
	
	public void addRootActionListener(ActionListener i){
		this.rootChange.addActionListener(i);
	}
}
