package viewer;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;

import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileNameExtensionFilter;

import parser.VNProfParser;

public class Viewer extends JFrame implements ActionListener{
	private JMenuBar menuBar;
	private JTabbedPane tabArea;
	private File openedFile;
	/**
	 * 
	 */
	private static final long serialVersionUID = 5972479202774146281L;
	
	public Viewer(String title){
		super(title);
		menuBar = new JMenuBar();
		JMenu fileMenu = new JMenu("");
		JMenuItem openItem = new JMenuItem("");
		openItem.addActionListener(this);
		fileMenu.add(openItem);
		menuBar.add(fileMenu);
		menuBar.add(new JMenu(""));
		menuBar.add(new JMenu(""));
		menuBar.add(new JMenu(""));
		menuBar.add(new JMenu(""));
		tabArea = new JTabbedPane();
		
		setJMenuBar(menuBar);

		Container ct = this.getContentPane();
		ct.setLayout(null);
		tabArea.setBounds(10, 10, 985, 650);
		ct.add(tabArea);
		
		setSize(1024, 738);
		setVisible(true);
	}
	
	public static void main(String[] args){
		Viewer v = new Viewer("VNProfiler");
	}


	public void actionPerformed(ActionEvent arg0) {
		// TODO Auto-generated method stub
		JFileChooser chooser = new JFileChooser();
		FileNameExtensionFilter filter = new FileNameExtensionFilter("VNProfiler file", "vnp");
		chooser.setFileFilter(filter);
		int status = chooser.showOpenDialog(null);
		
		if (status == JFileChooser.APPROVE_OPTION) {
			openedFile = chooser.getSelectedFile();
			
			try{
				VNProfParser vnprof = new VNProfParser(new FileInputStream(openedFile));
				vnprof.parse();
				this.setTitle("VNProfiler - " + openedFile.getName());
				tabArea.addTab("Flat Profile", new JScrollPane((new Flat(vnprof.getFlatInfo()).getTable())));
				tabArea.addTab("Call Graph", new CallGraphPanel(vnprof.getCallInfo()));
			}
			catch(Exception e){
				e.printStackTrace();
				System.exit(1);
			}
		}
	}
}